/*
 * Decompiled with CFR 0.152.
 */
package world.data.jdbc.internal.query;

import java.sql.DatabaseMetaData;
import java.sql.ParameterMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import world.data.jdbc.DataWorldConnection;
import world.data.jdbc.DataWorldStatement;
import world.data.jdbc.JdbcCompatibility;
import world.data.jdbc.internal.metadata.ColumnFactory;
import world.data.jdbc.internal.metadata.ColumnInfo;
import world.data.jdbc.internal.metadata.ParameterMetaDataImpl;
import world.data.jdbc.internal.metadata.ResultSetMetaDataImpl;
import world.data.jdbc.internal.metadata.SqlDatabaseMetaData;
import world.data.jdbc.internal.query.QueryEngine;
import world.data.jdbc.internal.results.ResultSetImpl;
import world.data.jdbc.internal.transport.QueryApi;
import world.data.jdbc.internal.transport.Response;
import world.data.jdbc.internal.types.TypeMap;
import world.data.jdbc.internal.util.CloseableRef;
import world.data.jdbc.internal.util.Conditions;
import world.data.jdbc.internal.util.Optionals;
import world.data.jdbc.model.Iri;
import world.data.jdbc.model.Node;
import world.data.jdbc.vocab.Xsd;

public class SqlEngine
implements QueryEngine {
    private final QueryApi queryApi;
    private final String catalog;
    private final String schema;

    public SqlEngine(QueryApi queryApi, String catalog, String schema) {
        this.queryApi = Objects.requireNonNull(queryApi, "queryApi");
        this.catalog = Objects.requireNonNull(catalog, "catalog");
        this.schema = Objects.requireNonNull(schema, "schema");
    }

    @Override
    public String getCatalog() {
        return this.catalog;
    }

    @Override
    public String getSchema() {
        return this.schema;
    }

    @Override
    public String getLanguage() {
        return "sql";
    }

    @Override
    public JdbcCompatibility getDefaultCompatibilityLevel() {
        return JdbcCompatibility.HIGH;
    }

    @Override
    public DatabaseMetaData getDatabaseMetaData(DataWorldConnection connection) throws SQLException {
        return new SqlDatabaseMetaData(connection, this.catalog, this.schema);
    }

    @Override
    public ParameterMetaData getParameterMetaData(String query) throws SQLException {
        int count = 0;
        int i = -1;
        while ((i = query.indexOf(63, i + 1)) != -1) {
            ++count;
        }
        return new ParameterMetaDataImpl(count);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public ResultSet execute(DataWorldStatement statement, String query, Map<String, Node> parameters, Integer timeoutSeconds) throws SQLException {
        Response response = this.queryApi.executeQuery(query, parameters, timeoutSeconds);
        try (CloseableRef cleanup = new CloseableRef(response.getCleanup());){
            Conditions.check(response.getRows() != null, "SQL response is missing row data");
            List<Response.Column> columns = response.getColumns();
            Iterator<Node[]> rows = response.getRows();
            JdbcCompatibility level = statement.getJdbcCompatibilityLevel();
            List<ColumnInfo> columnInfos = this.buildColumnsMetadata(columns, level);
            ResultSetMetaDataImpl metaData = new ResultSetMetaDataImpl(columnInfos);
            ResultSetImpl resultSet = new ResultSetImpl(statement, metaData, rows, response.getCleanup());
            ResultSet resultSet2 = cleanup.detach(resultSet);
            return resultSet2;
        }
        catch (SQLException e) {
            throw e;
        }
        catch (Exception e) {
            throw new SQLException("Unexpected exception parsing SQL response from server.", e);
        }
    }

    private List<ColumnInfo> buildColumnsMetadata(List<Response.Column> columns, JdbcCompatibility level) {
        ArrayList<ColumnInfo> columnsMetaData = new ArrayList<ColumnInfo>();
        for (Response.Column column : columns) {
            columnsMetaData.add(this.buildColumnMetadata(column, level));
        }
        return columnsMetaData;
    }

    private ColumnInfo buildColumnMetadata(Response.Column column, JdbcCompatibility level) {
        Iri datatype = this.pickType(Optionals.mapIfPresent(column.getDatatypeIri(), Iri::new), level);
        int nullable = column.isRequired() ? 0 : 1;
        return ColumnFactory.builder(column.getName(), datatype).nullable(nullable).catalogName(this.catalog).schemaName(this.schema).build();
    }

    private Iri pickType(Iri datatype, JdbcCompatibility level) {
        switch (level) {
            case LOW: {
                return TypeMap.DATATYPE_RAW_NODE;
            }
            case MEDIUM: {
                return Xsd.STRING;
            }
        }
        return Optionals.or(datatype, Xsd.STRING);
    }

    @Override
    public void checkPositionalParametersSupported() throws SQLException {
    }

    @Override
    public void checkNamedParametersSupported() throws SQLException {
        throw new SQLFeatureNotSupportedException("Named parameters are not supported with SQL.");
    }
}

