/*
 * Decompiled with CFR 0.152.
 */
package world.data.jdbc.statements;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.TimeUnit;
import org.apache.jena.atlas.web.auth.HttpAuthenticator;
import org.apache.jena.jdbc.JdbcCompatibility;
import org.apache.jena.query.Query;
import org.apache.jena.query.QueryExecutionFactory;
import org.apache.jena.sparql.engine.http.QueryEngineHTTP;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import world.data.jdbc.connections.DataWorldConnection;
import world.data.jdbc.statements.QueryBuilder;

public class DataWorldStatement
implements Statement {
    private static final Logger LOGGER = LoggerFactory.getLogger(DataWorldStatement.class);
    private static final int NO_LIMIT = 0;
    private static final int USE_CONNECTION_COMPATIBILITY = Integer.MIN_VALUE;
    private int maxRows = 0;
    private int timeout = 0;
    private int compatibilityLevel = Integer.MIN_VALUE;
    private SQLWarning warnings = null;
    private final HttpAuthenticator authenticator;
    private final QueryBuilder queryBuilder;
    private final DataWorldConnection connection;
    private final List<String> commands = new ArrayList<String>();
    private final Queue<ResultSet> results = new LinkedList<ResultSet>();
    private final List<ResultSet> openResults = new ArrayList<ResultSet>();
    private ResultSet currResults = null;
    private boolean closed = false;

    public DataWorldStatement(DataWorldConnection connection, HttpAuthenticator authenticator, QueryBuilder queryBuilder) {
        this.authenticator = authenticator;
        this.connection = connection;
        this.queryBuilder = queryBuilder;
    }

    public int getJdbcCompatibilityLevel() {
        if (this.compatibilityLevel == Integer.MIN_VALUE) {
            return this.connection.getJdbcCompatibilityLevel();
        }
        return this.compatibilityLevel;
    }

    public void setJdbcCompatibilityLevel(int level) {
        this.compatibilityLevel = level == Integer.MIN_VALUE ? Integer.MIN_VALUE : JdbcCompatibility.normalizeLevel(level);
    }

    @Override
    public void clearWarnings() {
        this.warnings = null;
    }

    @Override
    public int getFetchDirection() {
        return 1000;
    }

    @Override
    public int getFetchSize() {
        return 0;
    }

    @Override
    public ResultSet getGeneratedKeys() throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public int getMaxFieldSize() {
        return 0;
    }

    @Override
    public int getMaxRows() {
        return this.maxRows;
    }

    @Override
    public final int getResultSetConcurrency() {
        return 1007;
    }

    @Override
    public int getResultSetHoldability() {
        return 2;
    }

    @Override
    public final int getResultSetType() {
        return 1003;
    }

    @Override
    public int getUpdateCount() {
        return -1;
    }

    @Override
    public SQLWarning getWarnings() {
        return this.warnings;
    }

    private void setWarning(SQLWarning warning) {
        LOGGER.warn("SQL Warning was issued", warning);
        if (this.warnings == null) {
            this.warnings = warning;
        } else {
            warning.setNextWarning(this.warnings);
            this.warnings = warning;
        }
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void addBatch(String sql) {
        this.commands.add(sql);
    }

    @Override
    public void cancel() throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    protected QueryEngineHTTP createQueryExecution(Query q) throws SQLException {
        QueryEngineHTTP exec = (QueryEngineHTTP)QueryExecutionFactory.sparqlService(this.connection.getQueryEndpoint(), q);
        if (this.authenticator != null) {
            exec.setAuthenticator(this.authenticator);
        }
        return exec;
    }

    @Override
    public boolean execute(String sql, int autoGeneratedKeys) throws SQLException {
        return this.execute(sql);
    }

    @Override
    public boolean execute(String sql, int[] columnIndexes) throws SQLException {
        return this.execute(sql);
    }

    @Override
    public boolean execute(String sql, String[] columnNames) throws SQLException {
        return this.execute(sql);
    }

    @Override
    public final int[] executeBatch() throws SQLException {
        if (this.isClosed()) {
            throw new SQLException("The Statement is closed");
        }
        int[] rets = new int[this.commands.size()];
        ResultSet curr = this.currResults;
        for (int i = 0; i < this.commands.size(); ++i) {
            if (this.execute(this.commands.get(i))) {
                this.results.add(this.getResultSet());
                this.currResults = null;
                rets[i] = -2;
                continue;
            }
            this.results.add(null);
            rets[i] = -1;
        }
        this.currResults = curr;
        if (this.currResults == null && !this.results.isEmpty()) {
            this.currResults = this.results.poll();
        }
        return rets;
    }

    @Override
    public void clearBatch() {
        this.commands.clear();
    }

    @Override
    public void close() throws SQLException {
        if (this.closed) {
            return;
        }
        LOGGER.info("Closing statement");
        this.closed = true;
        if (this.currResults != null) {
            this.currResults.close();
            this.currResults = null;
        }
        if (this.results.size() > 0 || this.openResults.size() > 0) {
            LOGGER.info("Closing " + (this.results.size() + this.openResults.size()) + " open result sets");
            while (!this.results.isEmpty()) {
                ResultSet rset = this.results.poll();
                if (rset == null) continue;
                rset.close();
            }
            for (ResultSet rset : this.openResults) {
                rset.close();
            }
            this.openResults.clear();
            LOGGER.info("All open result sets were closed");
        }
        LOGGER.info("Statement was closed");
    }

    private void setWarning(String warning) {
        this.setWarning(new SQLWarning(warning));
    }

    @Override
    public void setEscapeProcessing(boolean enable) {
    }

    @Override
    public void setFetchDirection(int direction) throws SQLException {
        if (direction != 1000) {
            throw new SQLFeatureNotSupportedException("Only ResultSet.FETCH_FORWARD is supported as a fetch direction");
        }
    }

    @Override
    public void setFetchSize(int rows) {
        this.setWarning("setMaxFieldSize() was called but there is no fetch size control for data.world JDBC connections");
    }

    @Override
    public void setMaxFieldSize(int max2) {
        this.setWarning("setMaxFieldSize() was called but there is no field size limit for data.world JDBC connections");
    }

    @Override
    public void setMaxRows(int max2) {
        this.setWarning("setMaxRows() was called but there is no row size limit for data.world JDBC connections");
    }

    @Override
    public void setPoolable(boolean poolable) {
        this.setWarning("setPoolable() was called but data.world JDBC statements are always considered poolable");
    }

    @Override
    public void setQueryTimeout(int seconds) {
        this.timeout = Math.max(seconds, 0);
    }

    @Override
    public boolean isCloseOnCompletion() {
        return false;
    }

    @Override
    public void closeOnCompletion() throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public final boolean isPoolable() {
        return true;
    }

    @Override
    public void setCursorName(String name) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public final boolean execute(String sql) throws SQLException {
        if (this.isClosed()) {
            throw new SQLException("The Statement is closed");
        }
        LOGGER.info("Received input command text:\n {}", (Object)sql);
        Query q = this.queryBuilder.buildQuery(sql);
        if (q != null) {
            LOGGER.info("Treating command text as a query");
            return this.executeQuery(q);
        }
        throw new SQLException("Unable to create a SPARQL query/update");
    }

    @Override
    public final ResultSet executeQuery(String sql) throws SQLException {
        if (this.isClosed()) {
            throw new SQLException("The Statement is closed");
        }
        LOGGER.info("Received input command text:\n {}", (Object)sql);
        Query q = this.queryBuilder.buildQuery(sql);
        if (q == null) {
            throw new SQLException("Unable to create a SQL Query");
        }
        if (this.executeQuery(q)) {
            return this.currResults;
        }
        throw new SQLException("Query did not produce a result set");
    }

    private boolean executeQuery(Query q) throws SQLException {
        try {
            QueryEngineHTTP qe = this.createQueryExecution(q);
            if (this.timeout > 0) {
                qe.setTimeout(this.timeout, TimeUnit.SECONDS, this.timeout, TimeUnit.SECONDS);
            }
            this.currResults = this.queryBuilder.buildResults(this, q, qe);
            return true;
        }
        catch (SQLException e2) {
            throw e2;
        }
        catch (Throwable e3) {
            LOGGER.error("SPARQL Query evaluation failed", e3);
            throw new SQLException("Error occurred during SPARQL query evaluation", e3);
        }
    }

    @Override
    public final int executeUpdate(String sql) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public int executeUpdate(String sql, int autoGeneratedKeys) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public int executeUpdate(String sql, int[] columnIndexes) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public int executeUpdate(String sql, String[] columnNames) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public final Connection getConnection() {
        return this.connection;
    }

    @Override
    public boolean getMoreResults() throws SQLException {
        if (this.isClosed()) {
            throw new SQLException("The Statement is closed");
        }
        if (this.currResults != null) {
            this.currResults.close();
            this.currResults = null;
        }
        if (!this.results.isEmpty()) {
            this.currResults = this.results.poll();
            return true;
        }
        return false;
    }

    @Override
    public boolean getMoreResults(int current) throws SQLException {
        if (this.isClosed()) {
            throw new SQLException("The Statement is closed");
        }
        switch (current) {
            case 1: {
                return this.getMoreResults();
            }
            case 3: {
                for (ResultSet rset : this.openResults) {
                    rset.close();
                }
                this.openResults.clear();
                return this.getMoreResults();
            }
            case 2: {
                if (this.currResults != null) {
                    this.openResults.add(this.currResults);
                    this.currResults = null;
                }
                return this.getMoreResults();
            }
        }
        throw new SQLFeatureNotSupportedException("Unsupported mode for dealing with current results, only Statement.CLOSE_CURRENT_RESULT, Statement.CLOSE_ALL_RESULTS and Statement.KEEP_CURRENT_RESULT are supported");
    }

    @Override
    public int getQueryTimeout() {
        return this.timeout;
    }

    @Override
    public final ResultSet getResultSet() throws SQLException {
        if (this.isClosed()) {
            throw new SQLException("The Statement is closed");
        }
        return this.currResults;
    }

    @Override
    public final boolean isClosed() {
        return this.closed;
    }
}

