/*
 * Decompiled with CFR 0.152.
 */
package world.data.jdbc.results;

import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.apache.jena.atlas.lib.Closeable;
import org.apache.jena.graph.Node;
import org.apache.jena.query.QueryCancelledException;
import org.apache.jena.query.QueryExecution;
import org.apache.jena.query.ResultSet;
import org.apache.jena.query.ResultSetFactory;
import org.apache.jena.sparql.core.Var;
import org.apache.jena.sparql.engine.binding.Binding;
import org.apache.jena.sparql.resultset.ResultSetPeekable;
import world.data.jdbc.metadata.SelectResultsMetadata;
import world.data.jdbc.results.StreamedResults;
import world.data.jdbc.statements.DataWorldStatement;

public class SelectResults
extends StreamedResults<Binding> {
    private ResultSetPeekable innerResults;
    private List<String> columns;
    private SelectResultsMetadata metadata;

    public SelectResults(DataWorldStatement statement, QueryExecution qe, ResultSet results) throws SQLException {
        super(statement, qe);
        this.innerResults = ResultSetFactory.makePeekable(results);
        this.columns = new ArrayList<String>(this.innerResults.getResultVars());
        this.metadata = new SelectResultsMetadata(this, this.innerResults);
    }

    @Override
    public void closeStreamInternal() {
        if (this.innerResults != null) {
            if (this.innerResults instanceof Closeable) {
                ((Closeable)((Object)this.innerResults)).close();
            }
            this.innerResults = null;
        }
    }

    @Override
    public int findColumn(String columnLabel) throws SQLException {
        if (this.isClosed()) {
            throw new SQLException("Result Set is closed");
        }
        for (int i = 0; i < this.columns.size(); ++i) {
            if (!this.columns.get(i).equals(columnLabel)) continue;
            return i + 1;
        }
        throw new SQLException("The given column does not exist in this result set");
    }

    @Override
    protected String findColumnLabel(int columnIndex) throws SQLException {
        if (this.isClosed()) {
            throw new SQLException("Result Set is closed");
        }
        if (columnIndex >= 1 && columnIndex <= this.columns.size()) {
            return this.columns.get(columnIndex - 1);
        }
        throw new SQLException("Column Index is out of bounds");
    }

    @Override
    protected Node getNode(String columnLabel) throws SQLException {
        if (this.isClosed()) {
            throw new SQLException("Result Set is closed");
        }
        if (this.getCurrentRow() == null) {
            throw new SQLException("Not currently at a row");
        }
        if (!this.columns.contains(columnLabel)) {
            throw new SQLException("The given column does not exist in the result set");
        }
        return ((Binding)this.getCurrentRow()).get(Var.alloc(columnLabel));
    }

    @Override
    public ResultSetMetaData getMetaData() {
        return this.metadata;
    }

    @Override
    protected boolean hasNext() throws SQLException {
        try {
            return this.innerResults.hasNext();
        }
        catch (QueryCancelledException e2) {
            throw new SQLException("Query was cancelled, it is likely that your query exceeded the specified execution timeout", e2);
        }
        catch (Throwable e3) {
            throw new SQLException("Unexpected error while moving through results", e3);
        }
    }

    @Override
    protected Binding moveNext() throws SQLException {
        try {
            return this.innerResults.nextBinding();
        }
        catch (QueryCancelledException e2) {
            throw new SQLException("Query was cancelled, it is likely that your query exceeded the specified execution timeout", e2);
        }
        catch (Throwable e3) {
            throw new SQLException("Unexpected error while moving through results", e3);
        }
    }
}

