/*
 * Decompiled with CFR 0.152.
 */
package world.data.jdbc;

import java.io.FileInputStream;
import java.io.IOException;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import org.apache.commons.io.IOUtils;

public class SqlDemo {
    public static void main(String[] args) throws SQLException, IOException {
        String token = IOUtils.toString(new FileInputStream("/Users/daveg/test.token"));
        try (Connection connection = DriverManager.getConnection("jdbc:data:world:sql:dave:lahman-sabremetrics-dataset", "", token);
             PreparedStatement statement = connection.prepareStatement("select * from HallOfFame where playerID = ? order by yearid, playerID limit 10");){
            statement.setString(1, "alexape01");
            try (ResultSet resultSet = statement.executeQuery();){
                int i;
                ResultSetMetaData rsmd = resultSet.getMetaData();
                int columnsNumber = rsmd.getColumnCount();
                for (i = 1; i <= columnsNumber; ++i) {
                    if (i > 1) {
                        System.out.print(",  ");
                    }
                    System.out.print(rsmd.getColumnName(i));
                }
                System.out.println("");
                while (resultSet.next()) {
                    for (i = 1; i <= columnsNumber; ++i) {
                        if (i > 1) {
                            System.out.print(",  ");
                        }
                        String columnValue = resultSet.getString(i);
                        System.out.print(columnValue);
                    }
                    System.out.println("");
                }
            }
        }
    }
}

