/*
 * Decompiled with CFR 0.152.
 */
package world.data.jdbc;

import java.sql.SQLException;
import org.apache.jena.graph.Node;
import org.apache.jena.jdbc.results.metadata.columns.BooleanColumn;
import org.apache.jena.jdbc.results.metadata.columns.ByteColumn;
import org.apache.jena.jdbc.results.metadata.columns.ColumnInfo;
import org.apache.jena.jdbc.results.metadata.columns.DateColumn;
import org.apache.jena.jdbc.results.metadata.columns.DateTimeColumn;
import org.apache.jena.jdbc.results.metadata.columns.DecimalColumn;
import org.apache.jena.jdbc.results.metadata.columns.DoubleColumn;
import org.apache.jena.jdbc.results.metadata.columns.FloatColumn;
import org.apache.jena.jdbc.results.metadata.columns.IntegerColumn;
import org.apache.jena.jdbc.results.metadata.columns.LongIntegerColumn;
import org.apache.jena.jdbc.results.metadata.columns.StringColumn;
import org.apache.jena.jdbc.results.metadata.columns.TimeColumn;
import org.apache.jena.vocabulary.XSD;

public class JdbcCompatibility {
    public static final int LOW = 1;
    public static final int MEDIUM = 5;
    public static final int HIGH = 9;
    public static final int DEFAULT = 5;

    private JdbcCompatibility() {
    }

    public static int normalizeLevel(int level) {
        if (level < 1) {
            return 1;
        }
        if (level > 9) {
            return 9;
        }
        return level;
    }

    public static boolean shouldDetectColumnTypes(int level) {
        return (level = JdbcCompatibility.normalizeLevel(level)) == 9;
    }

    public static boolean shouldTypeColumnsAsString(int level) {
        return (level = JdbcCompatibility.normalizeLevel(level)) >= 5 && level < 9;
    }

    public static ColumnInfo detectColumnType(String var, Node value, boolean allowsNulls) throws SQLException {
        int nullable;
        if (allowsNulls && value == null) {
            return new StringColumn(var, 1);
        }
        if (!allowsNulls && value == null) {
            throw new SQLException("Unable to determine column type, column is non-nullable but example value is null");
        }
        int n = nullable = allowsNulls ? 1 : 0;
        if (value.isBlank()) {
            return new StringColumn(var, nullable);
        }
        if (value.isURI()) {
            return new StringColumn(var, nullable);
        }
        if (value.isLiteral()) {
            String dtUri = value.getLiteralDatatypeURI();
            if (dtUri != null) {
                return JdbcCompatibility.selectColumnType(var, dtUri, nullable);
            }
            return new StringColumn(var, nullable);
        }
        return new StringColumn(var, nullable);
    }

    private static ColumnInfo selectColumnType(String var, String dtUri, int nullable) throws SQLException {
        if (dtUri.equals(XSD.date.toString())) {
            return new DateColumn(var, nullable);
        }
        if (dtUri.equals(XSD.dateTime.toString())) {
            return new DateTimeColumn(var, nullable);
        }
        if (dtUri.equals(XSD.decimal.toString())) {
            return new DecimalColumn(var, nullable);
        }
        if (dtUri.equals(XSD.duration.toString())) {
            return new StringColumn(var, nullable);
        }
        if (dtUri.equals(XSD.integer.toString()) || dtUri.equals(XSD.xint.toString()) || dtUri.equals(XSD.xlong.toString())) {
            return new LongIntegerColumn(var, nullable, true);
        }
        if (dtUri.equals(XSD.unsignedInt.toString()) || dtUri.equals(XSD.unsignedLong.toString())) {
            return new LongIntegerColumn(var, nullable, false);
        }
        if (dtUri.equals(XSD.positiveInteger.toString()) || dtUri.equals(XSD.nonNegativeInteger.toString())) {
            return new LongIntegerColumn(var, nullable, false);
        }
        if (dtUri.equals(XSD.nonPositiveInteger.toString()) || dtUri.equals(XSD.negativeInteger.toString())) {
            return new LongIntegerColumn(var, nullable, true);
        }
        if (dtUri.equals(XSD.xshort.toString())) {
            return new IntegerColumn(var, nullable, true);
        }
        if (dtUri.equals(XSD.unsignedShort.toString())) {
            return new IntegerColumn(var, nullable, false);
        }
        if (dtUri.equals(XSD.xbyte.toString())) {
            return new ByteColumn(var, nullable, true);
        }
        if (dtUri.equals(XSD.unsignedByte.toString())) {
            return new ByteColumn(var, nullable, false);
        }
        if (dtUri.equals(XSD.time.toString())) {
            return new TimeColumn(var, nullable);
        }
        if (dtUri.equals(XSD.xboolean.toString())) {
            return new BooleanColumn(var, nullable);
        }
        if (dtUri.equals(XSD.xdouble.toString())) {
            return new DoubleColumn(var, nullable);
        }
        if (dtUri.equals(XSD.xfloat.toString())) {
            return new FloatColumn(var, nullable);
        }
        if (dtUri.equals(XSD.xstring.toString())) {
            return new StringColumn(var, nullable);
        }
        return new StringColumn(var, nullable);
    }

    public static int parseLevel(Object object) {
        if (object == null) {
            return 5;
        }
        if (object instanceof Integer) {
            return JdbcCompatibility.normalizeLevel((Integer)object);
        }
        try {
            int level = Integer.parseInt(object.toString());
            return JdbcCompatibility.normalizeLevel(level);
        }
        catch (NumberFormatException e2) {
            return 5;
        }
    }
}

