/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.system;

import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.function.Consumer;
import org.apache.jena.system.JenaSubsystemLifecycle;
import org.apache.jena.system.JenaSubsystemRegistry;
import org.apache.jena.system.JenaSubsystemRegistryBasic;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JenaSystem {
    public static boolean DEBUG_INIT = false;
    private static volatile boolean initialized = false;
    private static Object initLock = new Object();
    private static JenaSubsystemRegistry singleton = null;
    private static Comparator<JenaSubsystemLifecycle> comparator = (obj1, obj2) -> Integer.compare(obj1.level(), obj2.level());
    private static Comparator<JenaSubsystemLifecycle> reverseComparator = (obj1, obj2) -> -1 * Integer.compare(obj1.level(), obj2.level());

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void init() {
        if (initialized) {
            return;
        }
        Object object = initLock;
        synchronized (object) {
            if (initialized) {
                JenaSystem.logLifecycle("JenaSystem.init - return", new Object[0]);
                return;
            }
            initialized = true;
            JenaSystem.logLifecycle("JenaSystem.init - start", new Object[0]);
            if (JenaSystem.get() == null) {
                JenaSystem.setSubsystemRegistry(new JenaSubsystemRegistryBasic());
            }
            JenaSystem.get().load();
            if (DEBUG_INIT) {
                JenaSystem.get().snapshot().forEach(mod -> JenaSystem.logLifecycle("  %s", mod.getClass().getSimpleName()));
            }
            JenaSystem.get().add(new JenaInitLevel0());
            JenaSystem.forEach(module -> {
                JenaSystem.logLifecycle("Init: %s", module.getClass().getSimpleName());
                module.start();
            });
            JenaSystem.logLifecycle("JenaSystem.init - finish", new Object[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void shutdown() {
        if (!initialized) {
            JenaSystem.logLifecycle("JenaSystem.shutdown - not initialized", new Object[0]);
            return;
        }
        Object object = initLock;
        synchronized (object) {
            if (!initialized) {
                JenaSystem.logLifecycle("JenaSystem.shutdown - return", new Object[0]);
                return;
            }
            JenaSystem.logLifecycle("JenaSystem.shutdown - start", new Object[0]);
            JenaSystem.forEachReverse(module -> {
                JenaSystem.logLifecycle("Stop: %s", module.getClass().getSimpleName());
                module.stop();
            });
            initialized = false;
            JenaSystem.logLifecycle("JenaSystem.shutdown - finish", new Object[0]);
        }
    }

    public static void setSubsystemRegistry(JenaSubsystemRegistry thing) {
        singleton = thing;
    }

    public static JenaSubsystemRegistry get() {
        return singleton;
    }

    public static void forEach(Consumer<JenaSubsystemLifecycle> action) {
        JenaSystem.forEach(action, comparator);
    }

    public static void forEachReverse(Consumer<JenaSubsystemLifecycle> action) {
        JenaSystem.forEach(action, reverseComparator);
    }

    private static synchronized void forEach(Consumer<JenaSubsystemLifecycle> action, Comparator<JenaSubsystemLifecycle> ordering) {
        List<JenaSubsystemLifecycle> x = JenaSystem.get().snapshot();
        Collections.sort(x, ordering);
        x.forEach(action);
    }

    public static void logLifecycle(String fmt, Object ... args) {
        if (!DEBUG_INIT) {
            return;
        }
        System.err.printf(fmt, args);
        System.err.println();
    }

    private static class JenaInitLevel0
    implements JenaSubsystemLifecycle {
        private static Logger log = LoggerFactory.getLogger("Jena");

        private JenaInitLevel0() {
        }

        @Override
        public void start() {
            log.debug("Jena initialization");
        }

        @Override
        public void stop() {
            log.debug("Jena shutdown");
        }

        @Override
        public int level() {
            return 0;
        }
    }
}

