/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.graph;

import java.util.Collection;
import org.apache.jena.atlas.iterator.Iter;
import org.apache.jena.atlas.iterator.IteratorConcat;
import org.apache.jena.graph.Graph;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.Triple;
import org.apache.jena.graph.impl.GraphBase;
import org.apache.jena.shared.PrefixMapping;
import org.apache.jena.shared.impl.PrefixMappingImpl;
import org.apache.jena.sparql.core.DatasetGraph;
import org.apache.jena.sparql.graph.GraphOps;
import org.apache.jena.util.iterator.ExtendedIterator;
import org.apache.jena.util.iterator.WrappedIterator;

public class GraphUnionRead
extends GraphBase {
    private final DatasetGraph dataset;
    private final Collection<Node> graphs;

    public GraphUnionRead(DatasetGraph dsg, Collection<Node> graphs) {
        this.dataset = dsg;
        this.graphs = graphs;
    }

    @Override
    protected PrefixMapping createPrefixMapping() {
        PrefixMappingImpl pmap = new PrefixMappingImpl();
        for (Node gn : this.graphs) {
            if (!gn.isURI()) continue;
            Graph g = this.dataset.getGraph(gn);
            PrefixMapping pmapNamedGraph = g.getPrefixMapping();
            pmap.setNsPrefixes(pmapNamedGraph);
        }
        return pmap;
    }

    @Override
    protected ExtendedIterator<Triple> graphBaseFind(Triple m) {
        IteratorConcat<Triple> iter = new IteratorConcat<Triple>();
        for (Node gn : this.graphs) {
            if (!GraphOps.containsGraph(this.dataset, gn)) continue;
            ExtendedIterator<Triple> eIter = GraphOps.getGraph(this.dataset, gn).find(m);
            iter.add(eIter);
        }
        return WrappedIterator.create(Iter.distinct(iter));
    }
}

