/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.algebra.optimize;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.apache.jena.atlas.logging.Log;
import org.apache.jena.sparql.algebra.Op;
import org.apache.jena.sparql.algebra.TransformCopy;
import org.apache.jena.sparql.algebra.op.OpDisjunction;
import org.apache.jena.sparql.algebra.op.OpFilter;
import org.apache.jena.sparql.algebra.optimize.TransformFilterEquality;
import org.apache.jena.sparql.expr.E_LogicalOr;
import org.apache.jena.sparql.expr.Expr;
import org.apache.jena.sparql.expr.ExprList;

public class TransformFilterDisjunction
extends TransformCopy {
    @Override
    public Op transform(OpFilter opFilter, Op subOp) {
        ExprList exprList = opFilter.getExprs();
        boolean processDisjunction = false;
        for (Expr expr : exprList) {
            if (!this.isDisjunction(expr)) continue;
            processDisjunction = true;
            break;
        }
        if (!processDisjunction) {
            return super.transform(opFilter, subOp);
        }
        ExprList exprList2 = new ExprList();
        Op newOp = subOp;
        HashSet doneSoFar = new HashSet();
        for (Expr expr : exprList) {
            if (!this.isDisjunction(expr)) {
                exprList2.add(expr);
                continue;
            }
            Op op2 = TransformFilterDisjunction.expandDisjunction(expr, newOp);
            if (op2 == null) continue;
            newOp = op2;
        }
        if (exprList2.isEmpty()) {
            return newOp;
        }
        if (newOp == subOp) {
            Log.warn(this, "FilterDisjunction assumption failure: didn't find a disjunction after all");
            return super.transform(opFilter, subOp);
        }
        Op opOther = OpFilter.filter(exprList2, newOp);
        if (opOther instanceof OpFilter) {
            return opOther;
        }
        Log.warn(this, "FilterDisjunction assumption failure: not a filter after processing disjunction/other mix");
        return super.transform(opFilter, subOp);
    }

    private boolean isDisjunction(Expr expr) {
        return expr instanceof E_LogicalOr;
    }

    public static Op expandDisjunction(Expr expr, Op subOp) {
        List<Expr> exprList = TransformFilterDisjunction.explodeDisjunction(new ArrayList<Expr>(), expr);
        ArrayList<Expr> exprList2 = null;
        Op op = null;
        for (Expr expr2 : exprList) {
            Op op2 = TransformFilterEquality.processFilter(expr2, subOp);
            if (op2 == null) {
                if (exprList2 == null) {
                    exprList2 = new ArrayList<Expr>();
                }
                exprList2.add(expr2);
            }
            op = OpDisjunction.create(op, op2);
        }
        if (exprList2 != null && !exprList2.isEmpty()) {
            Expr eOther = null;
            for (Expr expr3 : exprList2) {
                if (eOther == null) {
                    eOther = expr3;
                    continue;
                }
                eOther = new E_LogicalOr(eOther, expr3);
            }
            Op op3 = OpFilter.filter(eOther, subOp);
            op = OpDisjunction.create(op, op3);
        }
        return op;
    }

    private static List<Expr> explodeDisjunction(List<Expr> exprList, Expr expr) {
        if (!(expr instanceof E_LogicalOr)) {
            exprList.add(expr);
            return exprList;
        }
        E_LogicalOr exprOr = (E_LogicalOr)expr;
        Expr e1 = exprOr.getArg1();
        Expr e2 = exprOr.getArg2();
        TransformFilterDisjunction.explodeDisjunction(exprList, e1);
        TransformFilterDisjunction.explodeDisjunction(exprList, e2);
        return exprList;
    }
}

