/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.riot.thrift;

import java.io.OutputStream;
import java.io.Writer;
import org.apache.jena.riot.Lang;
import org.apache.jena.riot.RDFFormat;
import org.apache.jena.riot.RDFLanguages;
import org.apache.jena.riot.WriterDatasetRIOT;
import org.apache.jena.riot.system.PrefixMap;
import org.apache.jena.riot.system.StreamOps;
import org.apache.jena.riot.system.StreamRDF;
import org.apache.jena.riot.thrift.BinRDF;
import org.apache.jena.riot.thrift.RiotThriftException;
import org.apache.jena.sparql.core.DatasetGraph;
import org.apache.jena.sparql.util.Context;

public class WriterDatasetThrift
implements WriterDatasetRIOT {
    private final boolean withValues;

    public WriterDatasetThrift(RDFFormat fmt) {
        this.withValues = RDFFormat.RDF_THRIFT_VALUES.equals(fmt);
    }

    @Override
    public Lang getLang() {
        return RDFLanguages.THRIFT;
    }

    @Override
    public void write(Writer out, DatasetGraph dsg, PrefixMap prefixMap, String baseURI, Context context) {
        throw new RiotThriftException("Writing binary data to a java.io.Writer is not supported. Please use an OutputStream");
    }

    @Override
    public void write(OutputStream out, DatasetGraph dsg, PrefixMap prefixMap, String baseURI, Context context) {
        StreamRDF stream = BinRDF.streamToOutputStream(out, this.withValues);
        stream.start();
        StreamOps.sendDatasetToStream(dsg, stream, prefixMap);
        stream.finish();
    }
}

