/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.riot.out;

import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.github.jsonldjava.core.JsonLdError;
import com.github.jsonldjava.core.JsonLdOptions;
import com.github.jsonldjava.core.JsonLdProcessor;
import com.github.jsonldjava.utils.JsonUtils;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.Consumer;
import org.apache.jena.atlas.io.IO;
import org.apache.jena.atlas.iterator.Iter;
import org.apache.jena.atlas.lib.Chars;
import org.apache.jena.graph.Graph;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.Triple;
import org.apache.jena.iri.IRI;
import org.apache.jena.rdf.model.impl.Util;
import org.apache.jena.riot.Lang;
import org.apache.jena.riot.RDFFormat;
import org.apache.jena.riot.RiotException;
import org.apache.jena.riot.out.JenaRDF2JSONLD;
import org.apache.jena.riot.system.PrefixMap;
import org.apache.jena.riot.writer.WriterDatasetRIOTBase;
import org.apache.jena.sparql.core.DatasetGraph;
import org.apache.jena.sparql.util.Context;
import org.apache.jena.vocabulary.RDF;

public class JsonLDWriter
extends WriterDatasetRIOTBase {
    private final RDFFormat format;

    public JsonLDWriter(RDFFormat syntaxForm) {
        this.format = syntaxForm;
    }

    @Override
    public Lang getLang() {
        return this.format.getLang();
    }

    @Override
    public void write(Writer out, DatasetGraph dataset, PrefixMap prefixMap, String baseURI, Context context) {
        this.serialize(out, dataset, prefixMap, baseURI);
    }

    private boolean isPretty() {
        return RDFFormat.PRETTY.equals(this.format.getVariant());
    }

    @Override
    public void write(OutputStream out, DatasetGraph dataset, PrefixMap prefixMap, String baseURI, Context context) {
        OutputStreamWriter w = new OutputStreamWriter(out, Chars.charsetUTF8);
        this.write(w, dataset, prefixMap, baseURI, context);
        IO.flush(w);
    }

    private void serialize(Writer writer, DatasetGraph dataset, PrefixMap prefixMap, String baseURI) {
        LinkedHashMap<String, Object> ctx = new LinkedHashMap<String, Object>();
        JsonLDWriter.addProperties(ctx, dataset.getDefaultGraph());
        JsonLDWriter.addPrefixes(ctx, prefixMap);
        try {
            JsonLdOptions opts = new JsonLdOptions(baseURI);
            opts.useNamespaces = true;
            opts.setUseNativeTypes(true);
            opts.setCompactArrays(true);
            Map<String, Object> obj = JsonLdProcessor.fromRDF(dataset, opts, new JenaRDF2JSONLD());
            HashMap<String, LinkedHashMap<String, Object>> localCtx = new HashMap<String, LinkedHashMap<String, Object>>();
            localCtx.put("@context", ctx);
            obj = JsonLdProcessor.compact(obj, localCtx, opts);
            if (this.isPretty()) {
                JsonUtils.writePrettyPrint(writer, obj);
            } else {
                JsonUtils.write(writer, obj);
            }
            writer.write("\n");
        }
        catch (JsonGenerationException | JsonMappingException | JsonLdError e2) {
            throw new RiotException(e2);
        }
        catch (IOException e3) {
            IO.exception(e3);
        }
    }

    private static void addPrefixes(Map<String, Object> ctx, PrefixMap prefixMap) {
        Map<String, IRI> pmap = prefixMap.getMapping();
        for (Map.Entry<String, IRI> e2 : pmap.entrySet()) {
            String key = e2.getKey();
            if (key.isEmpty()) continue;
            IRI iri = e2.getValue();
            ctx.put(e2.getKey(), e2.getValue().toString());
        }
    }

    private static void addProperties(final Map<String, Object> ctx, Graph graph) {
        final HashSet dups = new HashSet();
        Consumer<Triple> x = new Consumer<Triple>(){

            @Override
            public void accept(Triple item) {
                Node p = item.getPredicate();
                Node o = item.getObject();
                if (p.equals(RDF.type.asNode())) {
                    return;
                }
                String x = p.getLocalName();
                if (dups.contains(x)) {
                    return;
                }
                if (!ctx.containsKey(x)) {
                    if (o.isBlank() || o.isURI()) {
                        LinkedHashMap<String, String> x2 = new LinkedHashMap<String, String>();
                        x2.put("@id", p.getURI());
                        x2.put("@type", "@id");
                        ctx.put(x, x2);
                    } else if (o.isLiteral()) {
                        String literalDatatypeURI = o.getLiteralDatatypeURI();
                        if (literalDatatypeURI != null) {
                            LinkedHashMap<String, String> x2 = new LinkedHashMap<String, String>();
                            x2.put("@id", p.getURI());
                            x2.put("@id", p.getURI());
                            if (!Util.isLangString(o) && !Util.isSimpleString(o)) {
                                x2.put("@type", literalDatatypeURI);
                            }
                            ctx.put(x, x2);
                        } else {
                            ctx.put(x, p.getURI());
                        }
                    }
                }
            }
        };
        Iter.iter(graph.find(null, null, null)).apply(x);
    }
}

