/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.query;

import java.util.List;
import java.util.Objects;
import org.apache.jena.assembler.Assembler;
import org.apache.jena.query.Dataset;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.sparql.ARQException;
import org.apache.jena.sparql.core.DatasetGraph;
import org.apache.jena.sparql.core.DatasetGraphFactory;
import org.apache.jena.sparql.core.DatasetImpl;
import org.apache.jena.sparql.core.assembler.DatasetAssembler;
import org.apache.jena.sparql.util.DatasetUtils;
import org.apache.jena.sparql.util.graph.GraphUtils;
import org.apache.jena.util.FileManager;

public class DatasetFactory {
    public static Dataset create() {
        return DatasetFactory.wrap(DatasetGraphFactory.create());
    }

    @Deprecated
    public static Dataset createMem() {
        return DatasetFactory.createGeneral();
    }

    public static Dataset createTxnMem() {
        return DatasetFactory.wrap(DatasetGraphFactory.createTxnMem());
    }

    public static Dataset createGeneral() {
        return DatasetFactory.wrap(DatasetGraphFactory.createGeneral());
    }

    public static Dataset create(Model model) {
        Objects.requireNonNull(model, "Default model must be provided");
        return new DatasetImpl(model);
    }

    @Deprecated
    public static Dataset create(Dataset dataset) {
        Objects.requireNonNull(dataset, "Clone dataset is null");
        return new DatasetImpl(dataset);
    }

    public static Dataset wrap(DatasetGraph dataset) {
        Objects.requireNonNull(dataset, "Can't wrap a null reference");
        return DatasetImpl.wrap(dataset);
    }

    @Deprecated
    public static Dataset create(DatasetGraph dataset) {
        return DatasetFactory.wrap(dataset);
    }

    public static Dataset create(List<String> uriList) {
        return DatasetFactory.create(uriList, null, null);
    }

    public static Dataset create(String uri) {
        return DatasetFactory.create(uri, null, null);
    }

    public static Dataset createNamed(List<String> namedSourceList) {
        return DatasetFactory.create((List<String>)null, namedSourceList, null);
    }

    public static Dataset create(List<String> uriList, List<String> namedSourceList) {
        return DatasetFactory.create(uriList, namedSourceList, null);
    }

    public static Dataset create(String uri, List<String> namedSourceList) {
        return DatasetFactory.create(uri, namedSourceList, null);
    }

    public static Dataset create(String uri, List<String> namedSourceList, String baseURI) {
        return DatasetUtils.createDataset(uri, namedSourceList, baseURI);
    }

    public static Dataset create(List<String> uriList, List<String> namedSourceList, String baseURI) {
        return DatasetUtils.createDataset(uriList, namedSourceList, baseURI);
    }

    public static Dataset assemble(String filename) {
        Objects.requireNonNull(filename, "file name can not be null");
        Model model = FileManager.get().loadModel(filename);
        return DatasetFactory.assemble(model);
    }

    public static Dataset assemble(String filename, String resourceURI) {
        Objects.requireNonNull(filename, "file name can not be null");
        Objects.requireNonNull(resourceURI, "resourceURI can not be null");
        Model model = FileManager.get().loadModel(filename);
        Resource r = model.createResource(resourceURI);
        return DatasetFactory.assemble(r);
    }

    public static Dataset assemble(Model model) {
        Objects.requireNonNull(model, "model can not be null");
        Resource r = GraphUtils.findRootByType(model, DatasetAssembler.getType());
        if (r == null) {
            throw new ARQException("No root found for type <" + DatasetAssembler.getType() + ">");
        }
        return DatasetFactory.assemble(r);
    }

    public static Dataset assemble(Resource resource) {
        Objects.requireNonNull(resource, "resource can not be null");
        Dataset ds = (Dataset)Assembler.general.open(resource);
        return ds;
    }
}

