/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.jdbc.statements;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.TimeUnit;
import org.apache.jena.atlas.iterator.Iter;
import org.apache.jena.jdbc.JdbcCompatibility;
import org.apache.jena.jdbc.connections.JenaConnection;
import org.apache.jena.jdbc.results.AskResults;
import org.apache.jena.jdbc.results.MaterializedSelectResults;
import org.apache.jena.jdbc.results.SelectResults;
import org.apache.jena.jdbc.results.TripleIteratorResults;
import org.apache.jena.jdbc.results.TripleListResults;
import org.apache.jena.query.Query;
import org.apache.jena.query.QueryExecution;
import org.apache.jena.query.QueryFactory;
import org.apache.jena.query.ReadWrite;
import org.apache.jena.query.ResultSetFactory;
import org.apache.jena.update.UpdateFactory;
import org.apache.jena.update.UpdateProcessor;
import org.apache.jena.update.UpdateRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class JenaStatement
implements Statement {
    private static final Logger LOGGER = LoggerFactory.getLogger(JenaStatement.class);
    protected static final int DEFAULT_HOLDABILITY = 2;
    protected static final int DEFAULT_FETCH_DIRECTION = 1000;
    protected static final int DEFAULT_FETCH_SIZE = 0;
    protected static final boolean DEFAULT_AUTO_COMMIT = true;
    protected static final int DEFAULT_TRANSACTION_LEVEL = 0;
    protected static final int NO_LIMIT = 0;
    protected static final int DEFAULT_TYPE = 1003;
    protected static final int USE_CONNECTION_COMPATIBILITY = Integer.MIN_VALUE;
    private List<String> commands = new ArrayList<String>();
    private SQLWarning warnings = null;
    private JenaConnection connection;
    private ResultSet currResults = null;
    private Queue<ResultSet> results = new LinkedList<ResultSet>();
    private List<ResultSet> openResults = new ArrayList<ResultSet>();
    private boolean closed = false;
    private int type = 1003;
    private int fetchDirection = 1000;
    private int fetchSize = 0;
    private int holdability = 2;
    private int updateCount = 0;
    private boolean autoCommit = true;
    private int transactionLevel = 0;
    private int maxRows = 0;
    private boolean escapeProcessing = false;
    private int timeout = 0;
    private int compatibilityLevel = Integer.MIN_VALUE;

    public JenaStatement(JenaConnection connection) throws SQLException {
        this(connection, 1003, 1000, 0, 2, true, 0);
    }

    public JenaStatement(JenaConnection connection, int type, int fetchDir, int fetchSize, int holdability, boolean autoCommit, int transactionLevel) throws SQLException {
        if (connection == null) {
            throw new SQLException("Cannot create a Statement with a null connection");
        }
        this.connection = connection;
        this.checkFetchDirection(fetchDir);
        this.type = type;
        this.fetchDirection = fetchDir;
        this.fetchSize = fetchSize;
        this.checkHoldability(holdability);
        this.holdability = holdability;
        this.autoCommit = autoCommit;
        this.transactionLevel = transactionLevel;
    }

    public JenaConnection getJenaConnection() {
        return this.connection;
    }

    public int getJdbcCompatibilityLevel() {
        if (this.compatibilityLevel == Integer.MIN_VALUE) {
            return this.connection.getJdbcCompatibilityLevel();
        }
        return this.compatibilityLevel;
    }

    public void setJdbcCompatibilityLevel(int level) {
        this.compatibilityLevel = level == Integer.MIN_VALUE ? Integer.MIN_VALUE : JdbcCompatibility.normalizeLevel(level);
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void addBatch(String sql) {
        this.commands.add(sql);
    }

    @Override
    public void cancel() throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void clearBatch() {
        this.commands.clear();
    }

    @Override
    public void clearWarnings() {
        this.warnings = null;
    }

    @Override
    public void close() throws SQLException {
        if (this.closed) {
            return;
        }
        LOGGER.info("Closing statement");
        this.closed = true;
        if (this.currResults != null) {
            this.currResults.close();
            this.currResults = null;
        }
        if (this.results.size() > 0 || this.openResults.size() > 0) {
            LOGGER.info("Closing " + (this.results.size() + this.openResults.size()) + " open result sets");
            while (!this.results.isEmpty()) {
                ResultSet rset = this.results.poll();
                if (rset == null) continue;
                rset.close();
            }
            for (ResultSet rset : this.openResults) {
                rset.close();
            }
            this.openResults.clear();
            LOGGER.info("All open result sets were closed");
        }
        LOGGER.info("Statement was closed");
    }

    @Override
    public final boolean execute(String sql) throws SQLException {
        if (this.isClosed()) {
            throw new SQLException("The Statement is closed");
        }
        LOGGER.info("Received input command text:\n {}", (Object)sql);
        sql = this.connection.applyPreProcessors(sql);
        LOGGER.info("Command text after pre-processing:\n {}", (Object)sql);
        Query q = null;
        UpdateRequest u = null;
        try {
            q = QueryFactory.create(sql);
        }
        catch (Exception e2) {
            try {
                u = UpdateFactory.create(sql);
            }
            catch (Exception e22) {
                LOGGER.error("Command text was not a valid SPARQL query/update", e22);
                throw new SQLException("Not a valid SPARQL query/update", e2);
            }
        }
        if (q != null) {
            LOGGER.info("Treating command text as a query");
            return this.executeQuery(q);
        }
        if (u != null) {
            LOGGER.info("Treating command text as an update");
            this.executeUpdate(u);
            return false;
        }
        throw new SQLException("Unable to create a SPARQL query/update");
    }

    private boolean executeQuery(Query q) throws SQLException {
        if (this.isClosed()) {
            throw new SQLException("The Statement is closed");
        }
        boolean needsBegin = !this.autoCommit && this.transactionLevel != 0 && !this.hasActiveTransaction();
        boolean needsCommit = this.autoCommit && this.transactionLevel != 0;
        try {
            if (needsCommit) {
                LOGGER.info("Running query in auto-commit mode");
                this.beginTransaction(ReadWrite.READ);
            } else if (needsBegin) {
                LOGGER.info("Starting a new transaction to run query, transaction will not be auto-committed");
                this.beginTransaction(ReadWrite.WRITE);
            }
        }
        catch (Exception e2) {
            LOGGER.error("Starting the new transaction failed", e2);
            throw new SQLException("Failed to start a new query transaction", e2);
        }
        try {
            q = this.connection.applyPreProcessors(q);
            if (!(this.maxRows <= 0 || q.hasLimit() && q.getLimit() <= (long)this.maxRows)) {
                LOGGER.info("Enforced max rows on results by applying LIMIT {} to the query", (Object)this.maxRows);
                q.setLimit(this.maxRows);
            }
            QueryExecution qe = this.createQueryExecution(q);
            if (this.timeout > 0) {
                qe.setTimeout(this.timeout, TimeUnit.SECONDS, this.timeout, TimeUnit.SECONDS);
            }
            if (q.isSelectType()) {
                switch (this.type) {
                    case 1004: {
                        this.currResults = new MaterializedSelectResults(this, qe, ResultSetFactory.makeRewindable(this.connection.applyPostProcessors(qe.execSelect())), false);
                        break;
                    }
                    default: {
                        this.currResults = new SelectResults(this, qe, this.connection.applyPostProcessors(qe.execSelect()), needsCommit);
                        break;
                    }
                }
            } else if (q.isAskType()) {
                boolean askRes = qe.execAsk();
                qe.close();
                this.currResults = new AskResults(this, this.connection.applyPostProcessors(askRes), needsCommit);
            } else if (q.isDescribeType()) {
                switch (this.type) {
                    case 1004: {
                        this.currResults = new TripleListResults(this, qe, Iter.toList(this.connection.applyPostProcessors(qe.execDescribeTriples())), false);
                        break;
                    }
                    default: {
                        this.currResults = new TripleIteratorResults(this, qe, this.connection.applyPostProcessors(qe.execDescribeTriples()), needsCommit);
                        break;
                    }
                }
            } else if (q.isConstructType()) {
                switch (this.type) {
                    case 1004: {
                        this.currResults = new TripleListResults(this, qe, Iter.toList(this.connection.applyPostProcessors(qe.execConstructTriples())), false);
                        break;
                    }
                    default: {
                        this.currResults = new TripleIteratorResults(this, qe, this.connection.applyPostProcessors(qe.execConstructTriples()), needsCommit);
                        break;
                    }
                }
            } else {
                throw new SQLException("Unknown SPARQL Query type");
            }
            if (this.type == 1004 && needsCommit) {
                LOGGER.info("Auto-committing query transaction since results have been materialized");
                this.commitTransaction();
            }
            return true;
        }
        catch (SQLException e3) {
            if (needsCommit) {
                LOGGER.warn("Rolling back failed query transaction", e3);
                this.rollbackTransaction();
            }
            throw e3;
        }
        catch (Throwable e4) {
            LOGGER.error("SPARQL Query evaluation failed", e4);
            if (needsCommit) {
                LOGGER.warn("Rolling back failed query transaction");
                this.rollbackTransaction();
            }
            throw new SQLException("Error occurred during SPARQL query evaluation", e4);
        }
    }

    protected abstract QueryExecution createQueryExecution(Query var1) throws SQLException;

    private int executeUpdate(UpdateRequest u) throws SQLException {
        if (this.isClosed()) {
            throw new SQLException("The Statement is closed");
        }
        if (this.connection.isReadOnly()) {
            throw new SQLException("The JDBC connection is currently in read-only mode, updates are not permitted");
        }
        boolean needsBegin = !this.autoCommit && this.transactionLevel != 0 && !this.hasActiveTransaction();
        boolean needsCommit = this.autoCommit && this.transactionLevel != 0;
        try {
            if (needsCommit || needsBegin) {
                if (this.autoCommit) {
                    LOGGER.info("Running update in auto-commit mode");
                } else {
                    LOGGER.info("Starting a new transaction to run update, transaction will not be auto-committed");
                }
                this.beginTransaction(ReadWrite.WRITE);
            }
        }
        catch (Exception e2) {
            LOGGER.error("Starting the new transaction failed", e2);
            throw new SQLException("Failed to start a new query transaction", e2);
        }
        try {
            u = this.connection.applyPreProcessors(u);
            UpdateProcessor processor = this.createUpdateProcessor(u);
            processor.execute();
            if (needsCommit) {
                LOGGER.info("Auto-committing update transaction");
                this.commitTransaction();
            }
            return 0;
        }
        catch (SQLException e3) {
            if (needsCommit) {
                LOGGER.warn("Rolling back failed update transaction", e3);
                this.rollbackTransaction();
            }
            throw e3;
        }
        catch (Exception e4) {
            LOGGER.error("SPARQL Update evaluation failed", e4);
            if (needsCommit) {
                LOGGER.warn("Rolling back failed update transaction");
                this.rollbackTransaction();
            }
            throw new SQLException("Error occurred during SPARQL update evaluation", e4);
        }
    }

    protected abstract UpdateProcessor createUpdateProcessor(UpdateRequest var1) throws SQLException;

    protected abstract boolean hasActiveTransaction() throws SQLException;

    protected abstract void beginTransaction(ReadWrite var1) throws SQLException;

    protected abstract void commitTransaction() throws SQLException;

    protected abstract void rollbackTransaction() throws SQLException;

    @Override
    public boolean execute(String sql, int autoGeneratedKeys) throws SQLException {
        return this.execute(sql);
    }

    @Override
    public boolean execute(String sql, int[] columnIndexes) throws SQLException {
        return this.execute(sql);
    }

    @Override
    public boolean execute(String sql, String[] columnNames) throws SQLException {
        return this.execute(sql);
    }

    @Override
    public final int[] executeBatch() throws SQLException {
        if (this.isClosed()) {
            throw new SQLException("The Statement is closed");
        }
        if (this.commands.size() > 1 && this.autoCommit && this.holdability == 2) {
            this.setWarning("Executing this batch of commands may lead to unexpectedly closed result sets because auto-commit is enabled and commit behaviour is set to close cursors at commit");
        }
        int[] rets = new int[this.commands.size()];
        ResultSet curr = this.currResults;
        for (int i = 0; i < this.commands.size(); ++i) {
            if (this.execute(this.commands.get(i))) {
                this.results.add(this.getResultSet());
                this.currResults = null;
                rets[i] = -2;
                continue;
            }
            this.results.add(null);
            rets[i] = this.getUpdateCount();
        }
        this.currResults = curr;
        if (this.currResults == null && !this.results.isEmpty()) {
            this.currResults = this.results.poll();
        }
        return rets;
    }

    @Override
    public final ResultSet executeQuery(String sql) throws SQLException {
        if (this.isClosed()) {
            throw new SQLException("The Statement is closed");
        }
        LOGGER.info("Received input command text:\n {}", (Object)sql);
        sql = this.connection.applyPreProcessors(sql);
        LOGGER.info("Command text after pre-processing:\n {}", (Object)sql);
        Query q = null;
        try {
            q = QueryFactory.create(sql);
        }
        catch (Exception e2) {
            LOGGER.error("Invalid SPARQL query", e2);
            throw new SQLException("Not a valid SPARQL query", e2);
        }
        if (q == null) {
            throw new SQLException("Unable to create a SPARQL Query");
        }
        if (this.executeQuery(q)) {
            return this.currResults;
        }
        throw new SQLException("Query did not produce a result set");
    }

    @Override
    public final int executeUpdate(String sql) throws SQLException {
        if (this.isClosed()) {
            throw new SQLException("The Statement is closed");
        }
        if (this.connection.isReadOnly()) {
            throw new SQLException("The JDBC connection is currently in read-only mode, updates are not permitted");
        }
        LOGGER.info("Received input command text:\n {}", (Object)sql);
        sql = this.connection.applyPreProcessors(sql);
        LOGGER.info("Command text after pre-processing:\n {}", (Object)sql);
        UpdateRequest u = null;
        try {
            u = UpdateFactory.create(sql);
        }
        catch (Exception e2) {
            LOGGER.error("Invalid SPARQL update", e2);
            throw new SQLException("Not a valid SPARQL Update", e2);
        }
        if (u == null) {
            throw new SQLException("Unable to create a SPARQL Update Request");
        }
        return this.executeUpdate(u);
    }

    @Override
    public int executeUpdate(String sql, int autoGeneratedKeys) throws SQLException {
        return this.executeUpdate(sql);
    }

    @Override
    public int executeUpdate(String sql, int[] columnIndexes) throws SQLException {
        return this.executeUpdate(sql);
    }

    @Override
    public int executeUpdate(String sql, String[] columnNames) throws SQLException {
        return this.executeUpdate(sql);
    }

    @Override
    public final Connection getConnection() {
        return this.connection;
    }

    @Override
    public int getFetchDirection() {
        return this.fetchDirection;
    }

    @Override
    public int getFetchSize() {
        return this.fetchSize;
    }

    @Override
    public ResultSet getGeneratedKeys() throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public int getMaxFieldSize() {
        return 0;
    }

    @Override
    public int getMaxRows() {
        return this.maxRows;
    }

    @Override
    public boolean getMoreResults() throws SQLException {
        if (this.isClosed()) {
            throw new SQLException("The Statement is closed");
        }
        if (this.currResults != null) {
            this.currResults.close();
            this.currResults = null;
        }
        if (!this.results.isEmpty()) {
            this.currResults = this.results.poll();
            return true;
        }
        return false;
    }

    @Override
    public boolean getMoreResults(int current) throws SQLException {
        if (this.isClosed()) {
            throw new SQLException("The Statement is closed");
        }
        switch (current) {
            case 1: {
                return this.getMoreResults();
            }
            case 3: {
                for (ResultSet rset : this.openResults) {
                    rset.close();
                }
                this.openResults.clear();
                return this.getMoreResults();
            }
            case 2: {
                if (this.currResults != null) {
                    this.openResults.add(this.currResults);
                    this.currResults = null;
                }
                return this.getMoreResults();
            }
        }
        throw new SQLFeatureNotSupportedException("Unsupported mode for dealing with current results, only Statement.CLOSE_CURRENT_RESULT, Statement.CLOSE_ALL_RESULTS and Statement.KEEP_CURRENT_RESULT are supported");
    }

    @Override
    public int getQueryTimeout() {
        return this.timeout;
    }

    @Override
    public final ResultSet getResultSet() throws SQLException {
        if (this.isClosed()) {
            throw new SQLException("The Statement is closed");
        }
        return this.currResults;
    }

    protected void setCurrentResults(ResultSet results) throws SQLException {
        if (this.currResults != null) {
            this.currResults.close();
        }
        this.currResults = results;
    }

    @Override
    public final int getResultSetConcurrency() {
        return 1007;
    }

    @Override
    public int getResultSetHoldability() {
        return this.holdability;
    }

    protected void checkHoldability(int h) throws SQLException {
        switch (h) {
            case 1: 
            case 2: {
                return;
            }
        }
        throw new SQLException(String.format("Holdability %d is supported for Jena JDBC statements", h));
    }

    @Override
    public final int getResultSetType() {
        return this.type;
    }

    @Override
    public int getUpdateCount() {
        return this.updateCount;
    }

    protected void setUpdateCount(int count) {
        this.updateCount = count;
    }

    @Override
    public SQLWarning getWarnings() {
        return this.warnings;
    }

    protected void setWarning(SQLWarning warning) {
        LOGGER.warn("SQL Warning was issued", warning);
        if (this.warnings == null) {
            this.warnings = warning;
        } else {
            warning.setNextWarning(this.warnings);
            this.warnings = warning;
        }
    }

    protected void setWarning(String warning) {
        this.setWarning(new SQLWarning(warning));
    }

    protected void setWarning(String warning, Throwable cause) {
        this.setWarning(new SQLWarning(warning, cause));
    }

    @Override
    public final boolean isClosed() {
        return this.closed;
    }

    @Override
    public final boolean isPoolable() {
        return true;
    }

    @Override
    public void setCursorName(String name) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void setEscapeProcessing(boolean enable) {
        this.escapeProcessing = enable;
    }

    @Override
    public void setFetchDirection(int direction) throws SQLException {
        this.checkFetchDirection(direction);
        this.fetchDirection = direction;
    }

    protected void checkFetchDirection(int dir) throws SQLException {
        switch (dir) {
            case 1000: {
                return;
            }
        }
        throw new SQLFeatureNotSupportedException("Only ResultSet.FETCH_FORWARD is supported as a fetch direction");
    }

    @Override
    public void setFetchSize(int rows) {
        this.fetchSize = rows;
    }

    @Override
    public void setMaxFieldSize(int max2) {
        this.setWarning("setMaxFieldSize() was called but there is no field size limit for Jena JDBC connections");
    }

    @Override
    public void setMaxRows(int max2) {
        this.maxRows = max2 <= 0 ? 0 : max2;
    }

    @Override
    public void setPoolable(boolean poolable) {
        this.setWarning("setPoolable() was called but Jena JDBC statements are always considered poolable");
    }

    @Override
    public void setQueryTimeout(int seconds) {
        this.timeout = seconds <= 0 ? 0 : seconds;
    }

    @Override
    public boolean isCloseOnCompletion() {
        return false;
    }

    @Override
    public void closeOnCompletion() throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }
}

