/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.jdbc.results.metadata;

import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.util.List;
import org.apache.jena.jdbc.JdbcCompatibility;
import org.apache.jena.jdbc.results.JenaResultSet;
import org.apache.jena.jdbc.results.metadata.JenaResultsMetadata;
import org.apache.jena.jdbc.results.metadata.columns.ColumnInfo;
import org.apache.jena.jdbc.results.metadata.columns.SparqlColumnInfo;
import org.apache.jena.jdbc.results.metadata.columns.StringColumn;
import org.apache.jena.query.ResultSet;
import org.apache.jena.query.ResultSetFactory;
import org.apache.jena.sparql.core.Var;
import org.apache.jena.sparql.engine.binding.Binding;
import org.apache.jena.sparql.resultset.ResultSetPeekable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SelectResultsMetadata
extends JenaResultsMetadata {
    private static final Logger LOGGER = LoggerFactory.getLogger(SelectResultsMetadata.class);
    private ResultSetPeekable innerResults;

    public SelectResultsMetadata(JenaResultSet results, ResultSetPeekable rset) throws SQLException {
        super(results, SelectResultsMetadata.makeColumns(results, rset));
        this.innerResults = rset;
    }

    public SelectResultsMetadata(JenaResultSet results, ResultSet rset) throws SQLException {
        this(results, ResultSetFactory.makePeekable(rset));
    }

    public SelectResultsMetadata(SelectResultsMetadata metadata, ColumnInfo[] columns) throws SQLException {
        super(metadata.getJenaResultSet(), columns);
        this.innerResults = metadata.innerResults;
    }

    private static ColumnInfo[] makeColumns(JenaResultSet results, ResultSetPeekable rset) throws SQLException {
        List<String> vars = rset.getResultVars();
        ColumnInfo[] columns = new ColumnInfo[vars.size()];
        int level = JdbcCompatibility.normalizeLevel(results.getJdbcCompatibilityLevel());
        boolean columnsAsStrings = JdbcCompatibility.shouldTypeColumnsAsString(level);
        boolean columnsDetected = JdbcCompatibility.shouldDetectColumnTypes(level);
        Binding b = null;
        if (columnsDetected) {
            if (rset.hasNext()) {
                b = rset.peekBinding();
            } else {
                columnsAsStrings = true;
                columnsDetected = false;
            }
        }
        for (int i = 0; i < columns.length; ++i) {
            if (!columnsAsStrings && !columnsDetected) {
                columns[i] = new SparqlColumnInfo(vars.get(i), 2000, 1);
                LOGGER.info("Low JDBC compatibility, column " + vars.get(i) + " is being typed as Node");
                continue;
            }
            if (columnsAsStrings) {
                columns[i] = new StringColumn(vars.get(i), 1);
                LOGGER.info("Medium JDBC compatibility, column " + vars.get(i) + " is being typed as String");
                continue;
            }
            if (columnsDetected) {
                columns[i] = JdbcCompatibility.detectColumnType(vars.get(i), b.get(Var.alloc(vars.get(i))), true);
                LOGGER.info("High compatibility, column " + vars.get(i) + " was detected as being of type " + columns[i].getClassName());
                continue;
            }
            throw new SQLFeatureNotSupportedException("Unknown JDBC compatibility level was set");
        }
        return columns;
    }
}

