/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.jdbc.results;

import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Stack;
import org.apache.jena.atlas.lib.Closeable;
import org.apache.jena.graph.Node;
import org.apache.jena.jdbc.results.JenaResultSet;
import org.apache.jena.jdbc.results.MaterializedResults;
import org.apache.jena.jdbc.results.metadata.SelectResultsMetadata;
import org.apache.jena.jdbc.statements.JenaStatement;
import org.apache.jena.query.QueryExecution;
import org.apache.jena.query.ResultSetRewindable;
import org.apache.jena.sparql.core.Var;
import org.apache.jena.sparql.engine.binding.Binding;

public class MaterializedSelectResults
extends MaterializedResults<Binding> {
    private ResultSetRewindable innerResults;
    private Stack<Binding> previousResults = new Stack();
    private Stack<Binding> nextResults = new Stack();
    private List<String> columns;
    private SelectResultsMetadata metadata;

    public MaterializedSelectResults(JenaStatement statement, QueryExecution qe, ResultSetRewindable results, boolean commit) throws SQLException {
        super(statement, qe, commit);
        if (results == null) {
            throw new SQLException("SPARQL Results cannot be null");
        }
        this.innerResults = results;
        this.columns = new ArrayList<String>(this.innerResults.getResultVars());
        this.metadata = new SelectResultsMetadata((JenaResultSet)this, this.innerResults);
        this.innerResults.reset();
    }

    @Override
    public void closeStreamInternal() {
        if (this.innerResults != null) {
            if (this.innerResults instanceof Closeable) {
                ((Closeable)((Object)this.innerResults)).close();
            }
            this.innerResults = null;
        }
    }

    @Override
    public int findColumn(String columnLabel) throws SQLException {
        if (this.isClosed()) {
            throw new SQLException("Result Set is closed");
        }
        for (int i = 0; i < this.columns.size(); ++i) {
            if (!this.columns.get(i).equals(columnLabel)) continue;
            return i + 1;
        }
        throw new SQLException("The given column does not exist in this result set");
    }

    @Override
    protected String findColumnLabel(int columnIndex) throws SQLException {
        if (this.isClosed()) {
            throw new SQLException("Result Set is closed");
        }
        if (columnIndex >= 1 && columnIndex <= this.columns.size()) {
            return this.columns.get(columnIndex - 1);
        }
        throw new SQLException("Column Index is out of bounds");
    }

    @Override
    protected Node getNode(String columnLabel) throws SQLException {
        if (this.isClosed()) {
            throw new SQLException("Result Set is closed");
        }
        if (this.getCurrentRow() == null) {
            throw new SQLException("Not currently at a row");
        }
        if (!this.columns.contains(columnLabel)) {
            throw new SQLException("The given column does not exist in the result set");
        }
        return ((Binding)this.getCurrentRow()).get(Var.alloc(columnLabel));
    }

    @Override
    public ResultSetMetaData getMetaData() {
        return this.metadata;
    }

    @Override
    protected boolean hasNext() {
        return !this.nextResults.isEmpty() || this.innerResults.hasNext();
    }

    @Override
    protected Binding moveNext() {
        if (this.nextResults.isEmpty()) {
            this.previousResults.push(this.innerResults.nextBinding());
        } else {
            this.previousResults.push(this.nextResults.pop());
        }
        return this.previousResults.peek();
    }

    @Override
    protected boolean hasPrevious() {
        return this.previousResults.size() > 0;
    }

    @Override
    protected Binding movePrevious() {
        this.nextResults.push(this.previousResults.pop());
        return this.nextResults.peek();
    }

    @Override
    protected int getTotalRows() {
        return this.innerResults.size();
    }
}

