/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.jdbc.remote.connections;

import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.util.List;
import org.apache.jena.atlas.web.auth.HttpAuthenticator;
import org.apache.jena.jdbc.connections.JenaConnection;
import org.apache.jena.jdbc.remote.metadata.RemoteEndpointMetadata;
import org.apache.jena.jdbc.remote.statements.RemoteEndpointPreparedStatement;
import org.apache.jena.jdbc.remote.statements.RemoteEndpointStatement;
import org.apache.jena.jdbc.statements.JenaPreparedStatement;
import org.apache.jena.jdbc.statements.JenaStatement;

public class RemoteEndpointConnection
extends JenaConnection {
    private String queryService;
    private String updateService;
    private boolean closed = false;
    private boolean readonly = false;
    private List<String> defaultGraphUris;
    private List<String> namedGraphUris;
    private List<String> usingGraphUris;
    private List<String> usingNamedGraphUris;
    private HttpAuthenticator authenticator;
    private DatabaseMetaData metadata;
    private String selectResultsType;
    private String modelResultsType;

    public RemoteEndpointConnection(String queryEndpoint, String updateEndpoint, int holdability, int compatibilityLevel) throws SQLException {
        this(queryEndpoint, updateEndpoint, null, null, null, null, null, holdability, compatibilityLevel, null, null);
    }

    public RemoteEndpointConnection(String queryEndpoint, String updateEndpoint, List<String> defaultGraphUris, List<String> namedGraphUris, List<String> usingGraphUris, List<String> usingNamedGraphUris, HttpAuthenticator authenticator, int holdability, int compatibilityLevel, String selectResultsType, String modelResultsType) throws SQLException {
        super(holdability, true, 0, compatibilityLevel);
        if (queryEndpoint == null && updateEndpoint == null) {
            throw new SQLException("Must specify one/both of a query endpoint and update endpoint");
        }
        this.queryService = queryEndpoint;
        this.updateService = updateEndpoint;
        this.readonly = this.updateService == null;
        this.defaultGraphUris = defaultGraphUris;
        this.namedGraphUris = namedGraphUris;
        this.usingGraphUris = usingGraphUris;
        this.usingNamedGraphUris = usingNamedGraphUris;
        this.authenticator = authenticator;
        this.metadata = new RemoteEndpointMetadata(this);
        this.selectResultsType = selectResultsType;
        this.modelResultsType = modelResultsType;
    }

    public String getQueryEndpoint() {
        return this.queryService;
    }

    public String getUpdateEndpoint() {
        return this.updateService;
    }

    public List<String> getDefaultGraphURIs() {
        return this.defaultGraphUris;
    }

    public List<String> getNamedGraphURIs() {
        return this.namedGraphUris;
    }

    public List<String> getUsingGraphURIs() {
        return this.usingGraphUris;
    }

    public List<String> getUsingNamedGraphURIs() {
        return this.usingNamedGraphUris;
    }

    public String getSelectResultsType() {
        return this.selectResultsType;
    }

    public String getModelResultsType() {
        return this.modelResultsType;
    }

    @Override
    protected void closeInternal() {
        this.closed = true;
    }

    @Override
    protected JenaStatement createStatementInternal(int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        if (this.isClosed()) {
            throw new SQLException("Cannot create a statement after the connection was closed");
        }
        if (resultSetType == 1005) {
            throw new SQLFeatureNotSupportedException("Remote endpoint backed connection do not support scroll sensitive result sets");
        }
        if (resultSetConcurrency != 1007) {
            throw new SQLFeatureNotSupportedException("Remote endpoint backed connections only support read-only result sets");
        }
        return new RemoteEndpointStatement(this, this.authenticator, resultSetType, 1000, 0, resultSetHoldability);
    }

    @Override
    protected JenaPreparedStatement createPreparedStatementInternal(String sparql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        if (this.isClosed()) {
            throw new SQLException("Cannot create a statement after the connection was closed");
        }
        if (resultSetType == 1005) {
            throw new SQLFeatureNotSupportedException("Remote endpoint backed connection do not support scroll sensitive result sets");
        }
        if (resultSetConcurrency != 1007) {
            throw new SQLFeatureNotSupportedException("Remote endpoint backed connections only support read-only result sets");
        }
        return new RemoteEndpointPreparedStatement(sparql, this, this.authenticator, resultSetType, 1000, 0, resultSetHoldability);
    }

    @Override
    public boolean isClosed() {
        return this.closed;
    }

    @Override
    public boolean isReadOnly() {
        return this.readonly;
    }

    @Override
    public boolean isValid(int timeout) {
        return !this.isClosed();
    }

    @Override
    public void setReadOnly(boolean readOnly) throws SQLException {
        if (this.isClosed()) {
            throw new SQLException("Cannot set read-only mode on a closed connection");
        }
        if (readOnly) {
            this.readonly = readOnly;
        } else {
            if (this.updateService == null) {
                throw new SQLException("Cannot set connection to read/write as it was created without an update endpoint");
            }
            this.readonly = readOnly;
        }
    }

    @Override
    public DatabaseMetaData getMetaData() {
        return this.metadata;
    }

    @Override
    protected void commitInternal() {
    }

    @Override
    protected void rollbackInternal() {
    }

    @Override
    protected void checkTransactionIsolation(int level) throws SQLException {
        switch (level) {
            case 0: {
                return;
            }
        }
        throw new SQLFeatureNotSupportedException("Transactions are not supported for remote endpoint backed connections");
    }

    public boolean isUsingAuthentication() {
        return this.authenticator != null;
    }
}

