/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.jdbc.remote;

import java.net.URI;
import java.net.URISyntaxException;
import java.sql.DriverManager;
import java.sql.DriverPropertyInfo;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;
import org.apache.jena.atlas.web.auth.FormLogin;
import org.apache.jena.atlas.web.auth.FormsAuthenticator;
import org.apache.jena.atlas.web.auth.HttpAuthenticator;
import org.apache.jena.atlas.web.auth.PreemptiveBasicAuthenticator;
import org.apache.jena.atlas.web.auth.SimpleAuthenticator;
import org.apache.jena.jdbc.JenaDriver;
import org.apache.jena.jdbc.connections.JenaConnection;
import org.apache.jena.jdbc.remote.connections.RemoteEndpointConnection;
import org.apache.jena.system.JenaSystem;

public class RemoteEndpointDriver
extends JenaDriver {
    public static final String REMOTE_DRIVER_PREFIX = "remote:";
    public static final String PARAM_QUERY_ENDPOINT = "query";
    public static final String PARAM_UPDATE_ENDPOINT = "update";
    public static final String PARAM_DEFAULT_GRAPH_URI = "default-graph-uri";
    public static final String PARAM_NAMED_GRAPH_URI = "named-graph-uri";
    public static final String PARAM_USING_GRAPH_URI = "using-graph-uri";
    public static final String PARAM_USING_NAMED_GRAPH_URI = "using-named-graph-uri";
    public static final String PARAM_SELECT_RESULTS_TYPE = "select-results-type";
    public static final String PARAM_MODEL_RESULTS_TYPE = "model-results-type";
    public static final String PARAM_FORMS_LOGIN_URL = "form-url";
    public static final String PARAM_FORMS_LOGIN_USER_FIELD = "form-user-field";
    public static final String PARAM_FORMS_LOGIN_PASSWORD_FIELD = "form-password-field";
    public static final String PARAM_PREEMPTIVE_AUTH = "preemptive-auth";
    public static final String PARAM_AUTHENTICATOR = "authenticator";

    public static synchronized void register() throws SQLException {
        DriverManager.registerDriver(new RemoteEndpointDriver());
    }

    public RemoteEndpointDriver() {
        super(0, 1, REMOTE_DRIVER_PREFIX);
    }

    protected RemoteEndpointDriver(int majorVersion, int minorVersion, String driverPrefix) {
        super(majorVersion, minorVersion, driverPrefix);
    }

    @Override
    protected JenaConnection connect(Properties props, int compatibilityLevel) throws SQLException {
        String queryEndpoint = props.getProperty(PARAM_QUERY_ENDPOINT);
        String updateEndpoint = props.getProperty(PARAM_UPDATE_ENDPOINT);
        if (queryEndpoint == null && updateEndpoint == null) {
            throw new SQLException("At least one of the query or update connection parameters must be specified to make a remote connection");
        }
        List<String> defaultGraphs = this.getValues(props, PARAM_DEFAULT_GRAPH_URI);
        List<String> namedGraphs = this.getValues(props, PARAM_NAMED_GRAPH_URI);
        List<String> usingGraphs = this.getValues(props, PARAM_USING_GRAPH_URI);
        List<String> usingNamedGraphs = this.getValues(props, PARAM_USING_NAMED_GRAPH_URI);
        HttpAuthenticator authenticator = this.configureAuthenticator(queryEndpoint, updateEndpoint, props);
        String selectResultsType = props.getProperty(PARAM_SELECT_RESULTS_TYPE, null);
        String modelResultsType = props.getProperty(PARAM_MODEL_RESULTS_TYPE, null);
        return this.openConnection(queryEndpoint, updateEndpoint, defaultGraphs, namedGraphs, usingGraphs, usingNamedGraphs, authenticator, 2, compatibilityLevel, selectResultsType, modelResultsType);
    }

    protected HttpAuthenticator configureAuthenticator(String queryEndpoint, String updateEndpoint, Properties props) throws SQLException {
        String password;
        Object authObj = props.get(PARAM_AUTHENTICATOR);
        if (authObj != null) {
            if (authObj instanceof HttpAuthenticator) {
                return (HttpAuthenticator)authObj;
            }
            throw new SQLException("The authenticator parameter is specified but the value is not an object implementing the required HttpAuthenticator interface");
        }
        String user = props.getProperty("user", null);
        if (user != null && user.trim().length() == 0) {
            user = null;
        }
        if ((password = props.getProperty("password", null)) != null && password.trim().length() == 0) {
            password = null;
        }
        if (user == null || password == null) {
            return null;
        }
        String loginURL = props.getProperty(PARAM_FORMS_LOGIN_URL);
        if (loginURL != null) {
            String userField = props.getProperty(PARAM_FORMS_LOGIN_USER_FIELD, "httpd_username");
            String pwdField = props.getProperty(PARAM_FORMS_LOGIN_PASSWORD_FIELD, "httpd_password");
            HashMap<URI, FormLogin> logins = new HashMap<URI, FormLogin>();
            String baseUri = this.getCommonBase(queryEndpoint, updateEndpoint);
            if (baseUri != null) {
                try {
                    logins.put(new URI(baseUri), new FormLogin(loginURL, userField, pwdField, user, password.toCharArray()));
                }
                catch (URISyntaxException e2) {
                    throw new SQLException("Unable to configure form based login due to invalid Base URI", e2);
                }
            }
            if (queryEndpoint != null) {
                try {
                    logins.put(new URI(queryEndpoint), new FormLogin(loginURL, userField, pwdField, user, password.toCharArray()));
                }
                catch (URISyntaxException e3) {
                    throw new SQLException("Unable to configure form based login due to invalid Query Endpoint URI", e3);
                }
            }
            if (updateEndpoint != null) {
                try {
                    logins.put(new URI(updateEndpoint), new FormLogin(loginURL, userField, pwdField, user, password.toCharArray()));
                }
                catch (URISyntaxException e4) {
                    throw new SQLException("Unable to configure form based login due to invalid Update Endpoint URI", e4);
                }
            }
            return new FormsAuthenticator(logins);
        }
        if (this.isTrue(props, PARAM_PREEMPTIVE_AUTH)) {
            return new PreemptiveBasicAuthenticator(new SimpleAuthenticator(user, password.toCharArray()));
        }
        return new SimpleAuthenticator(user, password.toCharArray());
    }

    protected String getCommonBase(String x, String y) {
        if (x == null) {
            if (y == null) {
                return null;
            }
            return this.stripIrrelevantComponents(y);
        }
        if (y == null) {
            return this.stripIrrelevantComponents(x);
        }
        if (x.equals(y)) {
            return this.stripIrrelevantComponents(x);
        }
        if (x.length() < y.length() && y.startsWith(x)) {
            return this.stripIrrelevantComponents(x);
        }
        if (y.length() < x.length() && x.startsWith(y)) {
            return this.stripIrrelevantComponents(y);
        }
        if (x.length() < y.length()) {
            y = this.stripLastComponent(y);
        } else if (x.length() > y.length()) {
            x = this.stripLastComponent(x);
        } else {
            x = this.stripLastComponent(x);
            y = this.stripLastComponent(y);
        }
        if (x == null || y == null) {
            return null;
        }
        return this.getCommonBase(x, y);
    }

    private String stripLastComponent(String input) {
        try {
            URI uri = new URI(input);
            if (uri.getFragment() != null) {
                return new URI(uri.getScheme(), uri.getUserInfo(), uri.getHost(), uri.getPort(), uri.getPath(), uri.getQuery(), null).toString();
            }
            if (uri.getQuery() != null) {
                return new URI(uri.getScheme(), uri.getUserInfo(), uri.getHost(), uri.getPort(), uri.getPath(), null, null).toString();
            }
            if (uri.getPath() != null) {
                String currPath = uri.getPath();
                if (currPath.endsWith("/")) {
                    if ((currPath = currPath.substring(0, currPath.length() - 1)).length() == 0) {
                        currPath = null;
                    }
                    return new URI(uri.getScheme(), uri.getUserInfo(), uri.getHost(), uri.getPort(), currPath, null, null).toString();
                }
                if (currPath.contains("/")) {
                    if ((currPath = currPath.substring(0, currPath.lastIndexOf(47) + 1)).length() == 0) {
                        currPath = null;
                    }
                    return new URI(uri.getScheme(), uri.getUserInfo(), uri.getHost(), uri.getPort(), currPath, null, null).toString();
                }
                return null;
            }
            return null;
        }
        catch (URISyntaxException e2) {
            return null;
        }
    }

    private String stripIrrelevantComponents(String input) {
        try {
            URI orig = new URI(input);
            return new URI(orig.getScheme(), orig.getUserInfo(), orig.getHost(), orig.getPort(), orig.getPath(), null, null).toString();
        }
        catch (URISyntaxException e2) {
            return null;
        }
    }

    protected RemoteEndpointConnection openConnection(String queryEndpoint, String updateEndpoint, List<String> defaultGraphs, List<String> namedGraphs, List<String> usingGraphs, List<String> usingNamedGraphs, HttpAuthenticator authenticator, int holdability, int compatibilityLevel, String selectResultsType, String modelResultsType) throws SQLException {
        return new RemoteEndpointConnection(queryEndpoint, updateEndpoint, defaultGraphs, namedGraphs, usingGraphs, usingNamedGraphs, authenticator, holdability, compatibilityLevel, selectResultsType, modelResultsType);
    }

    @Override
    protected boolean allowsMultipleValues(String key) {
        if (PARAM_DEFAULT_GRAPH_URI.equals(key) || PARAM_NAMED_GRAPH_URI.equals(key) || PARAM_USING_GRAPH_URI.equals(key) || PARAM_USING_NAMED_GRAPH_URI.equals(key)) {
            return true;
        }
        return super.allowsMultipleValues(key);
    }

    @Override
    protected DriverPropertyInfo[] getPropertyInfo(Properties connProps, List<DriverPropertyInfo> baseDriverProps) {
        DriverPropertyInfo[] driverProps = new DriverPropertyInfo[10 + baseDriverProps.size()];
        this.copyBaseProperties(driverProps, baseDriverProps, 10);
        driverProps[0] = new DriverPropertyInfo(PARAM_QUERY_ENDPOINT, connProps.getProperty(PARAM_QUERY_ENDPOINT));
        driverProps[0].required = !connProps.containsKey(PARAM_UPDATE_ENDPOINT);
        driverProps[0].description = "Sets the SPARQL Query endpoint to use for query operations, if this is specified and update is not then a read-only connection will be created";
        driverProps[1] = new DriverPropertyInfo(PARAM_UPDATE_ENDPOINT, connProps.getProperty(PARAM_UPDATE_ENDPOINT));
        driverProps[1].required = !connProps.containsKey(PARAM_UPDATE_ENDPOINT);
        driverProps[1].description = "Sets the SPARQL Update endpoint to use for update operations, if this is specified and query is not then a write-only connection will be created";
        driverProps[2] = new DriverPropertyInfo(PARAM_DEFAULT_GRAPH_URI, null);
        driverProps[2].required = false;
        driverProps[2].description = "Sets the URI for a default graph for queries, may be specified multiple times to specify multiple graphs which should form the default graph";
        driverProps[3] = new DriverPropertyInfo(PARAM_NAMED_GRAPH_URI, null);
        driverProps[3].required = false;
        driverProps[3].description = "Sets the URI for a named graph for queries, may be specified multiple times to specify multiple named graphs which should be accessible";
        driverProps[4] = new DriverPropertyInfo(PARAM_USING_GRAPH_URI, null);
        driverProps[4].required = false;
        driverProps[4].description = "Sets the URI for a default graph for updates, may be specified multiple times to specify multiple graphs which should form the default graph";
        driverProps[5] = new DriverPropertyInfo(PARAM_USING_NAMED_GRAPH_URI, null);
        driverProps[5].required = false;
        driverProps[5].description = "Sets the URI for a named graph for updates, may be specified multiple times to specify multiple named graph which should be accessible";
        driverProps[6] = new DriverPropertyInfo(PARAM_SELECT_RESULTS_TYPE, connProps.getProperty(PARAM_SELECT_RESULTS_TYPE));
        driverProps[6].required = false;
        driverProps[6].description = "Sets the results type for SELECT queries that will be requested from the remote endpoint";
        driverProps[7] = new DriverPropertyInfo(PARAM_MODEL_RESULTS_TYPE, connProps.getProperty(PARAM_MODEL_RESULTS_TYPE));
        driverProps[7].required = false;
        driverProps[7].description = "Sets the results type for CONSTRUCT and DESCRIBE queries that will be requested from the remote endpoint";
        driverProps[8] = new DriverPropertyInfo("user", connProps.getProperty("user"));
        driverProps[9] = new DriverPropertyInfo("password", connProps.getProperty("password"));
        return driverProps;
    }

    static {
        try {
            JenaSystem.init();
            RemoteEndpointDriver.register();
        }
        catch (SQLException e2) {
            throw new RuntimeException("Failed to register Jena Remote Endpoint JDBC Driver", e2);
        }
    }
}

