/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.jdbc.metadata;

import java.sql.SQLException;
import org.apache.jena.jdbc.results.metadata.columns.BooleanColumn;
import org.apache.jena.jdbc.results.metadata.columns.ColumnInfo;
import org.apache.jena.jdbc.results.metadata.columns.IntegerColumn;
import org.apache.jena.jdbc.results.metadata.columns.ShortIntegerColumn;
import org.apache.jena.jdbc.results.metadata.columns.StringColumn;

public class MetadataSchema {
    private static boolean init = false;
    private static ColumnInfo[] ATTRIBUTE_COLUMNS;
    private static ColumnInfo[] BEST_ROW_IDENTIFIER_COLUMNS;
    private static ColumnInfo[] CATALOG_COLUMNS;
    private static ColumnInfo[] CLIENT_INFO_PROPERTY_COLUMNS;
    private static ColumnInfo[] COLUMN_COLUMNS;
    private static ColumnInfo[] COLUMN_PRIVILEGE_COLUMNS;
    private static ColumnInfo[] CROSS_REFERENCE_COLUMNS;
    private static ColumnInfo[] EXPORTED_KEY_COLUMNS;
    private static ColumnInfo[] FUNCTION_COLUMN_COLUMNS;
    private static ColumnInfo[] FUNCTION_COLUMNS;
    private static ColumnInfo[] IMPORTED_KEY_COLUMNS;
    private static ColumnInfo[] INDEX_INFO_COLUMNS;
    private static ColumnInfo[] PRIMARY_KEY_COLUMNS;
    private static ColumnInfo[] PROCEDURE_COLUMN_COLUMNS;
    private static ColumnInfo[] PROCEDURE_COLUMNS;
    private static ColumnInfo[] PSUEDO_COLUMN_COLUMNS;
    private static ColumnInfo[] SCHEMA_COLUMNS;
    private static ColumnInfo[] SUPER_TABLE_COLUMNS;
    private static ColumnInfo[] SUPER_TYPE_COLUMNS;
    private static ColumnInfo[] TABLE_PRIVILEGE_COLUMNS;
    private static ColumnInfo[] TABLE_TYPE_COLUMNS;
    private static ColumnInfo[] TABLE_COLUMNS;
    private static ColumnInfo[] TYPE_INFO_COLUMNS;
    private static ColumnInfo[] UDT_COLUMNS;
    private static ColumnInfo[] VERSION_COLUMNS;

    private MetadataSchema() {
    }

    public static ColumnInfo[] getAttributeColumns() {
        return ATTRIBUTE_COLUMNS;
    }

    public static ColumnInfo[] getBestRowIdentifierColumns() {
        return BEST_ROW_IDENTIFIER_COLUMNS;
    }

    public static ColumnInfo[] getCatalogsColumns() {
        return CATALOG_COLUMNS;
    }

    public static ColumnInfo[] getClientInfoPropertyColumns() {
        return CLIENT_INFO_PROPERTY_COLUMNS;
    }

    public static ColumnInfo[] getColumnColumns() {
        return COLUMN_COLUMNS;
    }

    public static ColumnInfo[] getColumnPrivilegeColumns() {
        return COLUMN_PRIVILEGE_COLUMNS;
    }

    public static ColumnInfo[] getCrossReferenceColumns() {
        return CROSS_REFERENCE_COLUMNS;
    }

    public static ColumnInfo[] getExportedKeyColumns() {
        return EXPORTED_KEY_COLUMNS;
    }

    public static ColumnInfo[] getFunctionColumnColumns() {
        return FUNCTION_COLUMN_COLUMNS;
    }

    public static ColumnInfo[] getFunctionColumns() {
        return FUNCTION_COLUMNS;
    }

    public static ColumnInfo[] getImportedKeyColumns() {
        return IMPORTED_KEY_COLUMNS;
    }

    public static ColumnInfo[] getIndexInfoColumns() {
        return INDEX_INFO_COLUMNS;
    }

    public static ColumnInfo[] getPrimaryKeyColumns() {
        return PRIMARY_KEY_COLUMNS;
    }

    public static ColumnInfo[] getProcedureColumnColumns() {
        return PROCEDURE_COLUMN_COLUMNS;
    }

    public static ColumnInfo[] getProcedureColumns() {
        return PROCEDURE_COLUMNS;
    }

    public static ColumnInfo[] getPsuedoColumnColumns() {
        return PSUEDO_COLUMN_COLUMNS;
    }

    public static ColumnInfo[] getSchemaColumns() {
        return SCHEMA_COLUMNS;
    }

    public static ColumnInfo[] getSuperTableColumns() {
        return SUPER_TABLE_COLUMNS;
    }

    public static ColumnInfo[] getSuperTypeColumns() {
        return SUPER_TYPE_COLUMNS;
    }

    public static ColumnInfo[] getTablePrivilegeColumns() {
        return TABLE_PRIVILEGE_COLUMNS;
    }

    public static ColumnInfo[] getTableTypeColumns() {
        return TABLE_TYPE_COLUMNS;
    }

    public static ColumnInfo[] getTableColumns() {
        return TABLE_COLUMNS;
    }

    public static ColumnInfo[] getTypeInfoColumns() {
        return TYPE_INFO_COLUMNS;
    }

    public static ColumnInfo[] getUdtColumns() {
        return UDT_COLUMNS;
    }

    public static ColumnInfo[] getVersionColumns() {
        return VERSION_COLUMNS;
    }

    private static synchronized void init() {
        if (init) {
            return;
        }
        try {
            StringColumn empty = new StringColumn("", 1);
            StringColumn typeCat = new StringColumn("TYPE_CATA", 1);
            StringColumn typeSchema = new StringColumn("TYPE_SCHEM", 1);
            StringColumn typeName = new StringColumn("TYPE_NAME", 0);
            StringColumn attrName = new StringColumn("ATTR_NAME", 0);
            IntegerColumn dataType = new IntegerColumn("DATA_TYPE", 0, true);
            StringColumn attrTypeName = new StringColumn("ATTR_TYPE_NAME", 0);
            IntegerColumn attrSize = new IntegerColumn("ATTR_SIZE", 0, true);
            IntegerColumn decimalDigits = new IntegerColumn("DECIMAL_DIGITS", 0, true);
            IntegerColumn numPrecRadix = new IntegerColumn("NUM_PREC_RADIX", 0, true);
            IntegerColumn nullable = new IntegerColumn("NULLABLE", 0, true);
            ShortIntegerColumn shortNullable = new ShortIntegerColumn("NULLABLE", 0, true);
            StringColumn remarks = new StringColumn("REMARKS", 1);
            StringColumn attrDef = new StringColumn("ATTR_DEF", 1);
            IntegerColumn sqlDataType = new IntegerColumn("SQL_DATA_TYPE", 0, true);
            IntegerColumn sqlDateTimeSub = new IntegerColumn("SQL_DATETIME_SUB", 0, true);
            IntegerColumn charOctetLength = new IntegerColumn("CHAR_OCTET_LENGTH", 0, true);
            IntegerColumn ordinalPosition = new IntegerColumn("ORDINAL_POSITION", 0, true);
            StringColumn isNullable = new StringColumn("IS_NULLABLE", 0);
            ShortIntegerColumn scope = new ShortIntegerColumn("SCOPE", 0, true);
            StringColumn scopeCatalog = new StringColumn("SCOPE_CATALOG", 1);
            StringColumn scopeSchema = new StringColumn("SCOPE_SCHEMA", 1);
            StringColumn scopeTable = new StringColumn("SCOPE_TABLE", 1);
            ShortIntegerColumn sourceDataType = new ShortIntegerColumn("SOURCE_DATA_TYPE", 1, true);
            StringColumn columnName = new StringColumn("COLUMN_NAME", 0);
            IntegerColumn columnSize = new IntegerColumn("COLUMN_SIZE", 0, true);
            StringColumn columnDef = new StringColumn("COLUMN_DEF", 1);
            IntegerColumn bufferLength = new IntegerColumn("BUFFER_LENGTH", 0, true);
            ShortIntegerColumn psuedoColumn = new ShortIntegerColumn("PSUEDO_COLUMN", 0, true);
            StringColumn tableCat = new StringColumn("TABLE_CAT", 1);
            StringColumn tableCatalog = new StringColumn("TABLE_CATALOG", 1);
            StringColumn tableSchema = new StringColumn("TABLE_SCHEM", 1);
            StringColumn tableName = new StringColumn("TABLE_NAME", 0);
            StringColumn name = new StringColumn("NAME", 0);
            IntegerColumn maxLen = new IntegerColumn("MAX_LEN", 0, true);
            StringColumn defaultValue = new StringColumn("DEFAULT_VALUE", 1);
            StringColumn description = new StringColumn("DESCRIPTION", 1);
            StringColumn isAutoIncrement = new StringColumn("IS_AUTOINCREMENT", 0);
            StringColumn className = new StringColumn("CLASS_NAME", 0);
            ShortIntegerColumn baseType = new ShortIntegerColumn("BASE_TYPE", 1, true);
            StringColumn grantor = new StringColumn("GRANTOR", 1);
            StringColumn grantee = new StringColumn("GRANTEE", 1);
            StringColumn privilege = new StringColumn("PRIVILEGE", 0);
            StringColumn isGrantable = new StringColumn("IS_GRANTABLE", 0);
            StringColumn pkTableCat = new StringColumn("PKTABLE_CAT", 1);
            StringColumn pkTableSchema = new StringColumn("PKTABLE_SCHEM", 1);
            StringColumn pkTableName = new StringColumn("PKTABLE_NAME", 0);
            StringColumn pkColumnName = new StringColumn("PKCOLUMN_NAME", 0);
            StringColumn fkTableCat = new StringColumn("FKTABLE_CAT", 1);
            StringColumn fkTableSchema = new StringColumn("FKTABLE_SCHEM", 1);
            StringColumn fkTableName = new StringColumn("FKTABLE_NAME", 0);
            StringColumn fkColumnName = new StringColumn("FKCOLUMN_NAME", 0);
            ShortIntegerColumn keySeq = new ShortIntegerColumn("KEY_SEQ", 0, true);
            ShortIntegerColumn updateRule = new ShortIntegerColumn("UPDATE_RULE", 0, true);
            ShortIntegerColumn deleteRule = new ShortIntegerColumn("DELETE_RULE", 0, true);
            StringColumn fkName = new StringColumn("FK_NAME", 1);
            StringColumn pkName = new StringColumn("PK_NAME", 1);
            ShortIntegerColumn deferrability = new ShortIntegerColumn("DEFERRABILITY", 0, true);
            StringColumn functionCat = new StringColumn("FUNCTION_CAT", 1);
            StringColumn functionSchema = new StringColumn("FUNCTION_SCHEM", 1);
            StringColumn functionName = new StringColumn("FUNCTION_NAME", 0);
            ShortIntegerColumn columnType = new ShortIntegerColumn("COLUMN_TYPE", 0, true);
            IntegerColumn precision = new IntegerColumn("PRECISION", 0, true);
            IntegerColumn length = new IntegerColumn("LENGTH", 0, true);
            ShortIntegerColumn scale = new ShortIntegerColumn("SCALE", 0, true);
            ShortIntegerColumn radix = new ShortIntegerColumn("RADIX", 0, true);
            StringColumn specificName = new StringColumn("SPECIFIC_NAME", 0);
            ShortIntegerColumn functionType = new ShortIntegerColumn("FUNCTION_TYPE", 0, true);
            BooleanColumn nonUnique = new BooleanColumn("NON_UNIQUE", 0);
            StringColumn indexQualifier = new StringColumn("INDEX_QUALIFIER", 1);
            StringColumn indexName = new StringColumn("INDEX_NAME", 1);
            ShortIntegerColumn type = new ShortIntegerColumn("TYPE", 0, true);
            StringColumn ascOrDesc = new StringColumn("ASC_OR_DESC", 1);
            IntegerColumn cardinality = new IntegerColumn("CARDINALITY", 0, true);
            IntegerColumn pages = new IntegerColumn("PAGES", 0, true);
            StringColumn filterCondition = new StringColumn("FILTER_CONDITION", 1);
            StringColumn procedureCat = new StringColumn("PROCEDURE_CAT", 1);
            StringColumn procedureSchema = new StringColumn("PROCEDURE_SCHEM", 1);
            StringColumn procedureName = new StringColumn("PROCEDURE_NAME", 0);
            ShortIntegerColumn procedureType = new ShortIntegerColumn("PROCEDURE_TYPE", 0, true);
            StringColumn superTableName = new StringColumn("SUPERTABLE_NAME", 0);
            StringColumn superTypeCat = new StringColumn("SUPERTYPE_CAT", 1);
            StringColumn superTypeSchema = new StringColumn("SUPERTYPE_SCHEM", 1);
            StringColumn superTypeName = new StringColumn("SUPERTYPE_NAME", 0);
            StringColumn litPrefix = new StringColumn("LITERAL_PREFIX", 1);
            StringColumn litSuffix = new StringColumn("LITERAL_SUFFIX", 1);
            StringColumn createParams = new StringColumn("CREATE_PARAMS", 1);
            BooleanColumn caseSensitive = new BooleanColumn("CASE_SENSITIVE", 0);
            ShortIntegerColumn searchable = new ShortIntegerColumn("SEARCHABLE", 0, true);
            BooleanColumn unsignedAttr = new BooleanColumn("UNSIGNED_ATTRIBUTE", 0);
            BooleanColumn fixedPrecScale = new BooleanColumn("FIXED_PREC_SCALE", 0);
            BooleanColumn autoIncrement = new BooleanColumn("AUTO_INCREMENT", 0);
            StringColumn localTypeName = new StringColumn("LOCAL_TYPE_NAME", 1);
            ShortIntegerColumn minScale = new ShortIntegerColumn("MINIMUM_SCALE", 0, true);
            ShortIntegerColumn maxScale = new ShortIntegerColumn("MAXIMUM_SCALE", 1, true);
            StringColumn tableType = new StringColumn("TABLE_TYPE", 0);
            StringColumn selfRefColName = new StringColumn("SELF_REFERENCING_COL_NAME", 1);
            StringColumn refGeneration = new StringColumn("REF_GENERATION", 1);
            StringColumn columnUsage = new StringColumn("COLUMN_USAGE", 0);
            ATTRIBUTE_COLUMNS = new ColumnInfo[]{typeCat, typeSchema, typeName, attrName, dataType, attrTypeName, attrSize, decimalDigits, numPrecRadix, nullable, remarks, attrDef, sqlDataType, sqlDateTimeSub, charOctetLength, ordinalPosition, isNullable, scopeCatalog, scopeSchema, scopeTable, sourceDataType};
            BEST_ROW_IDENTIFIER_COLUMNS = new ColumnInfo[]{scope, columnName, dataType, typeName, columnSize, bufferLength, decimalDigits, psuedoColumn};
            CATALOG_COLUMNS = new ColumnInfo[]{tableCat};
            CLIENT_INFO_PROPERTY_COLUMNS = new ColumnInfo[]{name, maxLen, defaultValue, description};
            COLUMN_COLUMNS = new ColumnInfo[]{tableCat, tableSchema, tableName, columnName, dataType, typeName, columnSize, bufferLength, decimalDigits, numPrecRadix, nullable, remarks, columnDef, sqlDataType, sqlDateTimeSub, charOctetLength, ordinalPosition, isNullable, scopeCatalog, scopeSchema, scopeTable, sourceDataType, isAutoIncrement};
            COLUMN_PRIVILEGE_COLUMNS = new ColumnInfo[]{tableCat, tableSchema, tableName, columnName, grantor, grantee, privilege, isGrantable};
            CROSS_REFERENCE_COLUMNS = new ColumnInfo[]{pkTableCat, pkTableSchema, pkTableName, pkColumnName, fkTableCat, fkTableSchema, fkTableName, fkColumnName, keySeq, updateRule, deleteRule, fkName, pkName, deferrability};
            EXPORTED_KEY_COLUMNS = new ColumnInfo[]{pkTableCat, pkTableSchema, pkTableName, pkColumnName, fkTableCat, fkTableSchema, fkTableName, fkColumnName, keySeq, updateRule, deleteRule, fkName, pkName, deferrability};
            FUNCTION_COLUMN_COLUMNS = new ColumnInfo[]{functionCat, functionSchema, functionName, columnName, columnType, dataType, typeName, precision, length, scale, radix, shortNullable, remarks, charOctetLength, ordinalPosition, isNullable, specificName};
            FUNCTION_COLUMNS = new ColumnInfo[]{functionCat, functionSchema, functionName, remarks, functionType, specificName};
            IMPORTED_KEY_COLUMNS = new ColumnInfo[]{pkTableCat, pkTableSchema, pkTableName, pkColumnName, fkTableCat, fkTableSchema, fkTableName, fkColumnName, keySeq, updateRule, deleteRule, fkName, pkName, deferrability};
            INDEX_INFO_COLUMNS = new ColumnInfo[]{tableCat, tableSchema, tableName, nonUnique, indexQualifier, indexName, type, ordinalPosition, columnName, ascOrDesc, cardinality, pages, filterCondition};
            PRIMARY_KEY_COLUMNS = new ColumnInfo[]{tableCat, tableSchema, tableName, columnName, keySeq, pkName};
            PROCEDURE_COLUMN_COLUMNS = new ColumnInfo[]{procedureCat, procedureSchema, procedureName, columnName, columnType, dataType, typeName, precision, length, scale, radix, shortNullable, remarks, columnDef, sqlDataType, sqlDateTimeSub, charOctetLength, ordinalPosition, isNullable, specificName};
            PROCEDURE_COLUMNS = new ColumnInfo[]{procedureCat, procedureSchema, procedureName, empty, empty, empty, remarks, procedureType, specificName};
            PSUEDO_COLUMN_COLUMNS = new ColumnInfo[]{tableCat, tableSchema, tableName, columnName, dataType, columnSize, decimalDigits, numPrecRadix, columnUsage, remarks, charOctetLength, isNullable};
            SCHEMA_COLUMNS = new ColumnInfo[]{tableSchema, tableCatalog};
            SUPER_TABLE_COLUMNS = new ColumnInfo[]{tableCat, tableSchema, tableName, superTableName};
            SUPER_TYPE_COLUMNS = new ColumnInfo[]{typeCat, typeSchema, typeName, superTypeCat, superTypeSchema, superTypeName};
            TABLE_PRIVILEGE_COLUMNS = new ColumnInfo[]{tableCat, tableSchema, tableName, grantor, grantee, privilege, isGrantable};
            TABLE_TYPE_COLUMNS = new ColumnInfo[]{tableType};
            TABLE_COLUMNS = new ColumnInfo[]{tableCat, tableSchema, tableName, tableType, remarks, typeCat, typeSchema, typeName, selfRefColName, refGeneration};
            TYPE_INFO_COLUMNS = new ColumnInfo[]{typeName, dataType, precision, litPrefix, litSuffix, createParams, shortNullable, caseSensitive, searchable, unsignedAttr, fixedPrecScale, autoIncrement, localTypeName, minScale, maxScale, sqlDataType, sqlDateTimeSub, numPrecRadix};
            UDT_COLUMNS = new ColumnInfo[]{typeCat, typeSchema, typeName, className, dataType, remarks, baseType};
            VERSION_COLUMNS = new ColumnInfo[]{scope, columnName, dataType, typeName, columnSize, bufferLength, decimalDigits, psuedoColumn};
        }
        catch (SQLException e2) {
            throw new Error("Fatal error initializing JDBC metadata schema information");
        }
        init = true;
    }

    static {
        MetadataSchema.init();
    }
}

