/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.jdbc;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverPropertyInfo;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import org.apache.jena.atlas.lib.StrUtils;
import org.apache.jena.jdbc.JdbcCompatibility;
import org.apache.jena.jdbc.connections.JenaConnection;
import org.apache.jena.jdbc.postprocessing.ResultsPostProcessor;
import org.apache.jena.jdbc.preprocessing.CommandPreProcessor;
import org.apache.log4j.PropertyConfigurator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class JenaDriver
implements Driver {
    private static final Logger LOGGER = LoggerFactory.getLogger(JenaDriver.class);
    public static final String DRIVER_PREFIX = "jdbc:jena:";
    public static final String PARAM_JDBC_COMPATIBILITY = "jdbc-compatibility";
    public static final String PARAM_PRE_PROCESSOR = "pre-processor";
    public static final String PARAM_POST_PROCESSOR = "post-processor";
    public static final String PARAM_USERNAME = "user";
    public static final String PARAM_PASSWORD = "password";
    public static final String PARAM_LOGGING = "logging";
    public static final String NO_AUTO_LOGGING_CONFIGURATION = "no-auto";
    public static final String PARAM_CONFIG = "config";
    private int majorVer;
    private int minorVer;
    private String implPrefix;

    public JenaDriver(int majorVer, int minorVer, String prefix) {
        this.majorVer = majorVer;
        this.minorVer = minorVer;
        if (prefix == null) {
            throw new IllegalArgumentException("Implementation specific prefix cannot be null");
        }
        if (!prefix.endsWith(":")) {
            throw new IllegalArgumentException("Implementation specific prefix must end with a :");
        }
        if (!prefix.matches("[A-Za-z\\d\\-_]+:")) {
            throw new IllegalArgumentException("Implementation specific prefix must conform to the regular expression [A-Za-z\\d\\-_]+:");
        }
        this.implPrefix = prefix;
    }

    @Override
    public boolean acceptsURL(String url) {
        return url.startsWith(DRIVER_PREFIX + this.implPrefix);
    }

    @Override
    public final Connection connect(String url, Properties props) throws SQLException {
        if (!this.acceptsURL(url)) {
            return null;
        }
        Properties ps = this.getEffectiveProperties(url, props);
        this.modifyProperties(ps);
        String logConfig = ps.getProperty(PARAM_LOGGING);
        if (logConfig == null || logConfig.trim().length() == 0) {
            logConfig = NO_AUTO_LOGGING_CONFIGURATION;
        }
        if (!logConfig.equals(NO_AUTO_LOGGING_CONFIGURATION)) {
            File logConfigFile = new File(logConfig);
            if (logConfigFile.exists() && logConfigFile.isFile()) {
                PropertyConfigurator.configure(logConfig);
                LOGGER.info("Successfully configured logging using log file " + logConfigFile.getAbsolutePath());
            } else {
                URL logURL = this.getClass().getResource(logConfig);
                if (logURL != null) {
                    PropertyConfigurator.configure(logURL);
                    LOGGER.info("Successfully configured logging using class path resource " + logConfig);
                } else {
                    throw new SQLException("Unable to locate the specified log4j configuration file on either the file system or the class path");
                }
            }
        }
        int compatibilityLevel = JdbcCompatibility.parseLevel(ps.get(PARAM_JDBC_COMPATIBILITY));
        JenaConnection conn = null;
        boolean abort = false;
        try {
            conn = this.connect(ps, compatibilityLevel);
            Properties initProps = new Properties(ps);
            initProps.remove(PARAM_PASSWORD);
            Object ppObj = ps.get(PARAM_PRE_PROCESSOR);
            if (ppObj != null) {
                List preProcessors;
                if (ppObj instanceof String) {
                    preProcessors = new ArrayList<String>();
                    preProcessors.add(ppObj.toString());
                } else if (ppObj instanceof List) {
                    preProcessors = (List)ppObj;
                } else {
                    LOGGER.error("Driver Parameter pre-processor has unexpected invalid value");
                    throw new SQLException("Parameter pre-processor was set to a value of unexpected type " + ppObj.getClass().getCanonicalName() + ", expected either a String or List<String> as the parameter value");
                }
                for (String ppClassName : preProcessors) {
                    if (ppClassName == null) continue;
                    try {
                        LOGGER.info("Attempting to initialize pre-processor " + ppClassName);
                        Class<?> c = Class.forName(ppClassName);
                        Object i = c.newInstance();
                        if (i instanceof CommandPreProcessor) {
                            CommandPreProcessor pp = (CommandPreProcessor)i;
                            pp.initialize(initProps);
                            conn.addPreProcessor(pp);
                            LOGGER.info("Initialized pre-processor " + ppClassName + " successfully");
                            continue;
                        }
                        LOGGER.error("Invalid value for pre-processor parameter, references a class that exists but does not implement the required interface");
                        throw new SQLException("Parameter pre-processor includes the value " + ppClassName + " which references a class that does not implement the expected CommandPreProcessor interface, please ensure that the class name is corect and that the class implements the required interface");
                    }
                    catch (ClassNotFoundException e2) {
                        LOGGER.error("Invalid value for pre-processor parameter, references a class that did not exist", e2);
                        throw new SQLException("Parameter pre-processor includes the value " + ppClassName + " which references a class that could not be found, please ensure that the class name is correct and the JAR containing this class is on your class path", e2);
                    }
                    catch (InstantiationException e3) {
                        LOGGER.error("Invalid value for pre-processor parameter, references a class that exists but does not have an appropriate constructor", e3);
                        throw new SQLException("Parameter pre-processor includes the value " + ppClassName + " which references a class that could not be sucessfully instantiated, this class must have an unparameterized constructor to be usable with this parameter.  If this is not possible try calling addPreProcessor() on the returned JenaConnection instead", e3);
                    }
                    catch (IllegalAccessException e4) {
                        LOGGER.error("Invalid value for pre-processor parameter, references a class that exists but is inaccessible", e4);
                        throw new SQLException("Parameter pre-processor includes the value " + ppClassName + " which references a class that could not be sucessfully instantiated, this class must have a publicly accessible unparameterized constructor to be usable with this parameter.  If this is not possible try calling addPreProcessor() on the returned JenaConnection instead", e4);
                    }
                    catch (SQLException e5) {
                        throw e5;
                    }
                    catch (Exception e6) {
                        LOGGER.error("Invalid value for pre-processor parameter, references a class that attempting to initialize produced an unexpected exception", e6);
                        throw new SQLException("Parameter pre-processor includes the value " + ppClassName + " which caused an unexpected exception when trying to instantiate it, see the inner exception for details", e6);
                    }
                }
            }
            if ((ppObj = ps.get(PARAM_POST_PROCESSOR)) != null) {
                List postProcessors;
                if (ppObj instanceof String) {
                    postProcessors = new ArrayList<String>();
                    postProcessors.add(ppObj.toString());
                } else if (ppObj instanceof List) {
                    postProcessors = (List)ppObj;
                } else {
                    LOGGER.error("Driver Parameter post-processor has unexpected invalid value");
                    throw new SQLException("Parameter post-processor was set to a value of unexpected type " + ppObj.getClass().getCanonicalName() + ", expected either a String or List<String> as the parameter value");
                }
                for (String ppClassName : postProcessors) {
                    if (ppClassName == null) continue;
                    try {
                        LOGGER.info("Attempting to initialize post-processor " + ppClassName);
                        Class<?> c = Class.forName(ppClassName);
                        Object i = c.newInstance();
                        if (i instanceof ResultsPostProcessor) {
                            ResultsPostProcessor pp = (ResultsPostProcessor)i;
                            pp.initialize(initProps);
                            conn.addPostProcessor(pp);
                            LOGGER.info("Initialized post-processor " + ppClassName + " successfully");
                            continue;
                        }
                        LOGGER.error("Invalid value for post-processor parameter, references a class that exists but does not implement the required interface");
                        throw new SQLException("Parameter post-processor includes the value " + ppClassName + " which references a class that does not implement the expected ResultsPostProcessor interface, please ensure that the class name is corect and that the class implements the required interface");
                    }
                    catch (ClassNotFoundException e7) {
                        LOGGER.error("Invalid value for post-processor parameter, references a class that did not exist", e7);
                        throw new SQLException("Parameter post-processor includes the value " + ppClassName + " which references a class that could not be found, please ensure that the class name is correct and the JAR containing this class is on your class path", e7);
                    }
                    catch (InstantiationException e8) {
                        LOGGER.error("Invalid value for post-processor parameter, references a class that exists but does not have an appropriate constructor", e8);
                        throw new SQLException("Parameter post-processor includes the value " + ppClassName + " which references a class that could not be sucessfully instantiated, this class must have an unparameterized constructor to be usable with this parameter.  If this is not possible try calling addPostProcessor() on the returned JenaConnection instead", e8);
                    }
                    catch (IllegalAccessException e9) {
                        LOGGER.error("Invalid value for post-processor parameter, references a class that exists but is inaccessible", e9);
                        throw new SQLException("Parameter post-processor includes the value " + ppClassName + " which references a class that could not be sucessfully instantiated, this class must have a publicly accessible unparameterized constructor to be usable with this parameter.  If this is not possible try calling addPostProcessor() on the returned JenaConnection instead", e9);
                    }
                    catch (SQLException e10) {
                        throw e10;
                    }
                    catch (Exception e11) {
                        LOGGER.error("Invalid value for post-processor parameter, references a class that attempting to initialize produced an unexpected exception", e11);
                        throw new SQLException("Parameter post-processor includes the value " + ppClassName + " which caused an unexpected exception when trying to instantiate it, see the inner exception for details", e11);
                    }
                }
            }
            JenaConnection jenaConnection = conn;
            return jenaConnection;
        }
        catch (SQLException e12) {
            abort = true;
            throw e12;
        }
        catch (Exception e13) {
            abort = true;
            LOGGER.error("Unexpected exception while establishing a connection", e13);
            throw new SQLException("Unexpected exception while establishing a connection, see inner exception for details", e13);
        }
        finally {
            if (abort && conn != null) {
                conn.close();
            }
        }
    }

    private Properties getEffectiveProperties(String url, Properties props) throws SQLException {
        Properties external;
        String[] kvps;
        Properties ps = new Properties();
        url = url.substring(DRIVER_PREFIX.length() + this.implPrefix.length());
        for (String kvp : kvps = url.split("&|;")) {
            String[] vs;
            String value;
            String key;
            if (kvp.length() == 0) continue;
            if (kvp.contains("=")) {
                String[] temp = kvp.split("=", 2);
                key = temp[0];
                value = temp[1];
            } else {
                key = kvp;
                value = null;
            }
            key = key.toLowerCase(Locale.ENGLISH);
            if (!ps.containsKey(key)) {
                if (this.allowsMultipleValues(key)) {
                    ArrayList<String> values = new ArrayList<String>();
                    if (value.contains(",")) {
                        for (String v : vs = value.split(",")) {
                            values.add(v);
                        }
                    } else {
                        values.add(value);
                    }
                    ps.put(key, values);
                    continue;
                }
                ps.put(key, value);
                continue;
            }
            if (this.allowsMultipleValues(key)) {
                Object currValue = ps.get(key);
                if (currValue instanceof List) {
                    if (value.contains(",")) {
                        for (String v : vs = value.split(",")) {
                            ((List)currValue).add(v);
                        }
                        continue;
                    }
                    ((List)currValue).add(value);
                    continue;
                }
                ArrayList<String> values = new ArrayList<String>();
                values.add(currValue.toString());
                if (value.contains(",")) {
                    String[] vs2;
                    for (String v : vs2 = value.split(",")) {
                        values.add(v);
                    }
                } else {
                    values.add(value);
                }
                ps.put(key, values);
                continue;
            }
            LOGGER.warn("Cannot specify parameter " + key + " multiple times in the connection URL");
            throw new SQLException("Invalid connection URL parameter " + kvp + " encountered, the parameter " + key + " may only be specified once");
        }
        if (props != null && props.containsKey(PARAM_CONFIG)) {
            external = this.loadProperties(props.getProperty(PARAM_CONFIG));
            LOGGER.info("Merging in external properties file " + props.getProperty(PARAM_CONFIG));
            this.mergeProperties(external, ps, false);
        } else if (ps.containsKey(PARAM_CONFIG)) {
            external = this.loadProperties(ps.getProperty(PARAM_CONFIG));
            LOGGER.info("Merging in external properties file " + ps.getProperty(PARAM_CONFIG));
            this.mergeProperties(external, ps, false);
        }
        if (props != null) {
            this.mergeProperties(props, ps, true);
        }
        return ps;
    }

    private void mergeProperties(Properties source, Properties target, boolean overwriteOrAppendIfExists) {
        for (Map.Entry<Object, Object> e2 : source.entrySet()) {
            String key = e2.getKey().toString().toLowerCase(Locale.ENGLISH);
            Object value = e2.getValue();
            if (target.containsKey(key)) {
                if (!overwriteOrAppendIfExists) continue;
                if (this.allowsMultipleValues(key)) {
                    Object currValue = target.get(key);
                    if (currValue instanceof List) {
                        ((List)currValue).add(value);
                        continue;
                    }
                    ArrayList<String> values = new ArrayList<String>();
                    values.add(currValue.toString());
                    values.add(value.toString());
                    target.put(key, values);
                    continue;
                }
                target.put(key, value);
                continue;
            }
            target.put(key, value);
        }
    }

    private Properties loadProperties(String resource) throws SQLException {
        Properties ps = new Properties();
        File propFile = new File(resource);
        if (propFile.exists() && propFile.isFile()) {
            try {
                FileInputStream input = new FileInputStream(propFile);
                ps.load(input);
                input.close();
            }
            catch (FileNotFoundException e2) {
                throw new SQLException("Located external properties file " + propFile.getAbsolutePath() + " on file system but it was removed before it could be read", e2);
            }
            catch (IOException e3) {
                throw new SQLException("IO Error attempting to load external properties file " + propFile.getAbsolutePath());
            }
            LOGGER.info("Successfully loaded external properties file " + propFile.getAbsolutePath());
        } else {
            URL propURL = this.getClass().getResource(resource);
            if (propURL != null) {
                try {
                    InputStream input = propURL.openStream();
                    ps.load(input);
                    input.close();
                }
                catch (IOException e4) {
                    throw new SQLException("IO Error attempting to load class path properties file from resource " + resource, e4);
                }
                LOGGER.info("Successfully loaded class path properties file from resource " + resource);
            } else {
                throw new SQLException("Unable to locate the specified external properties file on either the file system or the class path");
            }
        }
        for (Map.Entry<Object, Object> e5 : ps.entrySet()) {
            Object currValue;
            String key = e5.getKey().toString().toLowerCase(Locale.ENGLISH);
            if (!this.allowsMultipleValues(key) || !((currValue = e5.getValue()) instanceof String) || !currValue.toString().contains(",")) continue;
            String[] values = currValue.toString().split(",");
            ps.put(e5.getKey(), Arrays.asList(values));
        }
        return ps;
    }

    protected void modifyProperties(Properties props) {
    }

    protected boolean allowsMultipleValues(String key) {
        return PARAM_PRE_PROCESSOR.equals(key) || PARAM_POST_PROCESSOR.equals(key);
    }

    protected abstract JenaConnection connect(Properties var1, int var2) throws SQLException;

    @Override
    public int getMajorVersion() {
        return this.minorVer;
    }

    @Override
    public int getMinorVersion() {
        return this.majorVer;
    }

    @Override
    public final DriverPropertyInfo[] getPropertyInfo(String url, Properties props) throws SQLException {
        Properties ps = this.getEffectiveProperties(url, props);
        ArrayList<DriverPropertyInfo> baseProps = new ArrayList<DriverPropertyInfo>();
        DriverPropertyInfo jdbcCompatLevel = new DriverPropertyInfo(PARAM_JDBC_COMPATIBILITY, ps.getProperty(PARAM_JDBC_COMPATIBILITY, Integer.toString(5)));
        jdbcCompatLevel.description = "Configures how compatible the driver will attempt to be with JDBC, primarily affects reported column types for result sets";
        jdbcCompatLevel.required = false;
        String[] choices = new String[9];
        for (int i = 0; i < choices.length; ++i) {
            choices[i] = Integer.toString(i + 1);
        }
        jdbcCompatLevel.choices = choices;
        baseProps.add(jdbcCompatLevel);
        DriverPropertyInfo preProcessor = new DriverPropertyInfo(PARAM_PRE_PROCESSOR, StrUtils.strjoin(",", this.getValues(ps, PARAM_PRE_PROCESSOR)));
        preProcessor.description = "Configures pre-processors which are used to amend SPARQL text, queries or updates before these are passed to the underlying SPARQL engine, multiple fully qualified class names may be specified";
        preProcessor.required = false;
        baseProps.add(preProcessor);
        DriverPropertyInfo logging = new DriverPropertyInfo(PARAM_LOGGING, ps.getProperty(PARAM_LOGGING));
        logging.description = "Sets the path to a log4j properties file for configuring logging, the file system is considered first and then the classpath.  If not set defaults to log4j.properties";
        logging.required = false;
        baseProps.add(logging);
        return this.getPropertyInfo(ps, baseProps);
    }

    protected final void copyBaseProperties(DriverPropertyInfo[] finalProps, List<DriverPropertyInfo> baseProps, int start) {
        int i = start;
        for (int j = 0; i < finalProps.length && j < baseProps.size(); ++i, ++j) {
            finalProps[i] = baseProps.get(j);
        }
    }

    protected abstract DriverPropertyInfo[] getPropertyInfo(Properties var1, List<DriverPropertyInfo> var2);

    @Override
    public final boolean jdbcCompliant() {
        return false;
    }

    protected List<String> getValues(Properties props, String key) throws SQLException {
        Object obj = props.get(key);
        if (obj == null) {
            return new ArrayList<String>();
        }
        if (obj instanceof List) {
            return (List)obj;
        }
        if (obj instanceof String) {
            ArrayList<String> values = new ArrayList<String>();
            values.add(obj.toString());
            return values;
        }
        throw new SQLException("Value given for parameter " + key + " was not a string/list of strings");
    }

    protected boolean isTrue(Properties props, String key) {
        Object obj = props.get(key);
        if (obj == null) {
            return false;
        }
        String value = obj.toString().toLowerCase(Locale.ENGLISH).trim();
        return "true".equals(value);
    }

    protected boolean getBoolean(Properties props, String key, boolean defaultValue) {
        Object obj = props.get(key);
        if (obj == null) {
            return defaultValue;
        }
        String value = obj.toString().toLowerCase(Locale.ENGLISH).trim();
        if ("true".equals(value)) {
            return true;
        }
        if ("false".equals(value)) {
            return false;
        }
        return defaultValue;
    }

    protected boolean isSetToValue(Properties props, String key, String value) {
        Object obj = props.get(key);
        if (obj == null) {
            return value == null;
        }
        if (value == null) {
            return false;
        }
        String actualValue = obj.toString().trim().toLowerCase(Locale.ENGLISH);
        return value.equals(actualValue);
    }

    @Override
    public java.util.logging.Logger getParentLogger() throws SQLFeatureNotSupportedException {
        throw new SQLFeatureNotSupportedException();
    }
}

