/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.atlas.lib.tuple;

import java.util.Iterator;
import java.util.List;
import java.util.function.Consumer;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.apache.jena.atlas.lib.ArrayUtils;
import org.apache.jena.atlas.lib.tuple.TupleList;

public interface Tuple<X>
extends Iterable<X> {
    public X get(int var1);

    public int len();

    default public List<X> asList() {
        return new TupleList(this);
    }

    default public Stream<X> stream() {
        return StreamSupport.stream(this.spliterator(), false);
    }

    @Override
    default public void forEach(Consumer<? super X> action) {
        this.asList().forEach(action);
    }

    @Override
    default public Iterator<X> iterator() {
        return this.asList().iterator();
    }

    default public void copyInto(X[] array) {
        this.copyInto(array, 0, this.len());
    }

    default public void copyInto(X[] array, int start) {
        this.copyInto(array, start, this.len());
    }

    default public void copyInto(X[] array, int start, int length) {
        for (int i = 0; i < Math.min(length, this.len()); ++i) {
            array[i + start] = this.get(i);
        }
    }

    default public X[] asArray(Class<X> cls) {
        X[] elts = ArrayUtils.alloc(cls, this.len());
        for (int i = 0; i < this.len(); ++i) {
            elts[i] = this.get(i);
        }
        return elts;
    }
}

