/*
 * Decompiled with CFR 0.152.
 */
package com.github.jsonldjava.utils;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.github.jsonldjava.utils.JarCacheResource;
import java.io.IOException;
import java.lang.ref.SoftReference;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.http.Header;
import org.apache.http.HttpVersion;
import org.apache.http.client.cache.HttpCacheEntry;
import org.apache.http.client.cache.HttpCacheStorage;
import org.apache.http.client.cache.HttpCacheUpdateCallback;
import org.apache.http.client.cache.HttpCacheUpdateException;
import org.apache.http.impl.client.cache.CacheConfig;
import org.apache.http.impl.cookie.DateUtils;
import org.apache.http.message.BasicHeader;
import org.apache.http.message.BasicStatusLine;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JarCacheStorage
implements HttpCacheStorage {
    private static final String JARCACHE_JSON = "jarcache.json";
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final CacheConfig cacheConfig = new CacheConfig();
    private ClassLoader classLoader;
    ObjectMapper mapper = new ObjectMapper();
    protected ConcurrentMap<URI, SoftReference<JsonNode>> jarCaches = new ConcurrentHashMap<URI, SoftReference<JsonNode>>();

    public ClassLoader getClassLoader() {
        if (this.classLoader != null) {
            return this.classLoader;
        }
        return Thread.currentThread().getContextClassLoader();
    }

    public void setClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    public JarCacheStorage() {
        this(null);
    }

    public JarCacheStorage(ClassLoader classLoader) {
        this.setClassLoader(classLoader);
        this.cacheConfig.setMaxObjectSize(0L);
        this.cacheConfig.setMaxCacheEntries(0);
        this.cacheConfig.setMaxUpdateRetries(0);
        this.cacheConfig.getMaxCacheEntries();
    }

    @Override
    public void putEntry(String key, HttpCacheEntry entry) throws IOException {
    }

    @Override
    public HttpCacheEntry getEntry(String key) throws IOException {
        URI requestedUri;
        this.log.trace("Requesting " + key);
        try {
            requestedUri = new URI(key);
        }
        catch (URISyntaxException e2) {
            return null;
        }
        if (requestedUri.getScheme().equals("http") && requestedUri.getPort() == 80 || requestedUri.getScheme().equals("https") && requestedUri.getPort() == 443) {
            try {
                requestedUri = new URI(requestedUri.getScheme(), requestedUri.getHost(), requestedUri.getPath(), requestedUri.getFragment());
            }
            catch (URISyntaxException e2) {
                // empty catch block
            }
        }
        Enumeration<URL> jarcaches = this.getResources();
        while (jarcaches.hasMoreElements()) {
            URL url = jarcaches.nextElement();
            JsonNode tree = this.getJarCache(url);
            for (JsonNode node : tree) {
                URI uri = URI.create(node.get("Content-Location").asText());
                if (!uri.equals(requestedUri)) continue;
                return this.cacheEntry(requestedUri, url, node);
            }
        }
        return null;
    }

    private Enumeration<URL> getResources() throws IOException {
        ClassLoader cl = this.getClassLoader();
        if (cl != null) {
            return cl.getResources(JARCACHE_JSON);
        }
        return ClassLoader.getSystemResources(JARCACHE_JSON);
    }

    protected JsonNode getJarCache(URL url) throws IOException, JsonProcessingException {
        JsonNode tree;
        SoftReference<JsonNode> putIfAbsent;
        URI uri;
        try {
            uri = url.toURI();
        }
        catch (URISyntaxException e2) {
            throw new IllegalArgumentException("Invalid jarCache URI " + url, e2);
        }
        SoftReference jarCacheRef = (SoftReference)this.jarCaches.get(uri);
        if (jarCacheRef != null) {
            JsonNode jarCache = (JsonNode)jarCacheRef.get();
            if (jarCache != null) {
                return jarCache;
            }
            this.jarCaches.remove(uri);
        }
        if ((putIfAbsent = this.jarCaches.putIfAbsent(uri, new SoftReference<JsonNode>(tree = this.mapper.readTree(url)))) != null) {
            JsonNode returnValue = putIfAbsent.get();
            if (returnValue != null) {
                return returnValue;
            }
            this.jarCaches.put(uri, new SoftReference<JsonNode>(tree));
        }
        return tree;
    }

    protected HttpCacheEntry cacheEntry(URI requestedUri, URL baseURL, JsonNode cacheNode) throws MalformedURLException, IOException {
        URL classpath = new URL(baseURL, cacheNode.get("X-Classpath").asText());
        this.log.debug("Cache hit for " + requestedUri);
        this.log.trace("{}", (Object)cacheNode);
        ArrayList<BasicHeader> responseHeaders = new ArrayList<BasicHeader>();
        if (!cacheNode.has("Date")) {
            responseHeaders.add(new BasicHeader("Date", DateUtils.formatDate(new Date())));
        }
        if (!cacheNode.has("Cache-Control")) {
            responseHeaders.add(new BasicHeader("Cache-Control", "max-age=2147483647"));
        }
        JarCacheResource resource = new JarCacheResource(classpath);
        Iterator<String> fieldNames = cacheNode.fieldNames();
        while (fieldNames.hasNext()) {
            String headerName = fieldNames.next();
            JsonNode header = cacheNode.get(headerName);
            responseHeaders.add(new BasicHeader(headerName, header.asText()));
        }
        return new HttpCacheEntry(new Date(), new Date(), new BasicStatusLine(HttpVersion.HTTP_1_1, 200, "OK"), responseHeaders.toArray(new Header[0]), resource);
    }

    @Override
    public void removeEntry(String key) throws IOException {
    }

    @Override
    public void updateEntry(String key, HttpCacheUpdateCallback callback) throws IOException, HttpCacheUpdateException {
    }

    public CacheConfig getCacheConfig() {
        return this.cacheConfig;
    }
}

