/*
 * Decompiled with CFR 0.152.
 */
package convex.core.crypto.sodium;

import convex.core.crypto.AKeyPair;
import convex.core.crypto.ASignature;
import convex.core.crypto.Ed25519Signature;
import convex.core.crypto.sodium.SodiumProvider;
import convex.core.data.AArrayBlob;
import convex.core.data.ACell;
import convex.core.data.AccountKey;
import convex.core.data.Blob;
import convex.core.data.Blobs;
import convex.core.data.SignedData;
import convex.core.util.Utils;

public class SodiumKeyPair
extends AKeyPair {
    private static final int SECRET_LENGTH = 64;
    private final AccountKey publicKey;
    private final Blob seed;
    private final byte[] secretKeyBytes;

    private SodiumKeyPair(AccountKey pk, Blob seed, byte[] skBytes) {
        this.publicKey = pk;
        this.seed = seed;
        this.secretKeyBytes = skBytes;
    }

    public static SodiumKeyPair create(Blob seed) {
        long n = seed.count();
        if (seed.count() != 32L) {
            throw new IllegalArgumentException("32 bytes private key material expected as seed but got: " + n);
        }
        byte[] secretKeyBytes = new byte[64];
        byte[] pkBytes = new byte[32];
        SodiumProvider.SODIUM_SIGN.cryptoSignSeedKeypair(pkBytes, secretKeyBytes, seed.getBytes());
        AccountKey publicKey = AccountKey.wrap((byte[])pkBytes);
        return new SodiumKeyPair(publicKey, seed, secretKeyBytes);
    }

    public Blob getSeed() {
        return this.seed;
    }

    public AccountKey getAccountKey() {
        return this.publicKey;
    }

    public <R extends ACell> SignedData<R> signData(R value) {
        return SignedData.sign((AKeyPair)this, value);
    }

    public ASignature sign(AArrayBlob hash) {
        int mlength = Utils.checkedInt((long)hash.count());
        byte[] signature = new byte[64];
        if (SodiumProvider.SODIUM_SIGN.cryptoSignDetached(signature, Blobs.ensureZeroBasedArray((AArrayBlob)hash), (long)mlength, this.secretKeyBytes)) {
            return Ed25519Signature.wrap((byte[])signature);
        }
        throw new Error("Signing failed!");
    }

    public boolean equals(AKeyPair kp) {
        if (!(kp instanceof SodiumKeyPair)) {
            return false;
        }
        return this.equals((SodiumKeyPair)kp);
    }

    public boolean equals(SodiumKeyPair other) {
        if (!this.seed.equals((AArrayBlob)other.seed)) {
            return false;
        }
        return this.publicKey.equals(other.publicKey);
    }
}

