/*
 * Decompiled with CFR 0.152.
 */
package convex.core.crypto.sodium;

import com.goterl.lazysodium.LazySodiumJava;
import com.goterl.lazysodium.SodiumJava;
import com.goterl.lazysodium.interfaces.Sign;
import convex.core.crypto.AProvider;
import convex.core.crypto.ASignature;
import convex.core.crypto.Providers;
import convex.core.crypto.sodium.SodiumKeyPair;
import convex.core.data.AArrayBlob;
import convex.core.data.AccountKey;
import convex.core.data.Blob;

public class SodiumProvider
extends AProvider {
    public static long verificationCount = 0L;
    private static final SodiumJava NATIVE_SODIUM = new SodiumJava();
    public static final LazySodiumJava SODIUM = new LazySodiumJava(NATIVE_SODIUM);
    public static final Sign.Native SODIUM_SIGN = SODIUM;

    public SodiumProvider() {
        super("Convex-Sodium", "1.0", "Native Sodium integration for Convex");
    }

    public boolean verify(ASignature signature, AArrayBlob message, AccountKey publicKey) {
        byte[] sigBytes = signature.getBytes();
        int mlength = (int)message.count();
        byte[] msgBytes = message.getInternalOffset() == 0 ? message.getInternalArray() : message.getBytes();
        boolean verified = SODIUM_SIGN.cryptoSignVerifyDetached(sigBytes, msgBytes, mlength, publicKey.getBytes());
        ++verificationCount;
        return verified;
    }

    public SodiumKeyPair create(Blob seed) {
        return SodiumKeyPair.create(seed);
    }

    public static void install() {
        Providers.setProvider((AProvider)new SodiumProvider());
    }
}

