/*
 * Decompiled with CFR 0.152.
 */
package convex.restapi.web;

import convex.core.cvm.Address;
import convex.core.data.AArrayBlob;
import convex.core.data.ABlob;
import convex.core.data.ACell;
import convex.core.lang.RT;
import convex.core.util.Utils;
import convex.restapi.RESTServer;
import convex.restapi.api.ABaseAPI;
import io.javalin.http.Context;
import j2html.TagCreator;
import j2html.tags.DomContent;
import j2html.tags.Text;
import j2html.tags.specialized.ButtonTag;
import j2html.tags.specialized.CodeTag;
import j2html.tags.specialized.FormTag;
import j2html.tags.specialized.HtmlTag;
import j2html.tags.specialized.ImgTag;
import j2html.tags.specialized.InputTag;
import j2html.tags.specialized.LiTag;
import j2html.tags.specialized.LinkTag;
import j2html.tags.specialized.PreTag;
import j2html.tags.specialized.ScriptTag;
import j2html.tags.specialized.TdTag;
import java.time.Instant;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.util.Arrays;

public abstract class AWebSite
extends ABaseAPI {
    private static final DateTimeFormatter TS_FMT = DateTimeFormatter.ofPattern("uuuu-MM-dd HH:mm:ss.SSS").withZone(ZoneOffset.UTC);

    public AWebSite(RESTServer restServer) {
        super(restServer);
    }

    public void returnPage(Context ctx, String title, DomContent ... content) {
        this.returnPage(ctx, title, (String[][])null, content);
    }

    public void returnPage(Context ctx, String title, String[][] breadcrumbs, DomContent ... content) {
        HtmlTag result = TagCreator.html((DomContent[])new DomContent[]{this.makeHeader(title), TagCreator.body((DomContent[])new DomContent[]{this.topBar(breadcrumbs), this.contentBlock(content), this.footerBlock()}).withStyle("min-height: 100vh; display: flex; flex-direction: column;")});
        ctx.result(result.render());
        ctx.contentType("text/html");
    }

    public DomContent topBar(String[][] breadcrumbs) {
        return TagCreator.header((DomContent[])new DomContent[]{TagCreator.div((DomContent[])new DomContent[]{TagCreator.div((DomContent[])new DomContent[]{TagCreator.a((DomContent[])new DomContent[]{((ImgTag)((ImgTag)TagCreator.img().withSrc("/Convex.png")).withAlt("Convex")).withStyle("width: 2.5em; height: 2.5em; margin: 0.5em;")}).withHref("/")}), TagCreator.h1((String)"Convex").withStyle("height: 40px; margin-bottom: 0.2em;"), TagCreator.div().withStyle("flex-grow: 1;"), TagCreator.nav((DomContent[])new DomContent[]{this.topButton("Explorer", "/explorer/"), this.topButton("Peers", "/explorer/peers"), this.topButton("REPL", "/explorer/repl"), this.topButton("API", "/swagger"), TagCreator.div((DomContent[])new DomContent[]{TagCreator.label((DomContent[])new DomContent[]{((InputTag)((InputTag)((InputTag)TagCreator.input().withType("checkbox")).withId("theme-toggle")).attr("role", (Object)"switch")).attr("onchange", (Object)"toggleTheme()")}).withClass("theme-toggle")}), TagCreator.div()}).withStyle("display: flex; gap: 0.5em; align-items: center;")}).withStyle("display: flex; align-items: center; gap: 0.5em"), this.breadcrumb(breadcrumbs)});
    }

    private DomContent topButton(String text, String link) {
        return TagCreator.a((DomContent[])new DomContent[]{TagCreator.button((String)text).withStyle("padding:.25em .6em;")}).withHref(link);
    }

    public DomContent contentBlock(DomContent ... content) {
        return TagCreator.main((DomContent[])content).withStyle("padding: 1em; flex-grow: 1;");
    }

    public DomContent footerBlock() {
        return TagCreator.footer((DomContent[])new DomContent[]{TagCreator.hr(), TagCreator.div((DomContent[])new DomContent[]{TagCreator.div((DomContent[])new DomContent[]{TagCreator.h4((String)"Useful Links"), TagCreator.div((DomContent[])new DomContent[]{TagCreator.a((String)"convex.world").withHref("https://convex.world")}), TagCreator.div((DomContent[])new DomContent[]{TagCreator.a((String)"Explorer").withHref("/explorer/")}), TagCreator.div((DomContent[])new DomContent[]{TagCreator.a((String)"Blocks").withHref("/explorer/blocks")}), TagCreator.div((DomContent[])new DomContent[]{TagCreator.a((String)"States").withHref("/explorer/states")})}), TagCreator.div((DomContent[])new DomContent[]{TagCreator.h4((String)"Resources"), TagCreator.div((DomContent[])new DomContent[]{TagCreator.a((String)"Documentation").withHref("https://docs.convex.world")}), TagCreator.div((DomContent[])new DomContent[]{TagCreator.a((String)"GitHub - Convex Developers").withHref("https://github.com/Convex-Dev/convex")}), TagCreator.div((DomContent[])new DomContent[]{TagCreator.a((String)"Discord Community").withHref("https://discord.gg/convex")})})}).withStyle("display: flex; justify-content: space-around; padding: 0")});
    }

    DomContent showAddress(Address origin) {
        if (origin == null) {
            return TagCreator.text((String)"nil");
        }
        return TagCreator.a((String)origin.toString()).withHref("/explorer/accounts/" + origin.longValue());
    }

    protected DomContent makeButton(String text, String href) {
        return this.makeButton(text, href, true);
    }

    protected DomContent makeButton(String text, String href, boolean enabled) {
        if (enabled && href != null) {
            return TagCreator.a((DomContent[])new DomContent[]{((ButtonTag)TagCreator.button((String)text).withClass("secondary")).withStyle("padding:.25em .6em;font-size:.8em;margin-right:.25em;")}).withHref(href);
        }
        return ((ButtonTag)((ButtonTag)TagCreator.button((String)text).attr("disabled")).withClass("secondary")).withStyle("padding:.25em .6em;font-size:.8em;margin-right:.25em;");
    }

    protected DomContent makeHeader(String title) {
        return TagCreator.head((DomContent[])new DomContent[]{TagCreator.title((String)title), ((LinkTag)TagCreator.link().withRel("stylesheet")).withHref("/css/pico.min.css"), ((LinkTag)TagCreator.link().withRel("stylesheet")).withHref("/css/custom.css"), TagCreator.style((String)":root {--pico-spacing: 0.6em}"), ((ScriptTag)TagCreator.script().withSrc("/js/explorer.js")).withType("text/javascript")});
    }

    protected DomContent makePaginationLinks(Context ctx, String basePath, long offset, long limit, long total) {
        long end = Math.min(total, offset + limit);
        if (total <= 0L) {
            return TagCreator.div();
        }
        String firstLink = basePath + "?offset=0&limit=" + limit;
        long prevOffset = Math.max(0L, offset - limit);
        String prevLink = basePath + "?offset=" + prevOffset + "&limit=" + limit;
        boolean hasPrev = offset > 0L;
        String nextLink = basePath + "?offset=" + end + "&limit=" + limit;
        long lastOffset = Math.max(0L, total - limit);
        String lastLink = basePath + "?offset=" + lastOffset + "&limit=" + limit;
        boolean hasNext = end < total;
        return TagCreator.div((DomContent[])new DomContent[]{this.makeButton("<<", firstLink, hasPrev), this.makeButton("<", prevLink, hasPrev), this.makeButton(">", nextLink, hasNext), this.makeButton(">>", lastLink, hasNext), this.makePaginationInfo(offset, limit, total)});
    }

    protected DomContent row(Object ... values) {
        int n = values.length;
        DomContent[] tds = new DomContent[n];
        for (int i = 0; i < n; ++i) {
            Text cell;
            Object v = values[i];
            if (v instanceof String) {
                String s = (String)v;
                cell = TagCreator.text((String)s);
            } else if (v instanceof DomContent) {
                DomContent dc = (DomContent)v;
                cell = dc;
            } else {
                throw new IllegalArgumentException("Can make table cell from " + Utils.getClassName((Object)v));
            }
            if (!(cell instanceof TdTag)) {
                cell = TagCreator.td((DomContent[])new DomContent[]{cell});
            }
            tds[i] = cell;
        }
        return TagCreator.tr((DomContent[])tds);
    }

    protected DomContent makePaginationInfo(long offset, long limit, long total) {
        long end = Math.min(total, offset + limit);
        return TagCreator.small((String)((String)(offset > 0L ? offset + 1L + "-" : "") + end + " / " + total));
    }

    protected DomContent makeNavigationLinks(String basePath, long index, long total, String label) {
        if (total <= 0L) {
            return TagCreator.div();
        }
        String prevLink = basePath + "/" + (index - 1L);
        String nextLink = basePath + "/" + (index + 1L);
        boolean hasPrev = index > 0L;
        boolean hasNext = index < total - 1L;
        return TagCreator.div((DomContent[])new DomContent[]{this.makeButton("<", prevLink, hasPrev), this.makeButton(">", nextLink, hasNext), TagCreator.small((String)(label + " " + (index + 1L) + " / " + total))});
    }

    protected DomContent showBalance(long bal) {
        String s = convex.core.text.Text.toFriendlyNumber((long)(bal / 1000000000L));
        s = convex.core.text.Text.leftPad((String)s, (int)13);
        return AWebSite.preCode(new DomContent[]{TagCreator.span((DomContent[])new DomContent[]{TagCreator.rawHtml((String)s)}).withClass("cvm-balance"), TagCreator.small((String)("." + String.format("%09d", bal % 1000000000L)))});
    }

    protected static PreTag preCode(String s) {
        return (PreTag)TagCreator.pre((DomContent[])new DomContent[]{TagCreator.code((String)s)}).withStyle("width:min-content; margin:0;");
    }

    protected static PreTag preCode(DomContent ... content) {
        return (PreTag)TagCreator.pre((DomContent[])new DomContent[]{TagCreator.code((DomContent[])content)}).withStyle("width:min-content;  margin:0;");
    }

    protected DomContent timestamp(long ts) {
        String s = TS_FMT.format(Instant.ofEpochMilli(ts));
        String fs = " (" + ts + ")";
        return AWebSite.preCode(new DomContent[]{TagCreator.text((String)s), TagCreator.small((String)fs)});
    }

    protected CodeTag showCVX(ACell trans) {
        return AWebSite.wrappedCode(RT.print((ACell)trans).toString());
    }

    protected String getVersion() {
        try {
            return Utils.getVersion();
        }
        catch (Exception e) {
            return "Unknown";
        }
    }

    protected DomContent breadcrumb(String[][] items) {
        if (items == null) {
            return TagCreator.div();
        }
        return TagCreator.nav((DomContent[])new DomContent[]{TagCreator.ul((DomContent[])new DomContent[]{TagCreator.each(Arrays.asList(items), it -> {
            String label = it[0];
            String href = ((String[])it).length > 1 ? it[1] : null;
            LiTag li = href == null ? TagCreator.li((DomContent[])new DomContent[]{TagCreator.text((String)label)}) : TagCreator.li((DomContent[])new DomContent[]{TagCreator.a((String)label).withHref(href)});
            return li.withStyle("padding:0 0 0 0.95em;");
        })}).withStyle("margin-left: 0.5em")}).attr("aria-label", (Object)"breadcrumb");
    }

    protected static String[] sa(String ... strings) {
        return strings;
    }

    public static DomContent showID(AArrayBlob data) {
        return AWebSite.showID(data, 16);
    }

    public static DomContent showID(AArrayBlob data, int length) {
        return TagCreator.div((DomContent[])new DomContent[]{AWebSite.identicon((ABlob)data), AWebSite.showHex(data, length)}).withStyle("display: flex; flex-direction: row; align-items: center; gap: 0.5em; max-width: 100%; min-width: 0;");
    }

    public static DomContent showHex(AArrayBlob data) {
        String dataString = data == null ? "nil" : data.toString();
        return AWebSite.preCode(dataString);
    }

    public static DomContent showHex(AArrayBlob data, int len) {
        Object text;
        Object object = text = data == null ? "nil" : data.toString();
        if (((String)text).length() > len + 2) {
            text = ((String)text).substring(0, len + 2) + "...";
        }
        return AWebSite.preCode((String)text);
    }

    public static CodeTag wrappedCode(String value) {
        return (CodeTag)TagCreator.code((String)value).withStyle("white-space: normal;max-width:50em; word-break:break-all; overflow-wrap:break-word;");
    }

    protected DomContent row(String field, DomContent value, String notes) {
        return TagCreator.tr((DomContent[])new DomContent[]{TagCreator.td((String)field), TagCreator.td((DomContent[])new DomContent[]{value}), TagCreator.td((String)notes)});
    }

    protected DomContent searchBox(String placeholder) {
        return ((FormTag)((FormTag)TagCreator.form((DomContent[])new DomContent[]{((InputTag)((InputTag)((InputTag)((InputTag)TagCreator.input().withType("search")).withName("q")).withPlaceholder(placeholder)).attr("aria-label", (Object)"Search")).attr("required", (Object)"required"), ((ButtonTag)TagCreator.button((String)"Go").withType("submit")).withStyle("width: 4em;")}).withAction("/explorer/search")).withMethod("post")).withStyle("display: flex; gap: 0.5em;");
    }

    protected DomContent searchBox() {
        return this.searchBox("Search by account #, peer key, hash, CNS name etc...");
    }

    protected static ImgTag identicon(String hexString) {
        if (hexString == null) {
            hexString = "0x";
        }
        String identiconUrl = "/identicon/" + hexString;
        ImgTag identicon = (ImgTag)((ImgTag)((ImgTag)TagCreator.img().withSrc(identiconUrl)).withAlt("Identicon for " + hexString)).withStyle("height: 2em; width: 2em; image-rendering: pixelated; margin: 2px; flex-shrink: 0;");
        return identicon;
    }

    protected static ImgTag identicon(ABlob blob) {
        if (blob == null) {
            return AWebSite.identicon((String)null);
        }
        return AWebSite.identicon(blob.toHexString());
    }
}

