/*
 * Decompiled with CFR 0.152.
 */
package convex.restapi.api;

import convex.api.Convex;
import convex.api.ConvexLocal;
import convex.core.Result;
import convex.core.crypto.AKeyPair;
import convex.core.crypto.ASignature;
import convex.core.crypto.Ed25519Signature;
import convex.core.crypto.Hashing;
import convex.core.crypto.Providers;
import convex.core.cvm.AccountStatus;
import convex.core.cvm.Address;
import convex.core.cvm.Peer;
import convex.core.cvm.transactions.ATransaction;
import convex.core.cvm.transactions.Invoke;
import convex.core.data.AArrayBlob;
import convex.core.data.ABlob;
import convex.core.data.ACell;
import convex.core.data.AHashMap;
import convex.core.data.AMap;
import convex.core.data.AString;
import convex.core.data.AVector;
import convex.core.data.AccountKey;
import convex.core.data.Blob;
import convex.core.data.Cells;
import convex.core.data.Format;
import convex.core.data.Hash;
import convex.core.data.MapEntry;
import convex.core.data.Maps;
import convex.core.data.Ref;
import convex.core.data.SignedData;
import convex.core.data.StringShort;
import convex.core.data.Strings;
import convex.core.data.Symbol;
import convex.core.data.Vectors;
import convex.core.data.prim.CVMBool;
import convex.core.data.prim.CVMLong;
import convex.core.exceptions.BadFormatException;
import convex.core.exceptions.MissingDataException;
import convex.core.exceptions.ParseException;
import convex.core.exceptions.ResultException;
import convex.core.json.JSONReader;
import convex.core.lang.RT;
import convex.core.lang.Reader;
import convex.core.util.JSON;
import convex.core.util.Utils;
import convex.peer.Server;
import convex.restapi.RESTServer;
import convex.restapi.api.ABaseAPI;
import convex.restapi.mcp.McpTool;
import convex.restapi.model.JsonRPCRequest;
import convex.restapi.model.JsonRPCResponse;
import io.javalin.Javalin;
import io.javalin.http.Context;
import io.javalin.openapi.HttpMethod;
import io.javalin.openapi.OpenApi;
import io.javalin.openapi.OpenApiContent;
import io.javalin.openapi.OpenApiExampleProperty;
import io.javalin.openapi.OpenApiRequestBody;
import io.javalin.openapi.OpenApiResponse;
import java.io.IOException;
import java.io.InputStream;
import java.security.SecureRandom;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Random;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class McpAPI
extends ABaseAPI {
    private static final Logger log = LoggerFactory.getLogger(McpAPI.class);
    public static final StringShort FIELD_ID = (StringShort)Strings.intern((String)"id");
    public static final StringShort FIELD_METHOD = (StringShort)Strings.intern((String)"method");
    public static final StringShort FIELD_PARAMS = (StringShort)Strings.intern((String)"params");
    public static final StringShort FIELD_NAME = (StringShort)Strings.intern((String)"name");
    public static final StringShort FIELD_ARGUMENTS = (StringShort)Strings.intern((String)"arguments");
    public static final StringShort FIELD_RESULT = (StringShort)Strings.intern((String)"result");
    public static final StringShort FIELD_ERROR = (StringShort)Strings.intern((String)"error");
    public static final StringShort FIELD_CODE = (StringShort)Strings.intern((String)"code");
    public static final StringShort FIELD_MESSAGE = (StringShort)Strings.intern((String)"message");
    public static final StringShort FIELD_CONTENT = (StringShort)Strings.intern((String)"content");
    public static final StringShort FIELD_STRUCTURED_CONTENT = (StringShort)Strings.intern((String)"structuredContent");
    public static final StringShort FIELD_TYPE = (StringShort)Strings.intern((String)"type");
    public static final StringShort FIELD_TEXT = (StringShort)Strings.intern((String)"text");
    public static final StringShort FIELD_IS_ERROR = (StringShort)Strings.intern((String)"isError");
    public static final StringShort SERVER_URL_FIELD = (StringShort)Strings.intern((String)"server_url");
    public static final StringShort ARG_SOURCE = (StringShort)Strings.intern((String)"source");
    public static final StringShort ARG_ADDRESS = (StringShort)Strings.intern((String)"address");
    public static final StringShort ARG_VALUE = (StringShort)Strings.intern((String)"value");
    public static final StringShort ARG_ALGORITHM = (StringShort)Strings.intern((String)"algorithm");
    public static final StringShort ARG_SEED = (StringShort)Strings.intern((String)"seed");
    public static final StringShort ARG_SEQUENCE = (StringShort)Strings.intern((String)"sequence");
    public static final StringShort ARG_CVX = (StringShort)Strings.intern((String)"cvx");
    public static final StringShort ARG_PUBLIC_KEY = (StringShort)Strings.intern((String)"publicKey");
    public static final StringShort ARG_SIGNATURE = (StringShort)Strings.intern((String)"signature");
    public static final StringShort ARG_BYTES = (StringShort)Strings.intern((String)"bytes");
    public static final StringShort ARG_ACCOUNT_KEY = (StringShort)Strings.intern((String)"accountKey");
    public static final StringShort ARG_FAUCET = (StringShort)Strings.intern((String)"faucet");
    public static final StringShort ARG_HASH = (StringShort)Strings.intern((String)"hash");
    public static final StringShort ARG_CAD3 = (StringShort)Strings.intern((String)"cad3");
    public static final StringShort ARG_GET_PATH = (StringShort)Strings.intern((String)"getPath");
    public static final StringShort ARG_NAME = (StringShort)Strings.intern((String)"name");
    public static final StringShort KEY_NETWORK_ID = (StringShort)Strings.intern((String)"networkId");
    public static final StringShort KEY_PEER_KEY = (StringShort)Strings.intern((String)"peerKey");
    public static final StringShort KEY_VALUE = (StringShort)Strings.intern((String)"value");
    public static final StringShort KEY_ERROR_CODE = (StringShort)Strings.intern((String)"errorCode");
    public static final StringShort KEY_INFO = (StringShort)Strings.intern((String)"info");
    private static final AHashMap<AString, ACell> BASE_RESPONSE = Maps.of((Object[])new Object[]{"jsonrpc", "2.0"});
    private static final AMap<AString, ACell> EMPTY_MAP = Maps.empty();
    private final AMap<AString, ACell> serverInfo;
    private final Map<String, McpTool> tools = new LinkedHashMap<String, McpTool>();
    private AMap<AString, ACell> WELL_KNOWN = (AMap)JSON.parse((String)"\t\t{\n\t\t\t\"mcp_version\": \"1.0\",\n\t\t\t\"server_url\": \"http://localhost:8080/mcp\",\n\t\t\t\"description\": \"Convex network MCP for decentralised economic systems\",\n\t\t\t\"tools_endpoint\": \"/mcp\",\n\t\t\t\"endpoint\": {\"path\":\"/mcp\",\"transport\":\"streamable-http\"}\n\t\t}\n");

    public McpAPI(RESTServer restServer) {
        super(restServer);
        AHashMap info = Maps.of((Object[])new Object[]{"name", "convex-mcp", "title", "Convex MCP", "version", Utils.getVersion()});
        Peer peer = this.server.getPeer();
        if (peer != null) {
            info = info.assoc((ACell)KEY_NETWORK_ID, (ACell)Strings.create((String)peer.getNetworkID().toHexString()));
            info = info.assoc((ACell)KEY_PEER_KEY, (ACell)Strings.create((String)peer.getPeerKey().toHexString()));
        }
        this.serverInfo = info;
        this.registerTools();
    }

    public AMap<AString, ACell> getServerInfo() {
        return this.serverInfo;
    }

    public AVector<AMap<AString, ACell>> getToolMetadata() {
        return this.listToolsVector();
    }

    @Override
    public void addRoutes(Javalin app) {
        app.post("/mcp", this::handleMcpRequest);
        app.get("/.well-known/mcp", this::getMCPWellKnown);
    }

    @OpenApi(path="/mcp", methods={HttpMethod.POST}, versions={"peer-v1"}, tags={"MCP"}, summary="Handle MCP JSON-RPC requests", requestBody=@OpenApiRequestBody(description="JSON-RPC request", content={@OpenApiContent(type="application/json", from=JsonRPCRequest.class, exampleObjects={@OpenApiExampleProperty(name="jsonrpc", value="2.0"), @OpenApiExampleProperty(name="method", value="initialize"), @OpenApiExampleProperty(name="params", value="{}"), @OpenApiExampleProperty(name="id", value="1")})}), operationId="mcpServer", responses={@OpenApiResponse(status="200", description="JSON-RPC response", content={@OpenApiContent(type="application/json", from=JsonRPCResponse.class, exampleObjects={@OpenApiExampleProperty(name="jsonrpc", value="2.0"), @OpenApiExampleProperty(name="result", value="{}"), @OpenApiExampleProperty(name="id", value="1")})})})
    private void handleMcpRequest(Context ctx) {
        ctx.contentType("application/json");
        try {
            ACell body = JSONReader.read((InputStream)ctx.bodyInputStream());
            if (body instanceof AMap) {
                AMap map = (AMap)body;
                AMap<AString, ACell> response = this.createResponse(map);
                this.setContent(ctx, (ACell)response);
            } else if (body instanceof AVector) {
                AVector vector = (AVector)body;
                long n = vector.count();
                if (n == 0L) {
                    this.setContent(ctx, (ACell)this.protocolError(-32600, "Invalid batch request (empty)"));
                    return;
                }
                AVector responses = Vectors.empty();
                for (long i = 0L; i < n; ++i) {
                    ACell entry = vector.get(i);
                    if (entry instanceof AMap) {
                        AMap batchMap = (AMap)entry;
                        responses = responses.conj(this.createResponse(batchMap));
                        continue;
                    }
                    responses = responses.conj(this.protocolError(-32600, "Invalid Request"));
                }
                this.setContent(ctx, (ACell)responses);
            } else {
                this.setContent(ctx, (ACell)this.protocolError(-32600, "Request must be a JSON object or array"));
            }
        }
        catch (ParseException | IOException e) {
            this.setContent(ctx, (ACell)this.protocolError(-32700, "Parse error"));
        }
    }

    private AMap<AString, ACell> createResponse(AMap<?, ?> request) {
        AMap<AString, ACell> result;
        ACell idCell = request.get((ACell)FIELD_ID);
        AString methodCell = RT.ensureString((ACell)request.get((ACell)FIELD_METHOD));
        if (methodCell == null) {
            return this.maybeAttachId(this.protocolError(-32600, "Missing method"), idCell);
        }
        String method = methodCell.toString().trim();
        try {
            switch (method) {
                case "initialize": {
                    result = this.protocolResult(this.buildInitializeResult());
                    break;
                }
                case "ping": {
                    result = this.protocolResult(EMPTY_MAP);
                    break;
                }
                case "notifications/initialized": {
                    result = this.protocolResult(EMPTY_MAP);
                    break;
                }
                case "tools/list": {
                    result = this.protocolResult(this.listTools());
                    break;
                }
                case "tools/call": {
                    result = this.toolCall(request.get((ACell)FIELD_PARAMS));
                    break;
                }
                default: {
                    result = this.protocolError(-32601, "Method not found: " + method);
                    break;
                }
            }
        }
        catch (Exception ex) {
            log.warn("Error handling MCP request for method {}", (Object)method, (Object)ex);
            result = this.protocolError(-32603, "Internal error");
        }
        return this.maybeAttachId(result, idCell);
    }

    private AMap<AString, ACell> buildInitializeResult() {
        AHashMap capabilities = Maps.of((Object[])new Object[]{"tools", EMPTY_MAP});
        AHashMap result = Maps.of((Object[])new Object[]{"protocolVersion", "2025-03-26", "serverInfo", this.serverInfo, "capabilities", capabilities});
        return result;
    }

    private AVector<AMap<AString, ACell>> listToolsVector() {
        AVector vec = Vectors.empty();
        for (McpTool tool : this.tools.values()) {
            vec = vec.conj(tool.getMetadata());
        }
        return vec;
    }

    private AMap<AString, ACell> listTools() {
        return Maps.of((Object[])new Object[]{"tools", this.listToolsVector()});
    }

    private AMap<AString, ACell> protocolResult(AMap<AString, ACell> result) {
        return BASE_RESPONSE.assoc((ACell)FIELD_RESULT, result);
    }

    private AMap<AString, ACell> protocolError(int code, String message) {
        AHashMap error = Maps.of((Object[])new Object[]{FIELD_CODE, CVMLong.create((long)code), FIELD_MESSAGE, message});
        return BASE_RESPONSE.assoc((ACell)FIELD_ERROR, (ACell)error);
    }

    private AMap<AString, ACell> maybeAttachId(AMap<AString, ACell> response, ACell idCell) {
        if (idCell == null) {
            return response;
        }
        return response.assoc((ACell)FIELD_ID, idCell);
    }

    private AMap<AString, ACell> toolCall(ACell paramsCell) {
        if (!(paramsCell instanceof AMap)) {
            return this.protocolError(-32602, "params must be an object");
        }
        AMap params = (AMap)paramsCell;
        AString toolNameCell = RT.ensureString((ACell)params.get((ACell)FIELD_NAME));
        if (toolNameCell == null) {
            return this.protocolError(-32602, "Tool name required");
        }
        String toolName = toolNameCell.toString();
        McpTool tool = this.tools.get(toolName);
        if (tool == null) {
            return this.protocolError(-32601, "Unknown tool: " + toolName);
        }
        AMap arguments = RT.ensureMap((ACell)params.get((ACell)FIELD_ARGUMENTS));
        if (arguments == null) {
            return this.protocolError(-32602, toolName + " requires arguments");
        }
        return tool.handle((AMap<AString, ACell>)arguments);
    }

    private AMap<AString, ACell> toolResult(Result result) {
        AMap info;
        ACell errorCode;
        AMap structured = EMPTY_MAP;
        ACell value = result.getValue();
        if (value != null) {
            structured = structured.assoc((ACell)KEY_VALUE, value);
        }
        if ((errorCode = result.getErrorCode()) != null) {
            structured = structured.assoc((ACell)KEY_ERROR_CODE, errorCode);
        }
        if ((info = result.getInfo()) != null) {
            structured = structured.assoc((ACell)KEY_INFO, (ACell)info);
        }
        return this.protocolResult(this.buildMcpResult((AMap<AString, ACell>)structured, result.isError()));
    }

    private AMap<AString, ACell> toolSuccess(ACell structuredResult) {
        AMap<AString, ACell> payload = RT.ensureMap((ACell)structuredResult);
        if (payload == null) {
            payload = EMPTY_MAP;
        }
        return this.protocolResult(this.buildMcpResult(payload, false));
    }

    private AMap<AString, ACell> toolError(String message) {
        AHashMap payload = Maps.of((Object[])new Object[]{"message", message});
        return this.protocolResult(this.buildMcpResult((AMap<AString, ACell>)payload, true));
    }

    private AMap<AString, ACell> buildMcpResult(AMap<AString, ACell> structured, boolean isError) {
        AString jsonText = JSON.print(structured);
        AHashMap textContent = Maps.of((Object[])new Object[]{FIELD_TYPE, "text", FIELD_TEXT, jsonText});
        AVector content = Vectors.of((Object[])new Object[]{textContent});
        return Maps.of((Object[])new Object[]{FIELD_CONTENT, content, FIELD_STRUCTURED_CONTENT, structured, FIELD_IS_ERROR, isError ? CVMBool.TRUE : CVMBool.FALSE});
    }

    private void registerTools() {
        this.registerTool(new QueryTool());
        this.registerTool(new PrepareTool());
        this.registerTool(new TransactTool());
        this.registerTool(new EncodeTool());
        this.registerTool(new DecodeTool());
        this.registerTool(new SubmitTool());
        this.registerTool(new HashTool());
        this.registerTool(new SignTool());
        this.registerTool(new PeerStatusTool());
        this.registerTool(new KeyGenTool());
        this.registerTool(new ValidateTool());
        this.registerTool(new CreateAccountTool());
        this.registerTool(new DescribeAccountTool());
        this.registerTool(new LookupTool());
        this.registerTool(new ResolveCNSTool());
    }

    private void registerTool(McpTool tool) {
        this.tools.put(tool.getName(), tool);
    }

    private ATransaction decodeTransaction(Blob hashBlob) throws BadFormatException, MissingDataException {
        Ref ref = Format.readRef((Blob)hashBlob, (int)0);
        ACell value = ref.getValue();
        if (!(value instanceof ATransaction)) {
            throw new BadFormatException("Value with hash " + hashBlob.toHexString() + " is not a transaction");
        }
        ATransaction transaction = (ATransaction)value;
        return transaction;
    }

    private Result performFaucetPayout(Convex faucetClient, Address address, Long faucetAmount) throws InterruptedException {
        if (faucetAmount == null) {
            return null;
        }
        long amt = faucetAmount;
        if (amt > 1000000000L) {
            amt = 1000000000L;
        }
        return faucetClient.transferSync(address, amt);
    }

    @OpenApi(path="/.well-known/mcp", methods={HttpMethod.GET}, tags={"MCP"}, summary="Get MCP server capabilities", operationId="mcpWellKnown")
    protected void getMCPWellKnown(Context ctx) {
        AMap result = this.WELL_KNOWN;
        AString mcpURL = Strings.create((String)McpAPI.getExternalBaseUrl(ctx, "mcp"));
        result = result.assoc((ACell)SERVER_URL_FIELD, (ACell)mcpURL);
        this.setContent(ctx, (ACell)result);
    }

    private class QueryTool
    extends McpTool {
        QueryTool() {
            super(McpTool.loadMetadata("convex/restapi/mcp/tools/query.json"));
        }

        @Override
        public AMap<AString, ACell> handle(AMap<AString, ACell> arguments) {
            AString sourceCell = RT.ensureString((ACell)arguments.get((ACell)ARG_SOURCE));
            if (sourceCell == null) {
                return McpAPI.this.protocolError(-32602, "Query requires 'source' string");
            }
            String source = sourceCell.toString();
            try {
                ACell form;
                try {
                    form = Reader.read((String)source);
                }
                catch (Exception e) {
                    return McpAPI.this.toolError("Failed to parse query source: " + e.getMessage());
                }
                Address address = McpAPI.this.resolveAddress(arguments.get((ACell)ARG_ADDRESS));
                Convex convex = McpAPI.this.restServer.getConvex();
                Result result = convex.querySync(form, address);
                return McpAPI.this.toolResult(result);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                return McpAPI.this.toolError("Tool call interrupted");
            }
        }
    }

    private class PrepareTool
    extends McpTool {
        PrepareTool() {
            super(McpTool.loadMetadata("convex/restapi/mcp/tools/prepare.json"));
        }

        @Override
        public AMap<AString, ACell> handle(AMap<AString, ACell> arguments) {
            long sequence;
            ACell code;
            Address address;
            AString sourceCell = RT.ensureString((ACell)arguments.get((ACell)ARG_SOURCE));
            if (sourceCell == null) {
                return McpAPI.this.protocolError(-32602, "Prepare requires 'source' string");
            }
            AString addressCell = RT.ensureString((ACell)arguments.get((ACell)ARG_ADDRESS));
            if (addressCell == null) {
                return McpAPI.this.protocolError(-32602, "Prepare requires 'address' string");
            }
            try {
                address = McpAPI.this.resolveAddress((ACell)addressCell);
            }
            catch (IllegalArgumentException e) {
                return McpAPI.this.toolError("Invalid address format: " + e.getMessage());
            }
            if (address == null) {
                return McpAPI.this.toolError("Invalid address format");
            }
            try {
                code = Reader.read((String)sourceCell.toString());
            }
            catch (Exception e) {
                return McpAPI.this.toolError("Failed to parse source: " + e.getMessage());
            }
            ACell sequenceArg = arguments.get((ACell)ARG_SEQUENCE);
            if (sequenceArg != null) {
                CVMLong seqLong = CVMLong.parse((Object)sequenceArg);
                if (seqLong == null) {
                    return McpAPI.this.toolError("sequence must be an integer");
                }
                sequence = seqLong.longValue();
            } else {
                try {
                    sequence = McpAPI.this.server.getState().getAccount(address).getSequence() + 1L;
                }
                catch (NullPointerException e) {
                    return McpAPI.this.toolError("Failed to get sequence number, account does not exist: " + String.valueOf(address));
                }
            }
            try {
                Invoke transaction = Invoke.create((Address)address, (long)sequence, (ACell)code);
                transaction = (ATransaction)Cells.persist((ACell)transaction);
                Ref ref = transaction.getRef();
                String hashHex = SignedData.getMessageForRef((Ref)ref).toHexString();
                String dataHex = Format.encodeMultiCell((ACell)transaction, (boolean)true).toHexString();
                AHashMap structured = Maps.of((Object[])new Object[]{"source", sourceCell, "address", address, "hash", hashHex, "data", dataHex, "sequence", CVMLong.create((long)sequence)});
                return McpAPI.this.toolSuccess((ACell)structured);
            }
            catch (Exception e) {
                return McpAPI.this.toolError("Prepare failed: " + e.getMessage());
            }
        }
    }

    private class TransactTool
    extends McpTool {
        TransactTool() {
            super(McpTool.loadMetadata("convex/restapi/mcp/tools/transact.json"));
        }

        @Override
        public AMap<AString, ACell> handle(AMap<AString, ACell> arguments) {
            AMap<AString, ACell> aMap;
            block15: {
                Address address;
                AString sourceCell = RT.ensureString((ACell)arguments.get((ACell)ARG_SOURCE));
                if (sourceCell == null) {
                    return McpAPI.this.protocolError(-32602, "Transact requires 'source' string");
                }
                AString seedCell = RT.ensureString((ACell)arguments.get((ACell)ARG_SEED));
                if (seedCell == null) {
                    return McpAPI.this.protocolError(-32602, "Transact requires 'seed' string");
                }
                AString addressCell = RT.ensureString((ACell)arguments.get((ACell)ARG_ADDRESS));
                if (addressCell == null) {
                    return McpAPI.this.protocolError(-32602, "Transact requires 'address' string");
                }
                Blob seedBlob = Blob.parse((Object)seedCell);
                if (seedBlob == null || seedBlob.count() != 32L) {
                    return McpAPI.this.toolError("Seed must be 32-byte hex string");
                }
                try {
                    address = McpAPI.this.resolveAddress((ACell)addressCell);
                }
                catch (IllegalArgumentException e) {
                    return McpAPI.this.toolError("Invalid address format: " + e.getMessage());
                }
                if (address == null) {
                    return McpAPI.this.toolError("Invalid address format");
                }
                AKeyPair keyPair = AKeyPair.create((Blob)seedBlob);
                ConvexLocal client = Convex.connect((Server)McpAPI.this.server);
                try {
                    client.setAddress(address);
                    client.setKeyPair(keyPair);
                    Result result = client.transactSync(Reader.read((AString)sourceCell));
                    aMap = McpAPI.this.toolResult(result);
                    if (client == null) break block15;
                }
                catch (Throwable throwable) {
                    try {
                        if (client != null) {
                            try {
                                client.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (Exception e) {
                        return McpAPI.this.toolError("Transaction failed: " + e.getMessage());
                    }
                }
                client.close();
            }
            return aMap;
        }
    }

    private class EncodeTool
    extends McpTool {
        EncodeTool() {
            super(McpTool.loadMetadata("convex/restapi/mcp/tools/encode.json"));
        }

        @Override
        public AMap<AString, ACell> handle(AMap<AString, ACell> arguments) {
            AString cvxCell = RT.ensureString((ACell)arguments.get((ACell)ARG_CVX));
            if (cvxCell == null) {
                return McpAPI.this.protocolError(-32602, "Encode requires 'cvx' string");
            }
            try {
                ACell value = Reader.read((String)cvxCell.toString());
                Blob encoded = Format.encodeMultiCell((ACell)value, (boolean)true);
                AHashMap result = Maps.of((Object[])new Object[]{"cad3", encoded.toCVMHexString(), "hash", Ref.get((ACell)value).getEncoding().toCVMHexString()});
                return McpAPI.this.toolSuccess((ACell)result);
            }
            catch (Exception e) {
                return McpAPI.this.toolError("Encode failed: " + e.getMessage());
            }
        }
    }

    private class DecodeTool
    extends McpTool {
        DecodeTool() {
            super(McpTool.loadMetadata("convex/restapi/mcp/tools/decode.json"));
        }

        @Override
        public AMap<AString, ACell> handle(AMap<AString, ACell> arguments) {
            AString cad3Cell = RT.ensureString((ACell)arguments.get((ACell)ARG_CAD3));
            if (cad3Cell == null) {
                return McpAPI.this.protocolError(-32602, "Decode requires 'cad3' string");
            }
            Blob cad3Blob = Blob.parse((Object)cad3Cell);
            if (cad3Blob == null) {
                return McpAPI.this.toolError("cad3 must be valid hex data");
            }
            try {
                ACell decoded = Format.decodeMultiCell((Blob)cad3Blob);
                AString cvx = RT.print((ACell)decoded);
                AHashMap result = Maps.of((Object[])new Object[]{"cvx", cvx == null ? "" : cvx});
                return McpAPI.this.toolSuccess((ACell)result);
            }
            catch (Exception e) {
                return McpAPI.this.toolError("Decode failed: " + e.getMessage());
            }
        }
    }

    private class SubmitTool
    extends McpTool {
        SubmitTool() {
            super(McpTool.loadMetadata("convex/restapi/mcp/tools/submit.json"));
        }

        @Override
        public AMap<AString, ACell> handle(AMap<AString, ACell> arguments) {
            AString hashCell = RT.ensureString((ACell)arguments.get((ACell)ARG_HASH));
            if (hashCell == null) {
                return McpAPI.this.protocolError(-32602, "Submit requires 'hash' string");
            }
            Blob hashBlob = Blob.parse((Object)hashCell);
            if (hashBlob == null) {
                return McpAPI.this.toolError("hash must be valid hex");
            }
            try {
                ATransaction transaction = McpAPI.this.decodeTransaction(hashBlob);
                AString accountKeyCell = RT.ensureString((ACell)arguments.get((ACell)ARG_ACCOUNT_KEY));
                if (accountKeyCell == null) {
                    return McpAPI.this.protocolError(-32602, "Submit requires 'accountKey' string");
                }
                AccountKey accountKey = AccountKey.parse((String)accountKeyCell.toString());
                if (accountKey == null) {
                    return McpAPI.this.toolError("Invalid account key");
                }
                AString signatureCell = RT.ensureString((ACell)arguments.get((ACell)ARG_SIGNATURE));
                if (signatureCell == null) {
                    return McpAPI.this.protocolError(-32602, "Submit requires 'sig' string with Ed25519 signature");
                }
                Blob signatureBlob = Blob.parse((String)signatureCell.toString());
                if (signatureBlob == null || signatureBlob.count() != 64L) {
                    return McpAPI.this.toolError("signature must be a 64-byte hex string");
                }
                ASignature signature = Ed25519Signature.fromBlob((ABlob)signatureBlob);
                SignedData signed = SignedData.create((AccountKey)accountKey, (ASignature)signature, (Ref)transaction.getRef());
                Result result = McpAPI.this.restServer.getConvex().transactSync(signed);
                return McpAPI.this.toolResult(result);
            }
            catch (Exception e) {
                return McpAPI.this.toolError("Submit failed: " + e.getMessage());
            }
        }
    }

    private class HashTool
    extends McpTool {
        HashTool() {
            super(McpTool.loadMetadata("convex/restapi/mcp/tools/hash.json"));
        }

        @Override
        public AMap<AString, ACell> handle(AMap<AString, ACell> arguments) {
            Hash hash;
            String algorithm;
            AString valueCell = RT.ensureString((ACell)arguments.get((ACell)ARG_VALUE));
            if (valueCell == null) {
                return McpAPI.this.protocolError(-32602, "Hash tool requires 'value' string");
            }
            String value = valueCell.toString();
            AString algorithmCell = RT.ensureString((ACell)arguments.get((ACell)ARG_ALGORITHM));
            switch (algorithm = algorithmCell == null ? "sha256" : algorithmCell.toString().toLowerCase()) {
                case "sha3": {
                    Hash hash2 = Hashing.sha3((String)value);
                    break;
                }
                case "sha256": {
                    Hash hash2 = Hashing.sha256((String)value);
                    break;
                }
                default: {
                    Hash hash2 = hash = null;
                }
            }
            if (hash == null) {
                return McpAPI.this.toolError("Unsupported hash algorithm: " + algorithm);
            }
            String hashHex = hash.toHexString();
            AHashMap result = Maps.of((Object[])new Object[]{"algorithm", algorithm, "hash", hashHex});
            return McpAPI.this.toolSuccess((ACell)result);
        }
    }

    private class SignTool
    extends McpTool {
        SignTool() {
            super(McpTool.loadMetadata("convex/restapi/mcp/tools/sign.json"));
        }

        @Override
        public AMap<AString, ACell> handle(AMap<AString, ACell> arguments) {
            AString valueCell = RT.ensureString((ACell)arguments.get((ACell)ARG_VALUE));
            if (valueCell == null) {
                return McpAPI.this.toolError("Sign tool requires a 'value' hex string");
            }
            Blob valueBlob = Blob.parse((String)valueCell.toString());
            if (valueBlob == null) {
                return McpAPI.this.toolError("Value must be valid hex data");
            }
            AString seedCell = RT.ensureString((ACell)arguments.get((ACell)ARG_SEED));
            if (seedCell == null) {
                return McpAPI.this.toolError("Sign tool requires Ed25519 'seed' string");
            }
            String seedHex = seedCell.toString();
            Blob seedBlob = Blob.parse((String)seedHex);
            if (seedBlob == null || seedBlob.count() != 32L) {
                return McpAPI.this.toolError("Seed must be 32-byte hex string");
            }
            try {
                AKeyPair keyPair = AKeyPair.create((Blob)seedBlob);
                ASignature signature = keyPair.sign((AArrayBlob)valueBlob);
                AccountKey accountKey = keyPair.getAccountKey();
                AHashMap result = Maps.of((Object[])new Object[]{"value", valueCell, "signature", signature.toHexString(), "accountKey", accountKey.toHexString()});
                return McpAPI.this.toolSuccess((ACell)result);
            }
            catch (Exception e) {
                return McpAPI.this.toolError("Signing failed: " + e.getMessage());
            }
        }
    }

    private class PeerStatusTool
    extends McpTool {
        PeerStatusTool() {
            super(McpTool.loadMetadata("convex/restapi/mcp/tools/peerStatus.json"));
        }

        @Override
        public AMap<AString, ACell> handle(AMap<AString, ACell> arguments) {
            try {
                AMap status = McpAPI.this.server.getStatusMap();
                AHashMap payload = Maps.of((Object[])new Object[]{"status", status});
                return McpAPI.this.toolSuccess((ACell)payload);
            }
            catch (Exception e) {
                return McpAPI.this.toolError("Failed to load peer status: " + e.getMessage());
            }
        }
    }

    private class KeyGenTool
    extends McpTool {
        KeyGenTool() {
            super(McpTool.loadMetadata("convex/restapi/mcp/tools/keyGen.json"));
        }

        @Override
        public AMap<AString, ACell> handle(AMap<AString, ACell> arguments) {
            try {
                Blob seedBlob;
                AString seedCell = RT.ensureString(arguments != null ? arguments.get((ACell)ARG_SEED) : null);
                if (seedCell != null) {
                    String seedHex = seedCell.toString();
                    seedBlob = Blob.parse((String)seedHex);
                    if (seedBlob == null) {
                        return McpAPI.this.toolError("Seed must be valid hex data");
                    }
                    if (seedBlob.count() != 32L) {
                        return McpAPI.this.toolError("Seed must be 32-byte hex string (64 hex characters)");
                    }
                } else {
                    seedBlob = Blob.createRandom((Random)new SecureRandom(), (long)32L);
                }
                AKeyPair keyPair = AKeyPair.create((Blob)seedBlob);
                AccountKey publicKey = keyPair.getAccountKey();
                AHashMap result = Maps.of((Object[])new Object[]{"seed", seedBlob.toString(), "publicKey", publicKey.toString()});
                return McpAPI.this.toolSuccess((ACell)result);
            }
            catch (Exception e) {
                return McpAPI.this.toolError("Key generation failed: " + e.getMessage());
            }
        }
    }

    private class ValidateTool
    extends McpTool {
        ValidateTool() {
            super(McpTool.loadMetadata("convex/restapi/mcp/tools/validate.json"));
        }

        @Override
        public AMap<AString, ACell> handle(AMap<AString, ACell> arguments) {
            AString publicKeyCell = RT.ensureString((ACell)arguments.get((ACell)ARG_PUBLIC_KEY));
            if (publicKeyCell == null) {
                return McpAPI.this.protocolError(-32602, "Validate requires 'publicKey' string");
            }
            AString signatureCell = RT.ensureString((ACell)arguments.get((ACell)ARG_SIGNATURE));
            if (signatureCell == null) {
                return McpAPI.this.protocolError(-32602, "Validate requires 'signature' string");
            }
            AString bytesCell = RT.ensureString((ACell)arguments.get((ACell)ARG_BYTES));
            if (bytesCell == null) {
                return McpAPI.this.protocolError(-32602, "Validate requires 'bytes' string");
            }
            try {
                AccountKey publicKey = AccountKey.parse((String)publicKeyCell.toString());
                if (publicKey == null) {
                    return McpAPI.this.toolError("Invalid public key format");
                }
                Blob signatureBlob = Blob.parse((String)signatureCell.toString());
                if (signatureBlob == null) {
                    return McpAPI.this.toolError("Signature must be valid hex data");
                }
                if (signatureBlob.count() != 64L) {
                    return McpAPI.this.toolError("Signature must be 64-byte hex string (128 hex characters)");
                }
                ASignature signature = Ed25519Signature.fromBlob((ABlob)signatureBlob);
                Blob messageBlob = Blob.parse((String)bytesCell.toString());
                if (messageBlob == null) {
                    return McpAPI.this.toolError("Bytes must be valid hex data");
                }
                boolean isValid = Providers.verify((ASignature)signature, (AArrayBlob)messageBlob, (AccountKey)publicKey);
                AHashMap result = Maps.of((Object[])new Object[]{"value", isValid ? CVMBool.TRUE : CVMBool.FALSE});
                return McpAPI.this.toolSuccess((ACell)result);
            }
            catch (Exception e) {
                return McpAPI.this.toolError("Validation failed: " + e.getMessage());
            }
        }
    }

    private class CreateAccountTool
    extends McpTool {
        CreateAccountTool() {
            super(McpTool.loadMetadata("convex/restapi/mcp/tools/createAccount.json"));
        }

        @Override
        public AMap<AString, ACell> handle(AMap<AString, ACell> arguments) {
            AString accountKeyCell = RT.ensureString((ACell)arguments.get((ACell)ARG_ACCOUNT_KEY));
            if (accountKeyCell == null) {
                return McpAPI.this.protocolError(-32602, "CreateAccount requires 'accountKey' string");
            }
            Convex faucetClient = McpAPI.this.restServer.getFaucet();
            if (faucetClient == null) {
                return McpAPI.this.toolError("Faucet use not authorised on this server");
            }
            try {
                Result transferResult;
                AccountKey accountKey = AccountKey.parse((String)accountKeyCell.toString());
                if (accountKey == null) {
                    return McpAPI.this.toolError("Unable to parse accountKey: " + String.valueOf(accountKeyCell));
                }
                ACell faucetCell = arguments.get((ACell)ARG_FAUCET);
                Long faucetAmount = null;
                if (faucetCell != null) {
                    CVMLong faucetLong = CVMLong.parse((Object)faucetCell);
                    if (faucetLong == null) {
                        return McpAPI.this.toolError("Faucet amount must be a valid number");
                    }
                    faucetAmount = faucetLong.longValue();
                }
                Address address = faucetClient.createAccountSync(accountKey);
                if (faucetAmount != null && (transferResult = McpAPI.this.performFaucetPayout(faucetClient, address, faucetAmount)) != null && transferResult.isError()) {
                    return McpAPI.this.toolResult(transferResult);
                }
                AHashMap result = Maps.of((Object[])new Object[]{"address", CVMLong.create((long)address.longValue())});
                return McpAPI.this.toolSuccess((ACell)result);
            }
            catch (ResultException e) {
                return McpAPI.this.toolResult(e.getResult());
            }
            catch (Exception e) {
                return McpAPI.this.toolError("Account creation failed: " + e.getMessage());
            }
        }
    }

    private class DescribeAccountTool
    extends McpTool {
        DescribeAccountTool() {
            super(McpTool.loadMetadata("convex/restapi/mcp/tools/describeAccount.json"));
        }

        @Override
        public AMap<AString, ACell> handle(AMap<AString, ACell> arguments) {
            try {
                Object metadataString;
                AHashMap env;
                Address address;
                try {
                    address = McpAPI.this.resolveAddress(RT.getIn(arguments, (ACell[])new ACell[]{ARG_ADDRESS}));
                }
                catch (IllegalArgumentException e) {
                    return McpAPI.this.toolError("Invalid address format: " + e.getMessage());
                }
                if (address == null) {
                    return McpAPI.this.toolError("No valid address provided");
                }
                AccountStatus accountStatus = McpAPI.this.server.getState().getAccount(address);
                if (accountStatus == null) {
                    return McpAPI.this.toolError("Account not found: " + String.valueOf(address));
                }
                AHashMap meta = accountStatus.getMetadata();
                if (meta == null) {
                    meta = Maps.empty();
                }
                if ((env = accountStatus.getEnvironment()) != null) {
                    long esize = env.count();
                    for (long i = 0L; i < esize; ++i) {
                        MapEntry entry = env.entryAt(i);
                        Symbol sym = (Symbol)entry.getKey();
                        if (meta.containsKey((ACell)sym)) continue;
                        meta = meta.assoc((ACell)sym, null);
                    }
                }
                if ((metadataString = RT.print((ACell)meta)) == null) {
                    metadataString = "Metadata too large to print";
                }
                AHashMap resultMap = Maps.of((Object[])new Object[]{"metadata", metadataString});
                return McpAPI.this.toolSuccess((ACell)resultMap);
            }
            catch (Exception e) {
                return McpAPI.this.toolError("Account lookup failed: " + e.getMessage());
            }
        }
    }

    private class LookupTool
    extends McpTool {
        LookupTool() {
            super(McpTool.loadMetadata("convex/restapi/mcp/tools/lookup.json"));
        }

        @Override
        public AMap<AString, ACell> handle(AMap<AString, ACell> arguments) {
            try {
                AHashMap symbolMeta;
                boolean exists;
                Address address;
                ACell addressCell = arguments.get((ACell)ARG_ADDRESS);
                if (addressCell == null) {
                    return McpAPI.this.toolError("Lookup requires 'address' parameter, e.g. '#5675' or '@convex.core'");
                }
                try {
                    address = McpAPI.this.resolveAddress(addressCell);
                }
                catch (IllegalArgumentException e) {
                    return McpAPI.this.toolError("Invalid address format: " + e.getMessage());
                }
                if (address == null) {
                    return McpAPI.this.toolError("Invalid address format");
                }
                AString symbolCell = RT.ensureString((ACell)arguments.get((ACell)Strings.SYMBOL));
                if (symbolCell == null) {
                    return McpAPI.this.toolError("Lookup requires 'symbol' parameter");
                }
                Symbol symbol = RT.ensureSymbol((ACell)Reader.read((AString)symbolCell));
                AccountStatus accountStatus = McpAPI.this.server.getPeer().getConsensusState().getAccount(address);
                if (accountStatus == null) {
                    return McpAPI.this.toolError("Account not found: " + String.valueOf(address));
                }
                AHashMap env = accountStatus.getEnvironment();
                boolean bl = exists = env != null && env.containsKey((ACell)symbol);
                if (!exists) {
                    return McpAPI.this.toolSuccess((ACell)Maps.of((Object[])new Object[]{"exists", CVMBool.FALSE}));
                }
                ACell value = null;
                if (exists && env != null) {
                    value = env.get((ACell)symbol);
                    AString pathCell = RT.ensureString((ACell)arguments.get((ACell)ARG_GET_PATH));
                    if (pathCell != null && value != null) {
                        String pathStr = pathCell.toString();
                        try {
                            ACell pathForm = Reader.read((String)pathStr);
                            AVector pathSeq = RT.ensureVector((ACell)pathForm);
                            if (pathSeq != null) {
                                long pathLen = pathSeq.count();
                                ACell[] pathKeys = new ACell[(int)pathLen];
                                for (long i = 0L; i < pathLen; ++i) {
                                    pathKeys[(int)i] = pathSeq.get(i);
                                }
                                value = RT.getIn((ACell)value, (ACell[])pathKeys);
                            } else {
                                value = RT.getIn((ACell)value, (ACell[])new ACell[]{pathForm});
                            }
                        }
                        catch (Exception e) {
                            return McpAPI.this.toolError("Failed to parse getPath: " + e.getMessage());
                        }
                    }
                }
                AHashMap meta = null;
                if (exists && (symbolMeta = accountStatus.getMetadata(symbol)) != null && !symbolMeta.isEmpty()) {
                    meta = symbolMeta;
                }
                AHashMap resultMap = Maps.of((Object[])new Object[]{"exists", exists ? CVMBool.TRUE : CVMBool.FALSE, "value", RT.print((ACell)value), "meta", RT.print((ACell)meta)});
                return McpAPI.this.toolSuccess((ACell)resultMap);
            }
            catch (Exception e) {
                return McpAPI.this.toolError("Lookup failed: " + e.getMessage());
            }
        }
    }

    private class ResolveCNSTool
    extends McpTool {
        ResolveCNSTool() {
            super(McpTool.loadMetadata("convex/restapi/mcp/tools/resolveCNS.json"));
        }

        @Override
        public AMap<AString, ACell> handle(AMap<AString, ACell> arguments) {
            try {
                Symbol symbol;
                AString nameCell = RT.ensureString((ACell)arguments.get((ACell)ARG_NAME));
                if (nameCell == null) {
                    return McpAPI.this.toolError("ResolveCNS requires 'name' parameter, e.g. 'convex.core'");
                }
                if (nameCell.startsWith("@")) {
                    nameCell = nameCell.slice(1L);
                }
                if ((symbol = Symbol.create((AString)nameCell)) == null) {
                    return McpAPI.this.toolError("Invalid CNS name: " + String.valueOf(nameCell));
                }
                AVector record = McpAPI.this.server.getState().lookupCNSRecord(symbol);
                if (record == null) {
                    return McpAPI.this.toolSuccess((ACell)Maps.of((Object[])new Object[]{"exists", CVMBool.FALSE}));
                }
                if (record.count() != 4L) {
                    return McpAPI.this.toolError("CNS record has unexpected length, got " + String.valueOf(record));
                }
                ACell value = record.get(0);
                ACell controller = record.get(1);
                ACell meta = record.get(2);
                ACell child = record.get(3);
                AHashMap resultMap = Maps.of((Object[])new Object[]{"value", RT.print((ACell)value), "controller", RT.print((ACell)controller), "meta", RT.print((ACell)meta), "child", RT.print((ACell)child), "exists", CVMBool.TRUE});
                return McpAPI.this.toolSuccess((ACell)resultMap);
            }
            catch (Exception e) {
                return McpAPI.this.toolError("CNS resolution failed: " + e.getMessage());
            }
        }
    }
}

