/*
 * Decompiled with CFR 0.152.
 */
package convex.restapi.api;

import convex.core.data.ACell;
import convex.core.data.Blob;
import convex.core.data.Format;
import convex.core.lang.Reader;
import convex.java.JSON;
import io.javalin.Javalin;
import io.javalin.http.BadRequestResponse;
import io.javalin.http.Context;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Map;

public abstract class AGenericAPI {
    public abstract void addRoutes(Javalin var1);

    protected String calcResponseContentType(Context ctx) {
        Enumeration accepts = ctx.req().getHeaders("Accept");
        String type = "application/json";
        if (accepts != null) {
            for (String a : Collections.list(accepts)) {
                if (a.contains("application/cvx-raw")) {
                    type = "application/cvx-raw";
                    break;
                }
                if (!a.contains("application/cvx")) continue;
                type = "application/cvx";
            }
        }
        return type;
    }

    protected Map<String, Object> getJSONBody(Context ctx) {
        try {
            Map req = JSON.toMap((String)ctx.body());
            return req;
        }
        catch (IllegalArgumentException e) {
            throw new BadRequestResponse(AGenericAPI.jsonError("Invalid JSON body"));
        }
    }

    protected <T extends ACell> T getCVXBody(Context ctx) {
        try {
            ACell req = Reader.read((String)ctx.body());
            return (T)req;
        }
        catch (Exception e) {
            throw new BadRequestResponse(AGenericAPI.jsonError("Invalid CVX body"));
        }
    }

    protected <T extends ACell> T getRawBody(Context ctx) {
        try {
            byte[] bs = ctx.bodyAsBytes();
            ACell result = Format.decodeMultiCell((Blob)Blob.wrap((byte[])bs));
            return (T)result;
        }
        catch (Exception e) {
            throw new BadRequestResponse(AGenericAPI.jsonError("Invalid Raw body"));
        }
    }

    protected static String jsonError(String string) {
        return "{\"error\":\"" + string + "\"}";
    }
}

