/*
 * Decompiled with CFR 0.152.
 */
package convex.restapi;

import convex.api.Convex;
import convex.api.ConvexLocal;
import convex.core.crypto.AKeyPair;
import convex.core.crypto.CertUtils;
import convex.core.cvm.Address;
import convex.core.cvm.Keywords;
import convex.core.data.Keyword;
import convex.core.util.Utils;
import convex.peer.API;
import convex.peer.ConfigException;
import convex.peer.LaunchException;
import convex.peer.Server;
import convex.restapi.WebApp;
import convex.restapi.api.ChainAPI;
import convex.restapi.api.DLAPI;
import convex.restapi.api.DepAPI;
import convex.restapi.api.ExplorerAPI;
import convex.restapi.api.PeerAdminAPI;
import io.javalin.Javalin;
import io.javalin.community.ssl.SslPlugin;
import io.javalin.config.JavalinConfig;
import io.javalin.http.staticfiles.Location;
import io.javalin.openapi.JsonSchemaLoader;
import io.javalin.openapi.JsonSchemaResource;
import io.javalin.openapi.plugin.DefinitionConfiguration;
import io.javalin.openapi.plugin.OpenApiPlugin;
import io.javalin.openapi.plugin.redoc.ReDocPlugin;
import io.javalin.openapi.plugin.swagger.SwaggerPlugin;
import io.javalin.plugin.Plugin;
import io.javalin.util.JavalinException;
import java.io.Closeable;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.HashMap;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.ServerConnector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RESTServer
implements Closeable {
    protected static final Logger log = LoggerFactory.getLogger((String)RESTServer.class.getName());
    protected final Server server;
    protected final Convex convex;
    protected Javalin javalin;
    protected ChainAPI chainAPI;
    protected DepAPI depAPI;
    protected DLAPI dlAPI;
    protected WebApp webApp;
    protected PeerAdminAPI peerAPI;
    protected ExplorerAPI explorerAPI;

    private RESTServer(Server server) {
        this.server = server;
        this.convex = ConvexLocal.create((Server)server, (Address)server.getPeerController(), (AKeyPair)server.getKeyPair());
    }

    private Javalin buildApp(boolean useSSL) {
        SslPlugin sslPlugin = this.getSSLPlugin(this.server.getConfig());
        Javalin app = Javalin.create((T config) -> {
            config.bundledPlugins.enableCors(cors -> cors.addRule(corsConfig -> corsConfig.anyHost()));
            if (useSSL && sslPlugin != null) {
                config.registerPlugin((Plugin)sslPlugin);
            }
            this.addOpenApiPlugins((JavalinConfig)config);
            config.staticFiles.add(staticFiles -> {
                staticFiles.hostedPath = "/";
                staticFiles.location = Location.CLASSPATH;
                staticFiles.directory = "/convex/restapi/pub";
                staticFiles.precompress = false;
                staticFiles.aliasCheck = null;
                staticFiles.skipFileFunction = req -> false;
            });
            config.useVirtualThreads = true;
        });
        app.exception(Exception.class, (e, ctx) -> {
            e.printStackTrace();
            String message = "Unexpected error: " + String.valueOf(e);
            ctx.result(message);
            ctx.status(500);
        });
        app.options("/*", ctx -> {
            ctx.status(204);
            ctx.removeHeader("Content-type");
            ctx.header("access-control-allow-headers", "content-type");
            ctx.header("access-control-allow-methods", "GET,HEAD,PUT,PATCH,POST,DELETE");
            ctx.header("access-control-allow-origin", "*");
            ctx.header("vary", "Origin, Access-Control-Request-Headers");
        });
        app.afterMatched(ctx -> {
            String origin = ctx.req().getHeader("Origin");
            if (origin != null) {
                ctx.header("access-control-allow-origin", "*");
            } else {
                ctx.header("access-control-allow-origin", "*");
            }
        });
        this.addAPIRoutes(app);
        return app;
    }

    protected SslPlugin getSSLPlugin(HashMap<Keyword, Object> config) {
        SslPlugin sslPlugin = null;
        try {
            Path basePath = Utils.getHomePath().resolve(".convex/ssl");
            Path certFile = basePath.resolve("certificate.pem");
            Path privateFile = basePath.resolve("private.pem");
            if (!Files.exists(certFile, new LinkOption[0]) || !Files.exists(privateFile, new LinkOption[0])) {
                basePath = Files.createTempDirectory("certs", new FileAttribute[0]);
                String subjectDN = "CN=localhost, O=o, L=L, ST=il, C=c";
                CertUtils.createCertificateFiles((String)subjectDN, (Path)basePath);
            }
            InputStream certS = Files.newInputStream(certFile, new OpenOption[0]);
            InputStream privateS = Files.newInputStream(privateFile, new OpenOption[0]);
            sslPlugin = new SslPlugin(conf -> {
                conf.pemFromInputStream(certS, privateS);
                conf.http2 = true;
            });
        }
        catch (Exception e) {
            e.printStackTrace();
            log.warn("Failed to create SSL plugin, will use insecure HTTP only", (Throwable)e);
        }
        return sslPlugin;
    }

    protected void addOpenApiPlugins(JavalinConfig config) {
        String docsPath = "openapi-plugin/openapi-default.json";
        config.registerPlugin((Plugin)new OpenApiPlugin(pluginConfig -> pluginConfig.withDocumentationPath(docsPath).withDefinitionConfiguration((version, definition) -> {
            DefinitionConfiguration def = definition;
            def = def.withInfo(info -> {
                info.setTitle("Convex REST API");
                info.setVersion("0.7.0");
            });
        })));
        config.registerPlugin((Plugin)new SwaggerPlugin(swaggerConfiguration -> swaggerConfiguration.setDocumentationPath(docsPath)));
        config.registerPlugin((Plugin)new ReDocPlugin(reDocConfiguration -> reDocConfiguration.setDocumentationPath(docsPath)));
        for (JsonSchemaResource generatedJsonSchema : new JsonSchemaLoader().loadGeneratedSchemes()) {
            System.out.println(generatedJsonSchema.getName());
        }
    }

    private void addAPIRoutes(Javalin app) {
        this.chainAPI = new ChainAPI(this);
        this.chainAPI.addRoutes(app);
        this.depAPI = new DepAPI(this);
        this.depAPI.addRoutes(app);
        this.peerAPI = new PeerAdminAPI(this);
        this.peerAPI.addRoutes(app);
        this.webApp = new WebApp(this);
        this.webApp.addRoutes(app);
        this.dlAPI = new DLAPI(this);
        this.dlAPI.addRoutes(app);
        this.explorerAPI = new ExplorerAPI(this);
        this.explorerAPI.addRoutes(app);
    }

    public static RESTServer create(Server server) {
        RESTServer newServer = new RESTServer(server);
        return newServer;
    }

    public static RESTServer create(Convex convex) {
        return RESTServer.create(convex.getLocalServer());
    }

    protected void setupJettyServer(org.eclipse.jetty.server.Server jettyServer, Integer port) {
        if (port == null) {
            port = 8080;
        }
        ServerConnector connector = new ServerConnector(jettyServer);
        connector.setPort(port.intValue());
        jettyServer.addConnector((Connector)connector);
    }

    public void start() {
        this.start(null);
    }

    public synchronized void start(Integer port) {
        this.close();
        try {
            this.javalin = this.buildApp(true);
            this.start(this.javalin, port);
        }
        catch (JavalinException e) {
            if (port != null) {
                throw e;
            }
            log.warn("Specified port " + port + "already in use, chosing another at random");
            this.close();
            port = 0;
            this.javalin = this.buildApp(false);
            this.start(this.javalin, port);
        }
    }

    protected void start(Javalin app, Integer port) {
        org.eclipse.jetty.server.Server jettyServer = app.jettyServer().server();
        this.setupJettyServer(jettyServer, port);
        app.start();
    }

    @Override
    public synchronized void close() {
        if (this.javalin != null) {
            this.javalin.stop();
        }
        this.javalin = null;
    }

    public Convex getConvex() {
        return this.convex;
    }

    public Server getServer() {
        return this.server;
    }

    public int getPort() {
        if (this.javalin == null) {
            throw new Error("Javalin not started");
        }
        return this.javalin.port();
    }

    public HashMap<Keyword, Object> getConfig() {
        return this.server.getConfig();
    }

    public String getBaseURL() {
        Object o = this.server.getConfig().get(Keywords.BASE_URL);
        if (o instanceof String) {
            return (String)o;
        }
        return null;
    }

    public static void main(String[] args) throws InterruptedException, ConfigException, LaunchException {
        HashMap<Keyword, Object> config = new HashMap<Keyword, Object>();
        config.put(Keywords.KEYPAIR, AKeyPair.generate());
        config.put(Keyword.create((String)"faucet"), true);
        Server s = API.launchPeer(config);
        System.out.println("Using Ed25519 seed:   " + String.valueOf(s.getKeyPair().getSeed()));
        System.out.println("Using peer port:      " + s.getPort());
        try (RESTServer rs = RESTServer.create(s);){
            rs.start();
            System.out.println("Started on REST port: " + rs.getPort());
            while (s.isRunning()) {
                Thread.sleep(1000L);
            }
        }
        System.out.println("Server shutting down.... bye!");
    }
}

