/*
 * Decompiled with CFR 0.152.
 */
package convex.restapi.api;

import convex.api.Convex;
import convex.core.ErrorCodes;
import convex.core.Result;
import convex.core.crypto.AKeyPair;
import convex.core.crypto.ASignature;
import convex.core.crypto.Ed25519Signature;
import convex.core.data.ABlob;
import convex.core.data.ACell;
import convex.core.data.AccountKey;
import convex.core.data.AccountStatus;
import convex.core.data.Address;
import convex.core.data.Blob;
import convex.core.data.Blobs;
import convex.core.data.Cells;
import convex.core.data.Format;
import convex.core.data.Hash;
import convex.core.data.Keyword;
import convex.core.data.Lists;
import convex.core.data.PeerStatus;
import convex.core.data.Ref;
import convex.core.data.SignedData;
import convex.core.data.prim.AInteger;
import convex.core.data.prim.CVMLong;
import convex.core.exceptions.BadFormatException;
import convex.core.exceptions.MissingDataException;
import convex.core.exceptions.ResultException;
import convex.core.lang.RT;
import convex.core.lang.Reader;
import convex.core.lang.Symbols;
import convex.core.transactions.ATransaction;
import convex.core.transactions.Invoke;
import convex.core.util.Utils;
import convex.java.JSON;
import convex.restapi.RESTServer;
import convex.restapi.api.ABaseAPI;
import convex.restapi.model.CreateAccountRequest;
import convex.restapi.model.CreateAccountResponse;
import convex.restapi.model.FaucetRequest;
import convex.restapi.model.QueryAccountResponse;
import convex.restapi.model.QueryRequest;
import convex.restapi.model.ResultResponse;
import convex.restapi.model.TransactRequest;
import convex.restapi.model.TransactionPrepareRequest;
import convex.restapi.model.TransactionPrepareResponse;
import convex.restapi.model.TransactionSubmitRequest;
import io.javalin.Javalin;
import io.javalin.http.BadRequestResponse;
import io.javalin.http.Context;
import io.javalin.http.ForbiddenResponse;
import io.javalin.http.InternalServerErrorResponse;
import io.javalin.http.NotFoundResponse;
import io.javalin.openapi.HttpMethod;
import io.javalin.openapi.OpenApi;
import io.javalin.openapi.OpenApiContent;
import io.javalin.openapi.OpenApiExampleProperty;
import io.javalin.openapi.OpenApiParam;
import io.javalin.openapi.OpenApiRequestBody;
import io.javalin.openapi.OpenApiResponse;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;

public class ChainAPI
extends ABaseAPI {
    public Convex convex;
    private static final String ROUTE = "/api/v1/";
    private static Keyword K_FAUCET = Keyword.create((String)"faucet");

    public ChainAPI(RESTServer restServer) {
        super(restServer);
        this.convex = restServer.getConvex();
    }

    @Override
    public void addRoutes(Javalin app) {
        String prefix = ROUTE;
        app.post(prefix + "createAccount", this::createAccount);
        app.post(prefix + "query", this::runQuery);
        app.post(prefix + "faucet", this::faucetRequest);
        app.post(prefix + "transaction/prepare", this::runTransactionPrepare);
        app.post(prefix + "transaction/submit", this::runTransactionSubmit);
        app.post(prefix + "transact", this::runTransact);
        app.get(prefix + "accounts/<addr>", this::queryAccount);
        app.get(prefix + "peers/<addr>", this::queryPeer);
        app.get(prefix + "data/<hash>", this::getData);
    }

    @OpenApi(path="/api/v1/data/{hash}", methods={HttpMethod.POST}, tags={"Data Lattice"}, summary="Get data from the server with the specified hash", operationId="data", pathParams={@OpenApiParam(name="hash", description="Data hash as a hex string. Leading '0x' is optional but discouraged.", required=true, type=String.class, example="0x1234567812345678123456781234567812345678123456781234567812345678")})
    public void getData(Context ctx) {
        ACell d;
        String hashParam = ctx.pathParam("hash");
        Hash h = Hash.parse((String)hashParam);
        if (h == null) {
            throw new BadRequestResponse(ChainAPI.jsonError("Invalid hash: " + hashParam));
        }
        try {
            d = (ACell)this.convex.acquire(h).get(1000L, TimeUnit.MILLISECONDS);
        }
        catch (ExecutionException e) {
            throw new BadRequestResponse(ChainAPI.jsonError("Missing Data: " + e.getMessage()));
        }
        catch (Exception e) {
            throw new BadRequestResponse(ChainAPI.jsonError("Error: " + e.getMessage()));
        }
        String ds = Utils.print((Object)d);
        ctx.result(ds);
    }

    @OpenApi(path="/api/v1/createAccount", methods={HttpMethod.POST}, operationId="createAccount", tags={"Account"}, summary="Create a new Convex account. Requires a peer winning to accept faucet requests.", requestBody=@OpenApiRequestBody(description="Create Account request, must provide an accountKey for the new Account", content={@OpenApiContent(from=CreateAccountRequest.class, type="application/json", exampleObjects={@OpenApiExampleProperty(name="accountKey", value="d82e78594610f708ad47f666bbacbab1711760652cb88bf7515ed6c3ae84a08d")})}), responses={@OpenApiResponse(status="200", description="Account creation executed", content={@OpenApiContent(type="application/json", from=CreateAccountResponse.class)}), @OpenApiResponse(status="400", description="Bad request, probably a missing or invalid accountKey")})
    public void createAccount(Context ctx) throws InterruptedException {
        Address a;
        this.checkFaucetAllowed();
        Map<String, Object> req = this.getJSONBody(ctx);
        Object key = req.get("accountKey");
        if (key == null) {
            throw new BadRequestResponse(ChainAPI.jsonError("Expected JSON body containing 'accountKey' field"));
        }
        AccountKey pk = AccountKey.parse((Object)key);
        if (pk == null) {
            throw new BadRequestResponse(ChainAPI.jsonError("Unable to parse accountKey: " + String.valueOf(key)));
        }
        Object faucet = req.get("faucet");
        AInteger amt = AInteger.parse((Object)faucet);
        try {
            a = this.convex.createAccountSync(pk);
            if (amt != null) {
                this.convex.transferSync(a, amt.longValue());
            }
        }
        catch (ResultException e) {
            this.prepareResult(ctx, e.getResult());
            return;
        }
        ctx.result("{\"address\": " + a.longValue() + "}");
    }

    @OpenApi(path="/api/v1/accounts/{address}", methods={HttpMethod.GET}, operationId="queryAccount", tags={"Account"}, summary="Get Convex account information", pathParams={@OpenApiParam(name="address", description="Address of Account", required=true, type=String.class, example="14")}, responses={@OpenApiResponse(status="200", description="Account queried sucecssfully", content={@OpenApiContent(from=QueryAccountResponse.class, type="application/json")}), @OpenApiResponse(status="400", description="Bad request, probably an invalid address parameter"), @OpenApiResponse(status="404", description="Account does not exist")})
    public void queryAccount(Context ctx) throws InterruptedException {
        Address addr = null;
        String addrParam = ctx.pathParam("addr");
        addr = Address.parse((String)addrParam);
        if (addr == null) {
            throw new BadRequestResponse(ChainAPI.jsonError("Invalid address: " + addrParam));
        }
        Result r = this.doQuery((ACell)Lists.of((Object[])new Object[]{Symbols.ACCOUNT, addr}));
        if (r.isError()) {
            this.prepareResult(ctx, r);
            return;
        }
        AccountStatus as = (AccountStatus)r.getValue();
        if (as == null) {
            ctx.result("{\"errorCode\": \"NOBODY\",\"value\": \"The Account requested does not exist.\"}");
            ctx.contentType("application/json");
            ctx.status(404);
            return;
        }
        boolean isUser = !as.isActor();
        AccountKey publicKey = as.getAccountKey();
        HashMap<String, Object> hm = new HashMap<String, Object>();
        hm.put("address", addr.longValue());
        hm.put("key", publicKey == null ? null : publicKey.toString());
        hm.put("allowance", as.getMemory());
        hm.put("balance", as.getBalance());
        hm.put("memorySize", as.getMemorySize());
        hm.put("sequence", as.getSequence());
        hm.put("type", isUser ? "user" : "actor");
        ctx.result(JSON.toPrettyString(hm));
    }

    public void queryPeer(Context ctx) throws InterruptedException {
        AccountKey addr = null;
        String addrParam = ctx.pathParam("addr");
        try {
            addr = AccountKey.parse((String)addrParam);
            if (addr == null) {
                throw new BadRequestResponse(ChainAPI.jsonError("Invalid peer key: " + addrParam));
            }
        }
        catch (Exception e) {
            throw new BadRequestResponse(ChainAPI.jsonError("Expected valid peer key in path but got [" + addrParam + "]"));
        }
        Result r = this.doQuery(Reader.read((String)("(get-in *state* [:peers " + String.valueOf(addr) + "])")));
        if (r.isError()) {
            this.prepareResult(ctx, r);
            return;
        }
        PeerStatus as = (PeerStatus)r.getValue();
        if (as == null) {
            throw new NotFoundResponse("Peer does not exist: " + addrParam);
        }
        Object hm = JSON.from((ACell)as);
        ctx.result(JSON.toPrettyString((Object)hm));
    }

    private Result doQuery(ACell form) throws InterruptedException {
        return this.convex.querySync(form);
    }

    private Result doTransaction(SignedData<ATransaction> signedTransaction) {
        try {
            return this.convex.transactSync(signedTransaction);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new InternalServerErrorResponse("Failed to execute transaction: " + String.valueOf(e));
        }
    }

    @OpenApi(path="/api/v1/faucet", methods={HttpMethod.POST}, operationId="faucetRequest", tags={"Account"}, summary="Request coins from a Fucet provider. Requires a peer winning to accept faucet requests.", requestBody=@OpenApiRequestBody(description="Fauncet request, must provide an address for coins to be deposited in", content={@OpenApiContent(from=FaucetRequest.class, type="application/json", exampleObjects={@OpenApiExampleProperty(name="address", value="11"), @OpenApiExampleProperty(name="amount", value="10000000")})}), responses={@OpenApiResponse(status="200", description="Faucet request executed", content={@OpenApiContent(type="application/json", from=CreateAccountResponse.class)}), @OpenApiResponse(status="400", description="Bad request, probably e.g.  missing or invalid recipient address"), @OpenApiResponse(status="422", description="Faucet request failed", content={@OpenApiContent(type="application/json", from=ResultResponse.class)}), @OpenApiResponse(status="403", description="Faucet request forbidden, probably Server is not accepting faucet requests")})
    public void faucetRequest(Context ctx) throws InterruptedException {
        Result r;
        Object o;
        CVMLong l;
        this.checkFaucetAllowed();
        Map<String, Object> req = this.getJSONBody(ctx);
        Address addr = Address.parse((Object)req.get("address"));
        if (addr == null) {
            this.failBadRequest("Expected JSON body containing valid 'address' field");
        }
        if ((l = CVMLong.parse((Object)(o = req.get("amount")))) == null) {
            this.failBadRequest("Faucet requires an 'amount' field containing a long value.");
            return;
        }
        long amt = l.longValue();
        if (amt > 1000000000L) {
            amt = 1000000000L;
        }
        if ((r = this.convex.transactSync("(transfer " + String.valueOf(addr) + " " + amt + ")")).isError()) {
            HashMap hm = r.toJSON();
            ctx.result(JSON.toPrettyString((Object)hm));
            ctx.status(422);
        } else {
            req.put("address", RT.castLong((ACell)addr).longValue());
            req.put("amount", r.getValue());
            ctx.result(JSON.toPrettyString(req));
        }
    }

    protected void failBadRequest(String message) {
        HashMap<String, Object> hm = new HashMap<String, Object>();
        hm.put("errorCode", "FAILED");
        hm.put("value", "message");
        this.failBadRequest(hm);
    }

    protected void failBadRequest(HashMap<String, Object> result) {
        throw new BadRequestResponse(JSON.toPrettyString(result));
    }

    private void checkFaucetAllowed() {
        boolean faucet = this.isFaucetEnabled();
        if (!faucet) {
            throw new ForbiddenResponse("Faucet use not authorised on this server");
        }
    }

    private boolean isFaucetEnabled() {
        return RT.bool((Object)this.restServer.getConfig().get(K_FAUCET));
    }

    @OpenApi(path="/api/v1/transaction/prepare", methods={HttpMethod.POST}, operationId="transactionPrepare", tags={"Transactions"}, summary="Prepare a Convex transaction. If sucessful, will return a hash to be signed.", requestBody=@OpenApiRequestBody(description="Transaction preparation request", content={@OpenApiContent(from=TransactionPrepareRequest.class, type="application/json", exampleObjects={@OpenApiExampleProperty(name="address", value="12"), @OpenApiExampleProperty(name="source", value="(* 2 3)")})}), responses={@OpenApiResponse(status="200", description="Transaction prepared", content={@OpenApiContent(from=TransactionPrepareResponse.class, type="application/json", exampleObjects={@OpenApiExampleProperty(name="sequence", value="14"), @OpenApiExampleProperty(name="address", value="12"), @OpenApiExampleProperty(name="source", value="(* 2 3)"), @OpenApiExampleProperty(name="hash", value="d00c0e81031103110232012a")})}), @OpenApiResponse(status="503", description="Transaction service unavailable")})
    public void runTransactionPrepare(Context ctx) throws InterruptedException, IOException {
        long sequence;
        Map<String, Object> req = this.getJSONBody(ctx);
        Address addr = Address.parse((Object)req.get("address"));
        if (addr == null) {
            throw new BadRequestResponse("Transaction prepare requires a valid 'address' field.");
        }
        Object srcValue = req.get("source");
        ACell code = ChainAPI.readCode(srcValue);
        Object maybeSeq = req.get("sequence");
        try {
            if (maybeSeq != null) {
                CVMLong lv = CVMLong.parse((Object)maybeSeq);
                if (lv == null) {
                    throw new BadRequestResponse("sequence (if provided) must be an integer");
                }
                sequence = lv.longValue();
            } else {
                sequence = this.convex.getSequence(addr) + 1L;
            }
        }
        catch (ResultException e) {
            this.prepareResult(ctx, e.getResult());
            return;
        }
        Invoke trans = Invoke.create((Address)addr, (long)sequence, (ACell)code);
        Ref ref = ((ATransaction)Cells.persist((ACell)trans)).getRef();
        HashMap<String, Object> rmap = new HashMap<String, Object>();
        rmap.put("source", srcValue);
        rmap.put("address", RT.json((ACell)addr));
        rmap.put("hash", SignedData.getMessageForRef((Ref)ref).toHexString());
        rmap.put("sequence", sequence);
        ctx.result(JSON.toPrettyString(rmap));
    }

    @OpenApi(path="/api/v1/transact", methods={HttpMethod.POST}, operationId="transact", tags={"Transactions"}, summary="Execute a Convex transaction. WARNING: sends Ed25519 seed over the network for peer to complete signature.", requestBody=@OpenApiRequestBody(description="Transaction execution request", content={@OpenApiContent(from=TransactRequest.class, type="application/json", exampleObjects={@OpenApiExampleProperty(name="address", value="12"), @OpenApiExampleProperty(name="source", value="(* 2 3)"), @OpenApiExampleProperty(name="seed", value="0x690f51d2eb7163f820fdb861b33d5b077034f09923a2d31946ac199f28639506")})}), responses={@OpenApiResponse(status="200", description="Transaction executed sucessfully", content={@OpenApiContent(from=ResultResponse.class, type="application/json", exampleObjects={@OpenApiExampleProperty(name="value", value="6")})}), @OpenApiResponse(status="422", description="Transaction failed", content={@OpenApiContent(from=ResultResponse.class, type="application/json", exampleObjects={@OpenApiExampleProperty(name="errorCode", value=":NOBODY"), @OpenApiExampleProperty(name="value", value="Account does not exist")})}), @OpenApiResponse(status="503", description="Transaction service unavailable")})
    public void runTransact(Context ctx) throws InterruptedException, IOException {
        long nextSeq;
        Map<String, Object> req = this.getJSONBody(ctx);
        Address addr = Address.parse((Object)req.get("address"));
        if (addr == null) {
            throw new BadRequestResponse("Transact requires a valid address.");
        }
        Object srcValue = req.get("source");
        ACell code = ChainAPI.readCode(srcValue);
        ABlob seed = Blobs.parse((Object)req.get("seed"));
        if (!(seed instanceof ABlob)) {
            throw new BadRequestResponse("Valid Ed25519 seed required for transact (hex string)");
        }
        if (seed.count() != 32L) {
            throw new BadRequestResponse("Seed must be 32 bytes");
        }
        try {
            long sequence = this.convex.getSequence(addr);
            nextSeq = sequence + 1L;
        }
        catch (ResultException e) {
            this.prepareResult(ctx, e.getResult());
            return;
        }
        Invoke trans = Invoke.create((Address)addr, (long)nextSeq, (ACell)code);
        AKeyPair kp = AKeyPair.create((Blob)seed.toFlatBlob());
        SignedData sd = kp.signData((ACell)trans);
        Result r = this.doTransaction((SignedData<ATransaction>)sd);
        this.prepareResult(ctx, r);
    }

    private static ACell readCode(Object srcValue) {
        try {
            return Reader.read((String)((String)srcValue));
        }
        catch (Exception e) {
            throw new BadRequestResponse(ChainAPI.jsonError("Source code could not be read: " + e.getMessage()));
        }
    }

    @OpenApi(path="/api/v1/transaction/submit", methods={HttpMethod.POST}, operationId="transactionSubmit", tags={"Transactions"}, summary="Submit a pre-prepared Convex transaction. If sucessful, will return transaction result.", requestBody=@OpenApiRequestBody(description="Transaction preparation request", content={@OpenApiContent(from=TransactionSubmitRequest.class, type="application/json")}), responses={@OpenApiResponse(status="200", description="Transaction executed", content={@OpenApiContent(from=ResultResponse.class, type="application/json", exampleObjects={@OpenApiExampleProperty(name="value", value="6")})}), @OpenApiResponse(status="503", description="Transaction service unavailable")})
    public void runTransactionSubmit(Context ctx) {
        Map<String, Object> req = this.getJSONBody(ctx);
        Object hashValue = req.get("hash");
        if (!(hashValue instanceof String)) {
            throw new BadRequestResponse("Parameter 'hash' must be provided as a String");
        }
        Blob h = Blob.parse((String)((String)hashValue));
        if (h == null) {
            throw new BadRequestResponse("Parameter 'hash' did not parse correctly, must be a hex string.");
        }
        ATransaction trans = null;
        try {
            Ref ref = Format.readRef((Blob)h, (int)0);
            ACell maybeTrans = ref.getValue();
            if (!(maybeTrans instanceof ATransaction)) {
                throw new BadFormatException("Value with hash " + String.valueOf(h) + " is not a transaction: can't submit it!");
            }
            trans = (ATransaction)maybeTrans;
        }
        catch (MissingDataException e) {
            this.prepareResult(ctx, Result.error((Keyword)ErrorCodes.MISSING, (String)"Missing data for transaction. Possible need to prepare first?"));
            ctx.status(404);
            return;
        }
        catch (BadFormatException e) {
            this.prepareResult(ctx, Result.error((Keyword)ErrorCodes.FORMAT, (String)("Bad format: " + String.valueOf((Object)e))));
            ctx.status(400);
            return;
        }
        Object keyValue = req.get("accountKey");
        if (!(keyValue instanceof String)) {
            throw new BadRequestResponse("Expected JSON body containing 'accountKey' field");
        }
        AccountKey key = AccountKey.parse((Object)keyValue);
        if (key == null) {
            throw new BadRequestResponse("Parameter 'accountKey' did not parse correctly, must be 64 hex characters (32 bytes).");
        }
        Object sigValue = req.get("sig");
        if (!(sigValue instanceof String)) {
            throw new BadRequestResponse("Parameter 'sig' must be provided as a String");
        }
        ABlob sigData = Blobs.parse((Object)sigValue);
        if (sigData == null || sigData.count() != 64L) {
            throw new BadRequestResponse("Parameter 'sig' must be a 64 byte hex String (128 hex chars)");
        }
        ASignature sig = Ed25519Signature.fromBlob((ABlob)sigData);
        SignedData sd = SignedData.create((AccountKey)key, (ASignature)sig, (Ref)trans.getRef());
        Result r = this.doTransaction((SignedData<ATransaction>)sd);
        this.prepareResult(ctx, r);
    }

    @OpenApi(path="/api/v1/query", methods={HttpMethod.POST}, operationId="query", tags={"Transactions"}, summary="Query as Convex account", requestBody=@OpenApiRequestBody(description="Query request", content={@OpenApiContent(from=QueryRequest.class, type="application/json", exampleObjects={@OpenApiExampleProperty(name="address", value="12"), @OpenApiExampleProperty(name="source", value="(* 2 3)")})}), responses={@OpenApiResponse(status="200", description="Query executed", content={@OpenApiContent(from=ResultResponse.class, type="application/json", exampleObjects={@OpenApiExampleProperty(name="value", value="6")})}), @OpenApiResponse(status="422", description="Query failed", content={@OpenApiContent(from=ResultResponse.class, type="application/json", exampleObjects={@OpenApiExampleProperty(name="errorCode", value=":SYNTAX"), @OpenApiExampleProperty(name="value", value="Bad syntax")})}), @OpenApiResponse(status="503", description="Query service unavailable")})
    public void runQuery(Context ctx) throws InterruptedException {
        Map<String, Object> req = this.getJSONBody(ctx);
        Address addr = Address.parse((Object)req.get("address"));
        if (addr == null) {
            throw new BadRequestResponse("query requires an 'address' field.");
        }
        Object srcValue = req.get("source");
        ACell form = ChainAPI.readCode(srcValue);
        Result r = this.convex.querySync(form, addr);
        this.prepareResult(ctx, r);
    }

    private void prepareResult(Context ctx, Result r) {
        HashMap resultJSON = r.toJSON();
        ctx.status(r.isError() ? 422 : 200);
        ctx.result(JSON.toPrettyString((Object)resultJSON));
    }
}

