/*
 * Decompiled with CFR 0.152.
 */
package convex.restapi;

import convex.core.util.Utils;
import convex.restapi.RESTServer;
import io.javalin.Javalin;
import io.javalin.http.Context;
import j2html.TagCreator;
import j2html.tags.DomContent;
import j2html.tags.specialized.HtmlTag;
import j2html.tags.specialized.LinkTag;
import java.util.List;

public class WebApp {
    protected RESTServer server;
    static final List<String[]> LINKS = List.of(WebApp.sa("Open API documentation for this peer: ", "Swagger API", "/swagger"), WebApp.sa("General information at the ", "Convex Website", "https://convex.world"), WebApp.sa("Chat with the community at the ", "Convex Discord Server", "https://discord.com/invite/xfYGq4CT7v"), WebApp.sa("Join the open source development: ", "Convex-Dev", "https://github.com/Convex-Dev"));

    public WebApp(RESTServer restServer) {
        this.server = restServer;
    }

    private void indexPage(Context ctx) {
        HtmlTag content = TagCreator.html((DomContent[])new DomContent[]{this.makeHeader("Convex Peer Server"), TagCreator.body((DomContent[])new DomContent[]{TagCreator.h1((String)"Convex Peer Server"), TagCreator.aside((DomContent[])new DomContent[]{this.makeLinks()}).withStyle("float: right"), TagCreator.p((String)("Version: " + Utils.getVersion())), TagCreator.p((String)"This is the default page for a Convex Peer Server running the REST API")})});
        ctx.result(content.render());
        ctx.header("Content-Type", "text/html");
        ctx.status(200);
    }

    protected void missingPage(Context ctx) {
        HtmlTag content = TagCreator.html((DomContent[])new DomContent[]{this.makeHeader("404: Not Found"), TagCreator.body((DomContent[])new DomContent[]{TagCreator.h1((String)("404: not found: " + ctx.path())), TagCreator.p((String)"This is not the page you are looking for."), TagCreator.a((String)"Go back to index").withHref("/index.html"), this.makeLinks()})});
        ctx.result(content.render());
        ctx.header("Content-Type", "text/html");
        ctx.status(404);
    }

    private DomContent makeLinks() {
        return TagCreator.article((DomContent[])new DomContent[]{TagCreator.h4((String)"Useful links: "), TagCreator.each(LINKS, a -> TagCreator.div((DomContent[])new DomContent[]{TagCreator.join((Object[])new Object[]{a[0], TagCreator.a((String)a[1]).withHref(a[2])})}))});
    }

    private static String[] sa(String ... strings) {
        return strings;
    }

    private DomContent makeHeader(String title) {
        return TagCreator.head((DomContent[])new DomContent[]{TagCreator.title((String)title), ((LinkTag)TagCreator.link().withRel("stylesheet")).withHref("/css/pico.min.css")});
    }

    public void addRoutes(Javalin app) {
        app.get("/index.html", this::indexPage);
        app.get("/", this::indexPage);
        app.get("/404.html", this::missingPage);
    }
}

