/*
 * Decompiled with CFR 0.152.
 */
package convex.restapi.api;

import convex.api.Convex;
import convex.core.Result;
import convex.core.crypto.AKeyPair;
import convex.core.crypto.ASignature;
import convex.core.crypto.Ed25519Signature;
import convex.core.data.ABlob;
import convex.core.data.ACell;
import convex.core.data.AccountKey;
import convex.core.data.AccountStatus;
import convex.core.data.Address;
import convex.core.data.Blob;
import convex.core.data.Blobs;
import convex.core.data.Cells;
import convex.core.data.Format;
import convex.core.data.Hash;
import convex.core.data.Lists;
import convex.core.data.PeerStatus;
import convex.core.data.Ref;
import convex.core.data.SignedData;
import convex.core.data.prim.AInteger;
import convex.core.data.prim.CVMLong;
import convex.core.exceptions.MissingDataException;
import convex.core.lang.RT;
import convex.core.lang.Reader;
import convex.core.lang.Symbols;
import convex.core.transactions.ATransaction;
import convex.core.transactions.Invoke;
import convex.core.util.Utils;
import convex.java.JSON;
import convex.restapi.RESTServer;
import convex.restapi.api.ABaseAPI;
import io.javalin.Javalin;
import io.javalin.http.BadRequestResponse;
import io.javalin.http.Context;
import io.javalin.http.InternalServerErrorResponse;
import io.javalin.http.ServiceUnavailableResponse;
import io.javalin.openapi.HttpMethod;
import io.javalin.openapi.OpenApi;
import io.javalin.openapi.OpenApiContent;
import io.javalin.openapi.OpenApiParam;
import io.javalin.openapi.OpenApiRequestBody;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public class ChainAPI
extends ABaseAPI {
    public Convex convex;
    private static final String ROUTE = "/api/v1/";

    public ChainAPI(RESTServer restServer) {
        super(restServer);
        this.convex = restServer.getConvex();
    }

    @Override
    public void addRoutes(Javalin app) {
        String prefix = ROUTE;
        app.post(prefix + "createAccount", this::createAccount);
        app.post(prefix + "query", this::runQuery);
        app.post(prefix + "faucet", this::faucetRequest);
        app.post(prefix + "transaction/prepare", this::runTransactionPrepare);
        app.post(prefix + "transaction/submit", this::runTransactionSubmit);
        app.post(prefix + "transact", this::runTransact);
        app.get(prefix + "accounts/<addr>", this::queryAccount);
        app.get(prefix + "peers/<addr>", this::queryPeer);
        app.get(prefix + "data/<hash>", this::getData);
    }

    @OpenApi(path="/api/v1/data/{hash}", methods={HttpMethod.POST}, summary="Get data from the server with the specified hash", operationId="data", pathParams={@OpenApiParam(name="hash", description="Data hash as a hex string. Leading '0x' is optional but discouraged.", required=true, type=String.class, example="0x1234567812345678123456781234567812345678123456781234567812345678")})
    public void getData(Context ctx) {
        ACell d;
        String hashParam = ctx.pathParam("hash");
        Hash h = Hash.parse((String)hashParam);
        if (h == null) {
            throw new BadRequestResponse(ChainAPI.jsonError("Invalid hash: " + hashParam));
        }
        try {
            d = (ACell)this.convex.acquire(h).get(1000L, TimeUnit.MILLISECONDS);
        }
        catch (ExecutionException e) {
            throw new BadRequestResponse(ChainAPI.jsonError("Missing Data: " + e.getMessage()));
        }
        catch (Exception e) {
            throw new BadRequestResponse(ChainAPI.jsonError("Error: " + e.getMessage()));
        }
        String ds = Utils.print((Object)d);
        ctx.result(ds);
    }

    @OpenApi(path="/api/v1/createAccount", methods={HttpMethod.POST}, operationId="createAccount", summary="Create a new Convex account", requestBody=@OpenApiRequestBody(description="Complex bodies", content={@OpenApiContent(from=String.class, example="{}")}))
    public void createAccount(Context ctx) {
        Address a;
        Map<String, Object> req = this.getJSONBody(ctx);
        Object key = req.get("accountKey");
        if (key == null) {
            throw new BadRequestResponse(ChainAPI.jsonError("Expected JSON body containing 'accountKey' field"));
        }
        AccountKey pk = AccountKey.parse((Object)key);
        if (pk == null) {
            throw new BadRequestResponse(ChainAPI.jsonError("Unable to parse accountKey: " + String.valueOf(key)));
        }
        Object faucet = req.get("faucet");
        AInteger amt = AInteger.parse((Object)faucet);
        try {
            a = this.convex.createAccountSync(pk);
            if (amt != null) {
                this.convex.transferSync(a, amt.longValue());
            }
        }
        catch (TimeoutException e) {
            throw new ServiceUnavailableResponse(ChainAPI.jsonError("Timeout in request"));
        }
        catch (IOException e) {
            throw new InternalServerErrorResponse(ChainAPI.jsonError(e.getMessage()));
        }
        ctx.result("{\"address\": " + a.longValue() + "}");
    }

    public void queryAccount(Context ctx) {
        Address addr = null;
        String addrParam = ctx.pathParam("addr");
        try {
            long a = Long.parseLong(addrParam);
            addr = Address.create((long)a);
            if (addr == null) {
                throw new BadRequestResponse(ChainAPI.jsonError("Invalid address: " + a));
            }
        }
        catch (Exception e) {
            throw new BadRequestResponse(ChainAPI.jsonError("Expected valid account number in path but got [" + addrParam + "]"));
        }
        Result r = this.doQuery((ACell)Lists.of((Object[])new Object[]{Symbols.ACCOUNT, addr}));
        if (r.isError()) {
            ctx.json(this.jsonForErrorResult(r));
            return;
        }
        AccountStatus as = (AccountStatus)r.getValue();
        if (as == null) {
            ctx.result("{\"errorCode\": \"NOBODY\", \"source\": \"Server\",\"value\": \"The Account requested does not exist.\"}");
            ctx.status(404);
            return;
        }
        boolean isUser = !as.isActor();
        HashMap<String, Object> hm = new HashMap<String, Object>();
        hm.put("address", addr.longValue());
        hm.put("allowance", as.getMemory());
        hm.put("balance", as.getBalance());
        hm.put("memorySize", as.getMemorySize());
        hm.put("sequence", as.getSequence());
        hm.put("type", isUser ? "user" : "actor");
        ctx.result(JSON.toPrettyString(hm));
    }

    public void queryPeer(Context ctx) {
        AccountKey addr = null;
        String addrParam = ctx.pathParam("addr");
        try {
            addr = AccountKey.parse((String)addrParam);
            if (addr == null) {
                throw new BadRequestResponse(ChainAPI.jsonError("Invalid peer key: " + addrParam));
            }
        }
        catch (Exception e) {
            throw new BadRequestResponse(ChainAPI.jsonError("Expected valid peer key in path but got [" + addrParam + "]"));
        }
        Result r = this.doQuery(Reader.read((String)("(get-in *state* [:peers " + String.valueOf(addr) + "])")));
        if (r.isError()) {
            ctx.json(this.jsonForErrorResult(r));
            return;
        }
        PeerStatus as = (PeerStatus)r.getValue();
        if (as == null) {
            ctx.result("{\"errorCode\": \"NOBODY\", \"source\": \"Server\",\"value\": \"The peer requested does not exist.\"}");
            ctx.status(404);
            return;
        }
        Object hm = JSON.from((ACell)as);
        ctx.result(JSON.toPrettyString((Object)hm));
    }

    private Result doQuery(ACell form) {
        try {
            return this.convex.querySync(form);
        }
        catch (TimeoutException e) {
            throw new ServiceUnavailableResponse(ChainAPI.jsonError("Timeout in query request"));
        }
        catch (IOException e) {
            throw new InternalServerErrorResponse(ChainAPI.jsonError("IOException in query request: " + String.valueOf(e)));
        }
        catch (Exception e) {
            throw new InternalServerErrorResponse(ChainAPI.jsonError("Failed to execute query: " + String.valueOf(e)));
        }
    }

    private Result doTransaction(SignedData<ATransaction> signedTransaction) {
        try {
            return this.convex.transactSync(signedTransaction);
        }
        catch (TimeoutException e) {
            throw new ServiceUnavailableResponse(ChainAPI.jsonError("Timeout executing transaction - unable to confirm result."));
        }
        catch (IOException e) {
            throw new InternalServerErrorResponse(ChainAPI.jsonError("IOException in request: " + String.valueOf(e)));
        }
        catch (Exception e) {
            throw new InternalServerErrorResponse(ChainAPI.jsonError("Failed to execute transaction: " + String.valueOf(e)));
        }
    }

    private HashMap<String, Object> jsonResult(Result r) {
        if (r.isError()) {
            return this.jsonForErrorResult(r);
        }
        HashMap<String, Object> hm = new HashMap<String, Object>();
        hm.put("value", RT.json((ACell)r.getValue()));
        return hm;
    }

    private HashMap<String, Object> jsonForErrorResult(Result r) {
        HashMap<String, Object> hm = new HashMap<String, Object>();
        hm.put("errorCode", RT.name((ACell)r.getErrorCode()).toString());
        hm.put("source", "Server");
        hm.put("value", RT.json((ACell)r.getValue()));
        return hm;
    }

    public void faucetRequest(Context ctx) {
        Map<String, Object> req = this.getJSONBody(ctx);
        Address addr = Address.parse((Object)req.get("address"));
        if (addr == null) {
            throw new BadRequestResponse(ChainAPI.jsonError("Expected JSON body containing 'address' field"));
        }
        Object o = req.get("amount");
        CVMLong l = CVMLong.parse((Object)o);
        if (l == null) {
            throw new BadRequestResponse(ChainAPI.jsonError("faucet requires an 'amount' field containing a long value."));
        }
        long amt = l.longValue();
        if (amt > 1000000000L) {
            amt = 1000000000L;
        }
        try {
            Result r = this.convex.transactSync("(transfer " + String.valueOf(addr) + " " + amt + ")");
            if (r.isError()) {
                HashMap<String, Object> hm = this.jsonForErrorResult(r);
                ctx.json(hm);
            } else {
                req.put("amount", r.getValue());
                ctx.result(JSON.toPrettyString(req));
            }
        }
        catch (TimeoutException e) {
            throw new ServiceUnavailableResponse(ChainAPI.jsonError("Timeout in request"));
        }
        catch (IOException e) {
            throw new InternalServerErrorResponse(ChainAPI.jsonError(e.getMessage()));
        }
    }

    public void runTransactionPrepare(Context ctx) {
        Map<String, Object> req = this.getJSONBody(ctx);
        Address addr = Address.parse((Object)req.get("address"));
        if (addr == null) {
            throw new BadRequestResponse(ChainAPI.jsonError("Transaction prepare requires an 'address' field."));
        }
        Object srcValue = req.get("source");
        if (!(srcValue instanceof String)) {
            throw new BadRequestResponse(ChainAPI.jsonError("Source code required for query (as a string)"));
        }
        ACell code = ChainAPI.readCode(srcValue);
        try {
            long sequence = this.convex.getSequence(addr);
            long nextSeq = sequence + 1L;
            Invoke trans = Invoke.create((Address)addr, (long)nextSeq, (ACell)code);
            Ref ref = ((ATransaction)Cells.persist((ACell)trans)).getRef();
            HashMap<String, Object> rmap = new HashMap<String, Object>();
            rmap.put("source", srcValue);
            rmap.put("address", RT.json((ACell)addr));
            rmap.put("hash", RT.json((ACell)SignedData.getMessageForRef((Ref)ref)));
            rmap.put("sequence", sequence);
            ctx.result(JSON.toPrettyString(rmap));
        }
        catch (Exception e) {
            throw new InternalServerErrorResponse(ChainAPI.jsonError("Error preparing transaction: " + e.getMessage()));
        }
    }

    public void runTransact(Context ctx) {
        Map<String, Object> req = this.getJSONBody(ctx);
        if (!req.containsKey("seed") || req.containsKey("sig")) {
            this.runTransactionPrepare(ctx);
            return;
        }
        Address addr = Address.parse((Object)req.get("address"));
        if (addr == null) {
            throw new BadRequestResponse(ChainAPI.jsonError("Transact requires an 'address' field."));
        }
        Object srcValue = req.get("source");
        if (!(srcValue instanceof String)) {
            throw new BadRequestResponse(ChainAPI.jsonError("Source code required for query (as a string)"));
        }
        ABlob seed = Blobs.parse((Object)req.get("seed"));
        if (!(seed instanceof ABlob)) {
            throw new BadRequestResponse(ChainAPI.jsonError("Seed required for transact (e.g. as hex string)"));
        }
        if (seed.count() != 32L) {
            throw new BadRequestResponse(ChainAPI.jsonError("Seed must be 32 bytes"));
        }
        ACell code = ChainAPI.readCode(srcValue);
        try {
            long sequence = this.convex.getSequence(addr);
            long nextSeq = sequence + 1L;
            Invoke trans = Invoke.create((Address)addr, (long)nextSeq, (ACell)code);
            AKeyPair kp = AKeyPair.create((Blob)seed.toFlatBlob());
            SignedData sd = kp.signData((ACell)trans);
            Result r = this.doTransaction((SignedData<ATransaction>)sd);
            HashMap<String, Object> rm = this.jsonResult(r);
            ctx.result(JSON.toPrettyString(rm));
        }
        catch (NullPointerException e) {
            throw new BadRequestResponse(ChainAPI.jsonError("Account does not exist: " + String.valueOf(addr)));
        }
        catch (Exception e) {
            throw new InternalServerErrorResponse(ChainAPI.jsonError("Error preparing transaction: " + e.getMessage()));
        }
    }

    private static ACell readCode(Object srcValue) {
        try {
            return Reader.read((String)((String)srcValue));
        }
        catch (Exception e) {
            throw new BadRequestResponse(ChainAPI.jsonError("Source code could not be read: " + e.getMessage()));
        }
    }

    public void runTransactionSubmit(Context ctx) {
        Map<String, Object> req = this.getJSONBody(ctx);
        Address addr = Address.parse((Object)req.get("address"));
        if (addr == null) {
            throw new BadRequestResponse(ChainAPI.jsonError("query requires an 'address' field."));
        }
        Object hashValue = req.get("hash");
        if (!(hashValue instanceof String)) {
            throw new BadRequestResponse(ChainAPI.jsonError("Parameter 'hash' must be provided as a String"));
        }
        Blob h = Blob.parse((String)((String)hashValue));
        if (h == null) {
            throw new BadRequestResponse(ChainAPI.jsonError("Parameter 'hash' did not parse correctly, must be 64 hex characters."));
        }
        ATransaction trans = null;
        try {
            Ref ref = Format.readRef((Blob)h, (int)0);
            ACell maybeTrans = ref.getValue();
            if (!(maybeTrans instanceof ATransaction)) {
                throw new BadRequestResponse(ChainAPI.jsonError("Value with hash " + String.valueOf(h) + " is not a transaction: can't submit it!"));
            }
            trans = (ATransaction)maybeTrans;
        }
        catch (MissingDataException e) {
            throw new BadRequestResponse(ChainAPI.jsonError("Could not find transaction with hash " + String.valueOf(h) + ": probably you need to call 'prepare' first?"));
        }
        catch (Exception e) {
            throw new BadRequestResponse(ChainAPI.jsonError("Failed to identify transaction with hash " + String.valueOf(h) + ": " + e.getMessage()));
        }
        Object keyValue = req.get("accountKey");
        if (!(keyValue instanceof String)) {
            throw new BadRequestResponse(ChainAPI.jsonError("Expected JSON body containing 'accountKey' field"));
        }
        AccountKey key = AccountKey.parse((Object)keyValue);
        if (key == null) {
            throw new BadRequestResponse(ChainAPI.jsonError("Parameter 'accountKey' did not parse correctly, must be 64 hex characters."));
        }
        Object sigValue = req.get("sig");
        if (!(sigValue instanceof String)) {
            throw new BadRequestResponse(ChainAPI.jsonError("Parameter 'sig' must be provided as a String"));
        }
        ABlob sigData = Blobs.parse((Object)sigValue);
        if (sigData == null || sigData.count() != 64L) {
            throw new BadRequestResponse(ChainAPI.jsonError("Parameter 'sig' must be a 64 byte hex String"));
        }
        ASignature sig = Ed25519Signature.fromBlob((ABlob)sigData);
        SignedData sd = SignedData.create((AccountKey)key, (ASignature)sig, (Ref)trans.getRef());
        Result r = this.doTransaction((SignedData<ATransaction>)sd);
        HashMap<String, Object> rm = this.jsonResult(r);
        ctx.result(JSON.toPrettyString(rm));
    }

    public void runQuery(Context ctx) {
        Map<String, Object> req = this.getJSONBody(ctx);
        Address addr = Address.parse((Object)req.get("address"));
        if (addr == null) {
            throw new BadRequestResponse(ChainAPI.jsonError("query requires an 'address' field."));
        }
        Object srcValue = req.get("source");
        if (!(srcValue instanceof String)) {
            throw new BadRequestResponse(ChainAPI.jsonError("Source code required for query (as a string)"));
        }
        Object cvxRaw = req.get("raw");
        ACell form = ChainAPI.readCode(srcValue);
        try {
            Result r = this.convex.querySync(form, addr);
            HashMap<String, Object> rmap = this.jsonResult(r);
            if (cvxRaw != null) {
                rmap.put("value", RT.toString((ACell)r.getValue()));
            }
            ctx.result(JSON.toString(rmap));
        }
        catch (TimeoutException e) {
            throw new ServiceUnavailableResponse(ChainAPI.jsonError("Timeout in request"));
        }
        catch (IOException e) {
            throw new InternalServerErrorResponse(ChainAPI.jsonError(e.getMessage()));
        }
    }
}

