/*
 * Decompiled with CFR 0.152.
 */
package convex.restapi;

import convex.api.Convex;
import convex.api.ConvexLocal;
import convex.core.Result;
import convex.core.crypto.AKeyPair;
import convex.core.crypto.ASignature;
import convex.core.crypto.Ed25519Signature;
import convex.core.data.ABlob;
import convex.core.data.ACell;
import convex.core.data.AccountKey;
import convex.core.data.AccountStatus;
import convex.core.data.Address;
import convex.core.data.Blobs;
import convex.core.data.Hash;
import convex.core.data.Keyword;
import convex.core.data.Lists;
import convex.core.data.Ref;
import convex.core.data.SignedData;
import convex.core.data.prim.CVMLong;
import convex.core.exceptions.MissingDataException;
import convex.core.lang.RT;
import convex.core.lang.Reader;
import convex.core.lang.Symbols;
import convex.core.transactions.ATransaction;
import convex.core.transactions.Invoke;
import convex.core.util.Utils;
import convex.java.JSON;
import convex.peer.Server;
import io.javalin.Javalin;
import io.javalin.http.BadRequestResponse;
import io.javalin.http.Context;
import io.javalin.http.InternalServerErrorResponse;
import io.javalin.http.ServiceUnavailableResponse;
import io.javalin.http.staticfiles.Location;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public class RESTServer {
    private Server server;
    private Convex convex;
    private Javalin app = Javalin.create((T config) -> {
        config.enableWebjars();
        config.enableCorsForAllOrigins();
        config.addStaticFiles(staticFiles -> {
            staticFiles.hostedPath = "/";
            staticFiles.location = Location.CLASSPATH;
            staticFiles.directory = "/public";
            staticFiles.precompress = false;
            staticFiles.aliasCheck = null;
            staticFiles.skipFileFunction = req -> false;
        });
    });

    private RESTServer() {
        this.app.exception(Exception.class, (e, ctx) -> {
            e.printStackTrace();
            String message = "Unexpected error: " + e;
            ctx.result(message);
            ctx.status(500);
        });
        this.addAPIRoutes();
    }

    private void addAPIRoutes() {
        this.app.post("/api/v1/createAccount", this::createAccount);
        this.app.post("/api/v1/query", this::runQuery);
        this.app.post("/api/v1/faucet", this::faucetRequest);
        this.app.post("/api/v1/transaction/prepare", this::runTransactionPrepare);
        this.app.post("/api/v1/transaction/submit", this::runTransactionSubmit);
        this.app.get("/api/v1/accounts/<addr>", this::queryAccount);
        this.app.get("/api/v1/data/<hash>", this::getData);
    }

    public void getData(Context ctx) {
        ACell d;
        String hashParam = ctx.pathParam("hash");
        Hash h = Hash.parse((String)hashParam);
        if (h == null) {
            throw new BadRequestResponse(RESTServer.jsonError("Invalid hash: " + hashParam));
        }
        try {
            d = (ACell)this.convex.acquire(h).get(1000L, TimeUnit.MILLISECONDS);
        }
        catch (ExecutionException e) {
            throw new BadRequestResponse(RESTServer.jsonError("Missing Data: " + e.getMessage()));
        }
        catch (Exception e) {
            throw new BadRequestResponse(RESTServer.jsonError("Error: " + e.getMessage()));
        }
        String ds = Utils.print((Object)d);
        ctx.result(ds);
    }

    public void createAccount(Context ctx) {
        Address a;
        Map<String, Object> req = this.getJSONBody(ctx);
        Object key = req.get("accountKey");
        if (key == null) {
            throw new BadRequestResponse(RESTServer.jsonError("Expected JSON body containing 'accountKey' field"));
        }
        AccountKey pk = AccountKey.parse((Object)key);
        if (pk == null) {
            throw new BadRequestResponse(RESTServer.jsonError("Unable to parse accountKey: " + key));
        }
        try {
            a = this.convex.createAccountSync(pk);
        }
        catch (TimeoutException e) {
            throw new ServiceUnavailableResponse(RESTServer.jsonError("Timeout in request"));
        }
        catch (IOException e) {
            throw new InternalServerErrorResponse(RESTServer.jsonError(e.getMessage()));
        }
        ctx.result("{\"address\": " + a.longValue() + "}");
    }

    public void queryAccount(Context ctx) {
        Address addr = null;
        String addrParam = ctx.pathParam("addr");
        try {
            long a = Long.parseLong(addrParam);
            addr = Address.create((long)a);
            if (addr == null) {
                throw new BadRequestResponse(RESTServer.jsonError("Invalid address: " + a));
            }
        }
        catch (Exception e) {
            throw new BadRequestResponse(RESTServer.jsonError("Expected valid account number in path but got [" + addrParam + "]"));
        }
        Result r = this.doQuery((ACell)Lists.of((Object[])new Object[]{Symbols.ACCOUNT, addr}));
        if (r.isError()) {
            ctx.json(this.jsonForErrorResult(r));
            return;
        }
        AccountStatus as = (AccountStatus)r.getValue();
        if (as == null) {
            ctx.result("{\"errorCode\": \"NOBODY\", \"source\": \"Server\",\"value\": \"The Account requested does not exist.\"}");
            ctx.status(404);
            return;
        }
        boolean isUser = !as.isActor();
        HashMap<String, Object> hm = new HashMap<String, Object>();
        hm.put("address", addr.toExactLong());
        hm.put("allowance", as.getMemory());
        hm.put("balance", as.getBalance());
        hm.put("memorySize", as.getMemorySize());
        hm.put("sequence", as.getSequence());
        hm.put("type", isUser ? "user" : "actor");
        ctx.result(JSON.toPrettyString(hm));
    }

    private Result doQuery(ACell form) {
        try {
            return this.convex.querySync(form);
        }
        catch (TimeoutException e) {
            throw new ServiceUnavailableResponse(RESTServer.jsonError("Timeout in query request"));
        }
        catch (IOException e) {
            throw new InternalServerErrorResponse(RESTServer.jsonError("IOException in query request: " + e));
        }
        catch (Exception e) {
            throw new InternalServerErrorResponse(RESTServer.jsonError("Failed to execute query: " + e));
        }
    }

    private Result doTransaction(SignedData<ATransaction> signedTransaction) {
        try {
            return this.convex.transactSync(signedTransaction);
        }
        catch (TimeoutException e) {
            throw new ServiceUnavailableResponse(RESTServer.jsonError("Timeout executing transaction - unable to confirm result."));
        }
        catch (IOException e) {
            throw new InternalServerErrorResponse(RESTServer.jsonError("IOException in request: " + e));
        }
        catch (Exception e) {
            throw new InternalServerErrorResponse(RESTServer.jsonError("Failed to execute transaction: " + e));
        }
    }

    private HashMap<String, Object> jsonResult(Result r) {
        if (r.isError()) {
            return this.jsonForErrorResult(r);
        }
        HashMap<String, Object> hm = new HashMap<String, Object>();
        hm.put("value", RT.json((ACell)r.getValue()));
        return hm;
    }

    private HashMap<String, Object> jsonForErrorResult(Result r) {
        HashMap<String, Object> hm = new HashMap<String, Object>();
        hm.put("errorCode", RT.name((ACell)r.getErrorCode()).toString());
        hm.put("source", "Server");
        hm.put("value", RT.json((ACell)r.getValue()));
        return hm;
    }

    public void faucetRequest(Context ctx) {
        Map<String, Object> req = this.getJSONBody(ctx);
        Address addr = Address.parse((Object)req.get("address"));
        if (addr == null) {
            throw new BadRequestResponse(RESTServer.jsonError("Expected JSON body containing 'address' field"));
        }
        Object o = req.get("amount");
        CVMLong l = CVMLong.parse((Object)o);
        if (l == null) {
            throw new BadRequestResponse(RESTServer.jsonError("faucet requires an 'amount' field containing a long value."));
        }
        try {
            Result r = this.convex.transactSync("(transfer " + addr + " " + l + ")");
            if (r.isError()) {
                HashMap<String, Object> hm = this.jsonForErrorResult(r);
                ctx.json(hm);
            } else {
                req.put("amount", r.getValue());
                ctx.result(JSON.toPrettyString(req));
            }
        }
        catch (TimeoutException e) {
            throw new ServiceUnavailableResponse(RESTServer.jsonError("Timeout in request"));
        }
        catch (IOException e) {
            throw new InternalServerErrorResponse(RESTServer.jsonError(e.getMessage()));
        }
    }

    public void runTransactionPrepare(Context ctx) {
        Map<String, Object> req = this.getJSONBody(ctx);
        Address addr = Address.parse((Object)req.get("address"));
        if (addr == null) {
            throw new BadRequestResponse(RESTServer.jsonError("Transaction prepare requires an 'address' field."));
        }
        Object srcValue = req.get("source");
        if (!(srcValue instanceof String)) {
            throw new BadRequestResponse(RESTServer.jsonError("Source code required for query (as a string)"));
        }
        ACell code = null;
        try {
            code = Reader.read((String)((String)srcValue));
        }
        catch (Exception e) {
            throw new BadRequestResponse(RESTServer.jsonError("Source code did not compile: " + e.getMessage()));
        }
        try {
            long sequence = this.convex.getSequence(addr);
            long nextSeq = sequence + 1L;
            Invoke trans = Invoke.create((Address)addr, (long)nextSeq, (ACell)code);
            Ref ref = ACell.createPersisted((ACell)trans);
            HashMap<String, Object> rmap = new HashMap<String, Object>();
            rmap.put("source", srcValue);
            rmap.put("address", RT.json((ACell)addr));
            rmap.put("hash", RT.json((ACell)ref.getHash()));
            rmap.put("sequence", sequence);
            ctx.result(JSON.toPrettyString(rmap));
        }
        catch (Exception e) {
            throw new InternalServerErrorResponse(RESTServer.jsonError("Error preparing transaction: " + e.getMessage()));
        }
    }

    public void runTransactionSubmit(Context ctx) {
        Map<String, Object> req = this.getJSONBody(ctx);
        Address addr = Address.parse((Object)req.get("address"));
        if (addr == null) {
            throw new BadRequestResponse(RESTServer.jsonError("query requires an 'address' field."));
        }
        Object hashValue = req.get("hash");
        if (!(hashValue instanceof String)) {
            throw new BadRequestResponse(RESTServer.jsonError("Parameter 'hash' must be provided as a String"));
        }
        Hash h = Hash.parse((Object)hashValue);
        if (h == null) {
            throw new BadRequestResponse(RESTServer.jsonError("Parameter 'hash' did not parse correctly, must be 64 hex characters."));
        }
        ATransaction trans = null;
        try {
            ACell maybeTrans = Ref.forHash((Hash)h).getValue();
            if (!(maybeTrans instanceof ATransaction)) {
                throw new BadRequestResponse(RESTServer.jsonError("Value with hash " + h + " is not a transaction: can't submit it!"));
            }
            trans = (ATransaction)maybeTrans;
        }
        catch (MissingDataException e) {
            throw new BadRequestResponse(RESTServer.jsonError("Could not find transaction with hash " + h + ": probably you need to call 'prepare' first?"));
        }
        catch (Exception e) {
            throw new BadRequestResponse(RESTServer.jsonError("Failed to identify transaction with hash " + h + ": " + e.getMessage()));
        }
        Object keyValue = req.get("accountKey");
        if (!(keyValue instanceof String)) {
            throw new BadRequestResponse(RESTServer.jsonError("Expected JSON body containing 'accountKey' field"));
        }
        AccountKey key = AccountKey.parse((Object)keyValue);
        if (key == null) {
            throw new BadRequestResponse(RESTServer.jsonError("Parameter 'accountKey' did not parse correctly, must be 64 hex characters."));
        }
        Object sigValue = req.get("sig");
        if (!(sigValue instanceof String)) {
            throw new BadRequestResponse(RESTServer.jsonError("Parameter 'sig' must be provided as a String"));
        }
        ABlob sigData = Blobs.parse((Object)sigValue);
        if (sigData == null || sigData.count() != 64L) {
            throw new BadRequestResponse(RESTServer.jsonError("Parameter 'sig' must be a 64 byte hex String"));
        }
        ASignature sig = Ed25519Signature.fromBlob((ABlob)sigData);
        SignedData sd = SignedData.create((AccountKey)key, (ASignature)sig, (Ref)trans.getRef());
        Result r = this.doTransaction((SignedData<ATransaction>)sd);
        HashMap<String, Object> rm = this.jsonResult(r);
        if (rm == null) {
            throw new InternalServerErrorResponse(RESTServer.jsonError("Couldn't parse Result: " + r));
        }
        ctx.result(JSON.toPrettyString(rm));
    }

    public void runQuery(Context ctx) {
        Map<String, Object> req = this.getJSONBody(ctx);
        Address addr = Address.parse((Object)req.get("address"));
        if (addr == null) {
            throw new BadRequestResponse(RESTServer.jsonError("query requires an 'address' field."));
        }
        Object srcValue = req.get("source");
        if (!(srcValue instanceof String)) {
            throw new BadRequestResponse(RESTServer.jsonError("Source code required for query (as a string)"));
        }
        Object cvxRaw = req.get("raw");
        String src = (String)srcValue;
        ACell form = Reader.read((String)src);
        try {
            Result r = this.convex.querySync(form, addr);
            HashMap<String, Object> rmap = new HashMap<String, Object>();
            Object jsonValue = cvxRaw == null ? RT.json((ACell)r.getValue()) : RT.toString((ACell)r.getValue());
            rmap.put("value", jsonValue);
            ACell ecode = r.getErrorCode();
            if (ecode instanceof Keyword) {
                rmap.put("errorCode", ((Keyword)ecode).getName().toString());
            }
            ctx.result(JSON.toString(rmap));
        }
        catch (TimeoutException e) {
            throw new ServiceUnavailableResponse(RESTServer.jsonError("Timeout in request"));
        }
        catch (IOException e) {
            throw new InternalServerErrorResponse(RESTServer.jsonError(e.getMessage()));
        }
    }

    private Map<String, Object> getJSONBody(Context ctx) {
        try {
            Map req = JSON.toMap((String)ctx.body());
            return req;
        }
        catch (Exception e) {
            throw new BadRequestResponse(RESTServer.jsonError("Invalid JSON body"));
        }
    }

    private static String jsonError(String string) {
        return "{\"error\":\"" + string + "\"}";
    }

    public static RESTServer create(Server server) {
        RESTServer newServer = new RESTServer();
        newServer.server = server;
        newServer.convex = ConvexLocal.create((Server)server, (Address)server.getPeerController(), (AKeyPair)server.getKeyPair());
        return newServer;
    }

    public static RESTServer create(Convex convex) {
        RESTServer newServer = new RESTServer();
        newServer.convex = convex;
        return newServer;
    }

    public void start() {
        this.app.start();
    }

    public void start(int port) {
        this.app.start(port);
    }

    public void stop() {
        this.app.close();
    }

    public Convex getConvex() {
        return this.convex;
    }

    public Server getServer() {
        return this.server;
    }

    public int getPort() {
        return this.app.port();
    }
}

