/*
 * Decompiled with CFR 0.152.
 */
package convex.peer;

import convex.core.ErrorCodes;
import convex.core.Result;
import convex.core.SourceCodes;
import convex.core.cpos.Block;
import convex.core.cpos.BlockResult;
import convex.core.cvm.AccountStatus;
import convex.core.cvm.Address;
import convex.core.cvm.Keywords;
import convex.core.cvm.Peer;
import convex.core.cvm.PeerStatus;
import convex.core.cvm.State;
import convex.core.cvm.transactions.ATransaction;
import convex.core.cvm.transactions.Invoke;
import convex.core.data.ABlobLike;
import convex.core.data.ACell;
import convex.core.data.AString;
import convex.core.data.AVector;
import convex.core.data.AccountKey;
import convex.core.data.Cells;
import convex.core.data.Hash;
import convex.core.data.Keyword;
import convex.core.data.SignedData;
import convex.core.data.Strings;
import convex.core.data.Vectors;
import convex.core.data.prim.CVMLong;
import convex.core.exceptions.BadFormatException;
import convex.core.exceptions.MissingDataException;
import convex.core.lang.Reader;
import convex.core.message.Message;
import convex.core.util.LoadMonitor;
import convex.core.util.Utils;
import convex.peer.AThreadedComponent;
import convex.peer.Server;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TransactionHandler
extends AThreadedComponent {
    static final Logger log = LoggerFactory.getLogger((String)TransactionHandler.class.getName());
    private static final long OWN_BLOCK_DELAY = 10000L;
    private static final long DEFAULT_MIN_BLOCK_TIME = 10L;
    protected final ArrayBlockingQueue<Message> txMessageQueue;
    ArrayBlockingQueue<SignedData<ATransaction>> transactionQueue;
    private HashMap<Hash, Message> interests = new HashMap();
    public long clientTransactionCount = 0L;
    public long receivedTransactionCount = 0L;
    private Consumer<SignedData<ATransaction>> requestObserver;
    private static final Result ERR_NOT_LIVE = Result.error((Keyword)ErrorCodes.STATE, (AString)Strings.create((String)"Server is not live")).withSource(SourceCodes.PEER);
    private static final Result ERR_NOT_REGISTERED = Result.error((Keyword)ErrorCodes.STATE, (AString)Strings.create((String)"Peer not registered in global state")).withSource(SourceCodes.PEER);
    private static final Result ERR_NOT_STAKED = Result.error((Keyword)ErrorCodes.STATE, (AString)Strings.create((String)"Peer not sufficiently staked to publish transactions")).withSource(SourceCodes.PEER);
    long reportedConsensusPoint;
    private BiConsumer<SignedData<ATransaction>, Result> responseObserver;
    Long minBlockTime = null;
    private ArrayList<SignedData<ATransaction>> newTransactions = new ArrayList();
    private long lastOwnTransactionTimestamp = 0L;
    protected long lastBlockPublishedTime = 0L;
    ArrayList<Message> messages = new ArrayList();

    public TransactionHandler(Server server) {
        super(server);
        this.txMessageQueue = new ArrayBlockingQueue(10000);
        this.transactionQueue = new ArrayBlockingQueue(10000);
    }

    public boolean offerTransaction(Message m) {
        return this.txMessageQueue.offer(m);
    }

    private void registerInterest(Hash signedTransactionHash, Message m) {
        this.interests.put(signedTransactionHash, m);
    }

    private Result checkPeerState() {
        try {
            if (!this.server.isLive()) {
                return ERR_NOT_LIVE;
            }
            Peer p = this.server.getPeer();
            State s = p.getConsensusState();
            PeerStatus ps = (PeerStatus)s.getPeers().get((ABlobLike)p.getPeerKey());
            if (ps == null) {
                return ERR_NOT_REGISTERED;
            }
            if (ps.getBalance() < 1000000000000L) {
                return ERR_NOT_STAKED;
            }
            return null;
        }
        catch (Exception e) {
            return Result.error((Keyword)ErrorCodes.STATE, (AString)Strings.create((String)("Peer problem: " + e.getMessage()))).withSource(SourceCodes.PEER);
        }
    }

    private void processMessages() throws InterruptedException {
        Result problem = this.checkPeerState();
        for (Message msg : this.messages) {
            if (problem == null) {
                this.processMessage(msg);
                continue;
            }
            msg.returnResult(problem);
        }
    }

    protected void processMessage(Message m) throws InterruptedException {
        try {
            ++this.receivedTransactionCount;
            AVector v = (AVector)m.getPayload();
            SignedData sd = (SignedData)v.get(2);
            Result error = this.server.getPeer().checkTransaction(sd);
            if (error != null) {
                m.returnResult(error.withSource(SourceCodes.PEER));
                return;
            }
            LoadMonitor.down();
            this.transactionQueue.put((SignedData<ATransaction>)sd);
            this.observeTransactionRequest((SignedData<ATransaction>)sd);
            LoadMonitor.up();
            ++this.clientTransactionCount;
            this.registerInterest(sd.getHash(), m);
        }
        catch (BadFormatException e) {
            log.warn("Unhandled exception in transaction handler", (Throwable)e);
            m.closeConnection();
        }
        catch (MissingDataException e) {
            m.returnResult(Result.fromException((Throwable)e).withSource(SourceCodes.PEER));
            return;
        }
    }

    public void setRequestObserver(Consumer<SignedData<ATransaction>> observer) {
        this.requestObserver = observer;
    }

    private void observeTransactionRequest(SignedData<ATransaction> sd) {
        Consumer<SignedData<ATransaction>> observer = this.requestObserver;
        if (observer != null) {
            observer.accept(sd);
        }
    }

    public void maybeReportTransactions(Peer peer) {
        long newConsensusPoint = peer.getFinalityPoint();
        if (newConsensusPoint > this.reportedConsensusPoint) {
            log.debug("Consensus point update from {} to {}", (Object)this.reportedConsensusPoint, (Object)newConsensusPoint);
            for (long i = this.reportedConsensusPoint; i < newConsensusPoint; ++i) {
                SignedData block = peer.getPeerOrder().getBlock(i);
                if (!block.getAccountKey().equals(peer.getPeerKey())) continue;
                BlockResult br = peer.getBlockResult(i);
                this.reportTransactions((Block)block.getValue(), br, i);
            }
            this.reportedConsensusPoint = newConsensusPoint;
        }
    }

    private void reportTransactions(Block block, BlockResult br, long blockNum) {
        int nTrans = block.length();
        HashMap<Keyword, Object> extInfo = new HashMap<Keyword, Object>(5);
        for (long j = 0L; j < (long)nTrans; ++j) {
            SignedData t = (SignedData)block.getTransactions().get(j);
            Hash h = t.getHash();
            Message m = this.interests.get(h);
            if (m == null) continue;
            Result res = null;
            try {
                res = (Result)br.getResults().get(j);
                extInfo.put(Keywords.LOC, Vectors.createLongs((long[])new long[]{blockNum, j}));
                extInfo.put(Keywords.TX, t.getHash());
                res = res.withExtraInfo(extInfo);
            }
            catch (Exception e) {
                res = Result.error((Keyword)ErrorCodes.FATAL, (String)"Failed to produce result").withSource(SourceCodes.PEER);
            }
            boolean reported = m.returnResult(res);
            if (!reported) {
                // empty if block
            }
            this.observeTransactionResponse((SignedData<ATransaction>)t, res);
            this.interests.remove(h);
        }
    }

    public void setResponseObserver(BiConsumer<SignedData<ATransaction>, Result> observer) {
        this.responseObserver = observer;
    }

    private void observeTransactionResponse(SignedData<ATransaction> sd, Result r) {
        BiConsumer<SignedData<ATransaction>, Result> observer = this.responseObserver;
        if (observer != null) {
            observer.accept(sd, r);
        }
    }

    protected SignedData<Block>[] maybeGenerateBlocks() {
        Peer peer = this.server.getPeer();
        long timestamp = Utils.getCurrentTimestamp();
        if (!peer.isReadyToPublish()) {
            return null;
        }
        long minBlockTime = this.getMinBlockTime();
        if (timestamp < this.lastBlockPublishedTime + minBlockTime) {
            return null;
        }
        this.maybeGetOwnTransactions(peer);
        this.transactionQueue.drainTo(this.newTransactions);
        if (this.newTransactions.isEmpty()) {
            return null;
        }
        int ntrans = this.newTransactions.size();
        int bsize = 1024;
        int nblocks = (ntrans - 1) / bsize + 1;
        SignedData[] signedBlocks = new SignedData[nblocks];
        for (int i = 0; i < nblocks; ++i) {
            int start = i * bsize;
            int end = Math.min(ntrans, (i + 1) * bsize);
            Block block = Block.create((long)timestamp, this.newTransactions.subList(start, end));
            SignedData signedBlock = peer.getKeyPair().signData((ACell)block);
            try {
                signedBlock = (SignedData)Cells.persist((ACell)signedBlock);
            }
            catch (Exception e) {
                log.warn("Exception preparing new block", (Throwable)e);
                return null;
            }
            signedBlocks[i] = signedBlock;
        }
        this.newTransactions.clear();
        this.lastBlockPublishedTime = timestamp;
        return signedBlocks;
    }

    private long getMinBlockTime() {
        if (this.minBlockTime == null) {
            HashMap<Keyword, Object> config = this.server.getConfig();
            CVMLong mbt = CVMLong.parse((Object)config.get(Keywords.MIN_BLOCK_TIME));
            this.minBlockTime = mbt == null ? 10L : mbt.longValue();
        }
        return this.minBlockTime;
    }

    void maybeGetOwnTransactions(Peer p) {
        AccountStatus as;
        Address address;
        AccountKey peerKey;
        long ts = Utils.getCurrentTimestamp();
        if (ts < this.lastOwnTransactionTimestamp + 10000L) {
            return;
        }
        if (!Utils.bool((Object)this.server.getConfig().get(Keywords.AUTO_MANAGE))) {
            return;
        }
        if (!p.isReadyToPublish()) {
            return;
        }
        State s = p.getConsensusState();
        PeerStatus ps = s.getPeer(peerKey = p.getPeerKey());
        if (ps == null) {
            return;
        }
        AString chn = ps.getHostname();
        String currentHostname = chn == null ? null : chn.toString();
        String desiredHostname = this.server.getHostname();
        if (desiredHostname != null && !Utils.equals((Object)desiredHostname, (Object)currentHostname) && (address = ps.getController()) != null && (as = s.getAccount(address)) != null && Cells.equals((ACell)peerKey, (ACell)as.getAccountKey())) {
            log.info("Trying to update own hostname from: {} to {}", (Object)currentHostname, (Object)desiredHostname);
            String code = String.format("(set-peer-data %s {:url \"%s\"})", peerKey, desiredHostname);
            ACell message = Reader.read((String)code);
            Invoke transaction = Invoke.create((Address)address, (long)(as.getSequence() + 1L), (ACell)message);
            this.newTransactions.add((SignedData<ATransaction>)p.getKeyPair().signData((ACell)transaction));
            this.lastOwnTransactionTimestamp = ts;
        }
    }

    @Override
    public void start() {
        this.reportedConsensusPoint = this.server.getPeer().getFinalityPoint();
        super.start();
    }

    public boolean isAwaitingResults() {
        return this.interests.size() > 0;
    }

    public int countInterests() {
        return this.interests.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void loop() throws InterruptedException {
        long BLOCKTIME = this.getMinBlockTime();
        try {
            LoadMonitor.down();
            Message m = this.txMessageQueue.poll(BLOCKTIME, TimeUnit.MILLISECONDS);
            LoadMonitor.up();
            if (m == null) {
                return;
            }
            LoadMonitor.down();
            Thread.sleep(1L);
            LoadMonitor.up();
            this.messages.add(m);
            this.txMessageQueue.drainTo(this.messages);
            this.processMessages();
        }
        finally {
            this.messages.clear();
        }
    }

    @Override
    protected String getThreadName() {
        return "Transaction handler on port: " + this.server.getPort();
    }
}

