/*
 * Decompiled with CFR 0.152.
 */
package convex.peer;

import convex.api.Convex;
import convex.api.ConvexRemote;
import convex.core.Result;
import convex.core.cpos.Belief;
import convex.core.cvm.Keywords;
import convex.core.cvm.Peer;
import convex.core.cvm.PeerStatus;
import convex.core.cvm.State;
import convex.core.data.ABlobLike;
import convex.core.data.ACell;
import convex.core.data.AMap;
import convex.core.data.AString;
import convex.core.data.AVector;
import convex.core.data.AccountKey;
import convex.core.data.Hash;
import convex.core.data.Keyword;
import convex.core.data.SignedData;
import convex.core.data.Vectors;
import convex.core.exceptions.BadFormatException;
import convex.core.exceptions.MissingDataException;
import convex.core.lang.RT;
import convex.core.message.Message;
import convex.core.util.LoadMonitor;
import convex.core.util.Utils;
import convex.net.AConnection;
import convex.net.ChallengeRequest;
import convex.net.IPUtils;
import convex.peer.API;
import convex.peer.AThreadedComponent;
import convex.peer.Config;
import convex.peer.Server;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.channels.UnresolvedAddressException;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConnectionManager
extends AThreadedComponent {
    private static final Logger log = LoggerFactory.getLogger((String)ConnectionManager.class.getName());
    static final long SERVER_CONNECTION_PAUSE = 500L;
    static final long SERVER_POLL_DELAY = 2000L;
    static final long POLL_TIMEOUT_MILLIS = 2000L;
    static final long POLL_ACQUIRE_TIMEOUT_MILLIS = 12000L;
    private final HashMap<AccountKey, Convex> connections = new HashMap();
    private HashMap<AccountKey, ChallengeRequest> challengeList = new HashMap();
    private SecureRandom random = new SecureRandom();
    private long pollDelay;
    private long lastConnectionUpdate = Utils.getCurrentTimestamp();

    private void maybePollBelief() throws InterruptedException {
        block7: {
            try {
                long lastConsensus = this.server.getPeer().getConsensusState().getTimestamp().longValue();
                if (lastConsensus + this.pollDelay >= Utils.getCurrentTimestamp()) {
                    return;
                }
                ArrayList<Convex> conns = new ArrayList<Convex>(this.connections.values());
                if (conns.size() == 0) {
                    return;
                }
                Convex c = conns.get(this.random.nextInt(conns.size()));
                if (!c.isConnected()) {
                    log.warn("Attempted to poll from closed connection");
                    return;
                }
                Convex convex = c;
                Result result = convex.requestStatusSync(2000L);
                if (result.isError()) {
                    log.warn("Failure requesting status during polling: " + String.valueOf(result));
                    return;
                }
                AMap<Keyword, ACell> status = API.ensureStatusMap(result.getValue());
                if (status == null) {
                    log.warn("Dubious status response message: " + String.valueOf(result));
                    return;
                }
                Hash h = RT.ensureHash((ACell)status.get((ACell)Keywords.BELIEF));
                Belief sb = (Belief)convex.acquire(h).get(12000L, TimeUnit.MILLISECONDS);
                this.server.queueBelief(Message.createBelief((Belief)sb));
            }
            catch (Exception t) {
                if (!this.server.isLive()) break block7;
                log.warn("Belief Polling failed: {}", (Object)(t.getClass().toString() + " : " + t.getMessage()));
            }
        }
    }

    protected void maintainConnections() throws InterruptedException {
        AccountKey[] peers;
        State s = this.server.getPeer().getConsensusState();
        long now = Utils.getCurrentTimestamp();
        long millisSinceLastUpdate = Math.max(0L, now - this.lastConnectionUpdate);
        int targetPeerCount = this.getTargetPeerCount();
        int currentPeerCount = this.connections.size();
        double totalStake = (Double)s.computeStakes().get(null);
        for (AccountKey p : peers = this.connections.keySet().toArray(new AccountKey[currentPeerCount])) {
            double prop;
            double keepChance;
            Convex conn = this.getConnection(p);
            if (conn == null) {
                --currentPeerCount;
                continue;
            }
            PeerStatus ps = s.getPeer(p);
            if (ps == null || ps.getBalance() <= 1000000000000L) {
                this.closeConnection(p, "Insufficient stake");
                --currentPeerCount;
                continue;
            }
            if (millisSinceLastUpdate <= 0L || currentPeerCount < targetPeerCount || !((keepChance = Math.min(1.0, (prop = (double)ps.getTotalStake() / totalStake) * (double)targetPeerCount)) < 1.0)) continue;
            double dropRate = (double)millisSinceLastUpdate / 20000.0;
            if (!(this.random.nextDouble() < dropRate * (1.0 - keepChance))) continue;
            this.closeConnection(p, "Dropping minor peers");
            --currentPeerCount;
        }
        currentPeerCount = this.connections.size();
        if (currentPeerCount < targetPeerCount) {
            this.tryRandomConnect(s);
        }
        this.lastConnectionUpdate = Utils.getCurrentTimestamp();
    }

    private void tryRandomConnect(State s) throws InterruptedException {
        Set potentialPeers = s.getPeers().keySet();
        InetSocketAddress target = null;
        double accStake = 0.0;
        for (ACell c : potentialPeers) {
            long peerStake;
            InetSocketAddress maybeAddress;
            AString hostName;
            PeerStatus ps;
            AccountKey peerKey = RT.ensureAccountKey((ACell)c);
            if (this.connections.containsKey(peerKey) || this.server.getPeerKey().equals(peerKey) || (ps = (PeerStatus)s.getPeers().get((ABlobLike)peerKey)) == null || (hostName = ps.getHostname()) == null || (maybeAddress = IPUtils.toInetSocketAddress(hostName.toString())) == null || (peerStake = ps.getPeerStake()) <= 1000000000000L) continue;
            double t = this.random.nextDouble() * (accStake + (double)peerStake);
            if (t >= accStake) {
                target = maybeAddress;
            }
            accStake += (double)peerStake;
        }
        if (target != null) {
            try {
                this.connectToPeer(target);
            }
            catch (IOException | TimeoutException e) {
                log.debug("Failed to connect to Peer at " + String.valueOf(target), (Throwable)e);
            }
        }
    }

    private int getTargetPeerCount() {
        Integer target;
        try {
            target = Utils.toInt((Object)this.server.getConfig().get(Keywords.OUTGOING_CONNECTIONS));
        }
        catch (IllegalArgumentException ex) {
            target = null;
        }
        if (target == null) {
            target = Config.DEFAULT_OUTGOING_CONNECTION_COUNT;
        }
        return target;
    }

    public ConnectionManager(Server server) {
        super(server);
    }

    public void closeConnection(AccountKey peerKey, String reason) {
        Convex conn = this.connections.get(peerKey);
        if (conn != null) {
            log.info("Removed peer connection to " + String.valueOf(peerKey) + " Reason=" + reason);
            conn.close();
            this.connections.remove(peerKey);
        }
    }

    public void closeAllConnections() {
        HashMap<AccountKey, Convex> conns = new HashMap<AccountKey, Convex>(this.getConnections());
        for (AccountKey peerKey : conns.keySet()) {
            this.closeConnection(peerKey, "Closing all connections");
        }
        this.connections.clear();
    }

    public HashMap<AccountKey, Convex> getConnections() {
        return this.connections;
    }

    public boolean isConnected(AccountKey peerKey) {
        return this.connections.containsKey(peerKey);
    }

    public Convex getConnection(AccountKey peerKey) {
        Convex c = this.connections.get(peerKey);
        if (c == null) {
            return null;
        }
        if (!c.isConnected()) {
            this.closeConnection(peerKey, "Removing already closed connection");
            return null;
        }
        return c;
    }

    public int getConnectionCount() {
        return this.connections.size();
    }

    public void processChallenge(Message m, Peer thisPeer) {
        SignedData signedData = null;
        try {
            signedData = (SignedData)m.getPayload();
            if (signedData == null) {
                throw new BadFormatException("null challenge?");
            }
        }
        catch (BadFormatException e) {
            this.alertBadMessage(m, "Bad format in challenge");
            return;
        }
        AVector challengeValues = (AVector)signedData.getValue();
        if (challengeValues == null || challengeValues.size() != 3) {
            log.debug("challenge data incorrect number of items should be 3 not ", (Object)RT.count((ACell)challengeValues));
            return;
        }
        Hash token = RT.ensureHash((ACell)challengeValues.get(0));
        if (token == null) {
            log.warn("no challenge token provided");
            return;
        }
        Hash networkId = RT.ensureHash((ACell)challengeValues.get(1));
        if (networkId == null) {
            log.warn("challenge data has no networkId");
            return;
        }
        if (!networkId.equals(thisPeer.getNetworkID())) {
            log.warn("challenge data has incorrect networkId");
            return;
        }
        AccountKey toPeer = RT.ensureAccountKey((ACell)challengeValues.get(2));
        if (toPeer == null) {
            log.warn("challenge data has no toPeer address");
            return;
        }
        if (!toPeer.equals(thisPeer.getPeerKey())) {
            log.warn("challenge data has incorrect addressed peer");
            return;
        }
        AccountKey fromPeer = signedData.getAccountKey();
        AVector responseValues = Vectors.of((Object[])new Object[]{token, thisPeer.getNetworkID(), fromPeer, signedData.getHash()});
        SignedData response = thisPeer.sign((ACell)responseValues);
        Message resp = Message.createResponse((SignedData)response);
        m.returnMessage(resp);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    AccountKey processResponse(Message m, Peer thisPeer) {
        SignedData signedData;
        try {
            signedData = (SignedData)m.getPayload();
        }
        catch (BadFormatException e) {
            return null;
        }
        log.debug("Processing response request");
        AVector responseValues = (AVector)signedData.getValue();
        if (responseValues.size() != 4) {
            log.warn("response data incorrect number of items should be 4 not {}", (Object)responseValues.size());
            return null;
        }
        Hash token = RT.ensureHash((ACell)responseValues.get(0));
        if (token == null) {
            log.warn("no response token provided");
            return null;
        }
        Hash networkId = RT.ensureHash((ACell)responseValues.get(1));
        if (networkId == null || !networkId.equals(thisPeer.getNetworkID())) {
            log.warn("response data has incorrect networkId");
            return null;
        }
        AccountKey toPeer = RT.ensureAccountKey((ACell)responseValues.get(2));
        if (toPeer == null || !toPeer.equals(thisPeer.getPeerKey())) {
            log.warn("response data has incorrect addressed peer");
            return null;
        }
        Hash challengeHash = RT.ensureHash((ACell)responseValues.get(3));
        AccountKey fromPeer = signedData.getAccountKey();
        if (!this.challengeList.containsKey(fromPeer)) {
            log.warn("response from an unkown challenge");
            return null;
        }
        HashMap<AccountKey, ChallengeRequest> hashMap = this.challengeList;
        synchronized (hashMap) {
            ChallengeRequest challengeRequest = this.challengeList.get(fromPeer);
            Hash challengeToken = challengeRequest.getToken();
            if (!challengeToken.equals(token)) {
                log.warn("invalid response token sent");
                return null;
            }
            AccountKey challengeFromPeer = challengeRequest.getPeerKey();
            if (!signedData.getAccountKey().equals(challengeFromPeer)) {
                log.warn("response key does not match requested key, sent from a different peer");
                return null;
            }
            Hash challengeSourceHash = challengeRequest.getSendHash();
            if (!challengeHash.equals(challengeSourceHash)) {
                log.warn("response hash of the challenge does not match");
                return null;
            }
            this.challengeList.remove(fromPeer);
            Convex connection = this.getConnection(fromPeer);
            if (connection != null) {
                // empty if block
            }
            return fromPeer;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void requestChallenge(AccountKey toPeerKey, AConnection connection, Peer thisPeer) {
        HashMap<AccountKey, ChallengeRequest> hashMap = this.challengeList;
        synchronized (hashMap) {
            ChallengeRequest request;
            if (connection.isTrusted()) {
                return;
            }
            if (this.challengeList.containsKey(toPeerKey)) {
                if (!this.challengeList.get(toPeerKey).isTimedout()) {
                    return;
                }
                this.challengeList.remove(toPeerKey);
            }
            if ((request = ChallengeRequest.create(toPeerKey)).send(connection, thisPeer)) {
                this.challengeList.put(toPeerKey, request);
            }
        }
    }

    public void broadcast(Message msg) {
        HashMap<AccountKey, Convex> hm = this.getCurrentConnections();
        if (hm.isEmpty()) {
            log.debug("No connections to broadcast to from " + String.valueOf(this.server.getPeerKey()));
            return;
        }
        ArrayList<Map.Entry<AccountKey, Convex>> left = new ArrayList<Map.Entry<AccountKey, Convex>>(hm.entrySet());
        Utils.shuffle(left);
        for (Map.Entry<AccountKey, Convex> me : left) {
            Result r;
            Convex pc = me.getValue();
            CompletableFuture<Result> sent = pc.message(msg);
            if (sent.isDone() && !(r = sent.join()).isError()) continue;
        }
    }

    private synchronized HashMap<AccountKey, Convex> getCurrentConnections() {
        HashMap<AccountKey, Convex> liveConnections = new HashMap<AccountKey, Convex>();
        for (Map.Entry<AccountKey, Convex> me : this.connections.entrySet()) {
            AccountKey peerKey = me.getKey();
            Convex c = me.getValue();
            if (c == null || !c.isConnected()) continue;
            liveConnections.put(peerKey, c);
        }
        return liveConnections;
    }

    public Convex connectToPeer(InetSocketAddress hostAddress) throws InterruptedException, IOException, TimeoutException {
        try {
            ConvexRemote convex = Convex.connect(hostAddress);
            Result result = convex.requestStatusSync(8000L);
            if (result.isError()) {
                log.info("Bad status message from remote Peer: " + String.valueOf(result));
                ((Convex)convex).close();
                return null;
            }
            log.debug("Got status from peer: " + String.valueOf(result));
            ACell statusValue = result.getValue();
            AMap<Keyword, ACell> status = API.ensureStatusMap(statusValue);
            AccountKey peerKey = RT.ensureAccountKey((ACell)status.get((ACell)Keywords.PEER));
            if (peerKey == null) {
                return null;
            }
            Convex existing = this.getConnection(peerKey);
            if (existing != null && existing.isConnected()) {
                log.info("Trying to connect with existing connection");
                ((Convex)convex).close();
                return existing;
            }
            this.addConnection(peerKey, convex);
            return convex;
        }
        catch (UnresolvedAddressException e) {
            log.info("Unable to resolve host address: " + String.valueOf(hostAddress));
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void addConnection(AccountKey peerKey, Convex convex) {
        HashMap<AccountKey, Convex> hashMap = this.connections;
        synchronized (hashMap) {
            log.debug("Connected to Peer: " + String.valueOf(peerKey) + " at " + String.valueOf(convex.getHostAddress()));
            this.connections.put(peerKey, convex);
        }
    }

    @Override
    public void close() {
        try {
            Message msg = Message.createGoodBye();
            this.broadcast(msg);
        }
        finally {
            super.close();
        }
    }

    @Override
    public void start() {
        Object _pollDelay = this.server.getConfig().get(Keywords.POLL_DELAY);
        this.pollDelay = _pollDelay == null ? 2000L : (long)Utils.toInt((Object)_pollDelay);
        super.start();
    }

    @Override
    protected void loop() throws InterruptedException {
        LoadMonitor.down();
        Thread.sleep(500L);
        LoadMonitor.up();
        this.maintainConnections();
        this.maybePollBelief();
    }

    @Override
    protected String getThreadName() {
        return "Connection Manager thread at " + this.server.getPort();
    }

    public void alertBadMessage(Message m, String reason) {
        log.warn(reason);
    }

    public void alertMissing(Message m, MissingDataException e, AccountKey peerKey) {
        try {
            Convex conn = this.getConnection(peerKey);
            if (conn == null) {
                return;
            }
            if (log.isDebugEnabled()) {
                String message = "Missing data alert " + String.valueOf(e.getMissingHash());
                log.info(message);
            }
        }
        catch (Exception ex) {
            log.warn("Unexpected error responding to missing data", (Throwable)ex);
        }
    }
}

