/*
 * Decompiled with CFR 0.152.
 */
package convex.peer;

import convex.core.crypto.AKeyPair;
import convex.core.crypto.PFXTools;
import convex.core.cvm.Keywords;
import convex.core.data.AString;
import convex.core.data.Keyword;
import convex.core.store.AStore;
import convex.core.util.FileUtils;
import convex.core.util.Utils;
import convex.etch.EtchStore;
import convex.peer.ConfigException;
import java.io.File;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.util.HashMap;
import java.util.Map;

public class Config {
    public static final int SOCKET_SERVER_BUFFER_SIZE = 0x100000;
    public static final int SOCKET_PEER_BUFFER_SIZE = 0x100000;
    public static final int SOCKET_RECEIVE_BUFFER_SIZE = 65536;
    public static final int SOCKET_SEND_BUFFER_SIZE = 131072;
    public static final boolean USE_NETTY_CLIENT = true;
    public static final boolean USE_NETTY_SERVER = true;
    public static final long MAX_REBROADCAST_DELAY = 200L;
    public static final long PEER_SYNC_TIMEOUT = 60000L;
    public static final double PEER_CONNECTION_DROP_TIME = 20000.0;
    public static final Integer DEFAULT_OUTGOING_CONNECTION_COUNT = 10;
    public static final long STATUS_COUNT = 9L;
    public static final int TRANSACTION_QUEUE_SIZE = 10000;
    public static final int QUERY_QUEUE_SIZE = 10000;
    public static final long DEFAULT_CLIENT_TIMEOUT = 8000L;
    public static final int BELIEF_QUEUE_SIZE = 200;

    public static <T extends AStore> T checkStore(Map<Keyword, Object> config) throws IOException {
        Object o = config.get(Keywords.STORE);
        if (o instanceof AStore) {
            return (T)((AStore)o);
        }
        if (o instanceof String || o instanceof AString) {
            String fname = o.toString();
            if ("temp".equals(fname)) {
                return (T)EtchStore.createTemp();
            }
            File f = FileUtils.getFile((String)fname);
            if (f.exists()) {
                try {
                    return (T)EtchStore.create((File)f);
                }
                catch (IOException e) {
                    return null;
                }
            }
        }
        return null;
    }

    public static KeyStore checkKeyStore(Map<Keyword, Object> config) throws ConfigException {
        Object o = config.get(Keywords.KEYSTORE);
        if (o == null) {
            return null;
        }
        if (o instanceof KeyStore) {
            return (KeyStore)o;
        }
        if (o instanceof String || o instanceof AString) {
            String fname = o.toString();
            File f = FileUtils.getFile((String)fname);
            if (f.exists()) {
                try {
                    char[] pass = Config.checkPass(config, Keywords.STOREPASS);
                    KeyStore ks = PFXTools.loadStore((File)f, (char[])pass);
                    return ks;
                }
                catch (GeneralSecurityException e) {
                    throw new ConfigException("Security error loading keystore " + fname, e);
                }
                catch (IOException e) {
                    throw new ConfigException("IO Error loading keystore " + fname, e);
                }
            }
            throw new ConfigException("Specified keystore " + fname + " does not exist");
        }
        throw new ConfigException("Unexpected type for keystore : " + Utils.getClassName((Object)o));
    }

    private static char[] checkPass(Map<Keyword, Object> config, Keyword key) throws ConfigException {
        Object po = config.get(key);
        if (po == null) {
            return null;
        }
        if (po instanceof char[]) {
            return (char[])po;
        }
        if (po instanceof String) {
            char[] cs = ((String)po).toCharArray();
            config.put(key, cs);
            return cs;
        }
        throw new ConfigException("Unexpected type for password " + String.valueOf(key) + " : " + Utils.getClassName((Object)po));
    }

    public static <T extends AStore> T ensureStore(Map<Keyword, Object> config) throws ConfigException {
        Object store;
        try {
            store = Config.checkStore(config);
            if (store != null) {
                return store;
            }
            store = EtchStore.createTemp((String)"tempPeerStore");
        }
        catch (IOException e) {
            throw new ConfigException("Unable to configure temporary store due to IO error", e);
        }
        config.put(Keywords.STORE, store);
        return store;
    }

    public static void ensureFlags(Map<Keyword, Object> config) {
        if (!config.containsKey(Keywords.RESTORE)) {
            config.put(Keywords.RESTORE, true);
        }
        if (!config.containsKey(Keywords.PERSIST)) {
            config.put(Keywords.PERSIST, true);
        }
        if (!config.containsKey(Keywords.AUTO_MANAGE)) {
            config.put(Keywords.AUTO_MANAGE, true);
        }
        if (!config.containsKey(Keywords.PORT)) {
            config.put(Keywords.PORT, null);
        }
    }

    public static AKeyPair ensurePeerKey(HashMap<Keyword, Object> config) throws ConfigException {
        Object o = config.get(Keywords.KEYPAIR);
        if (o != null) {
            if (o instanceof AKeyPair) {
                AKeyPair kp = (AKeyPair)o;
                return kp;
            }
            throw new ConfigException("Invalid type of :keypair - expected AKeyPair, got " + Utils.getClassName((Object)o));
        }
        throw new ConfigException("Peer launch requires a " + String.valueOf(Keywords.KEYPAIR) + " in config");
    }

    public static void ensureGenesisState(HashMap<Keyword, Object> config) throws ConfigException {
        if (!(config.containsKey(Keywords.STATE) || config.containsKey(Keywords.STORE) || config.containsKey(Keywords.SOURCE))) {
            throw new ConfigException("Peer launch requires a genesis :state, remote :source or existing :store in config");
        }
    }

    public static HashMap<Keyword, Object> of(Object ... kvs) {
        int n = kvs.length;
        if (n % 2 != 0) {
            throw new IllegalArgumentException("Needs even number of args (key / value pairs)");
        }
        HashMap<Keyword, Object> hm = new HashMap<Keyword, Object>(n / 2);
        for (int i = 0; i < n; i += 2) {
            Keyword k = (Keyword)kvs[i];
            Object o = kvs[i + 1];
            hm.put(k, o);
        }
        return hm;
    }
}

