/*
 * Decompiled with CFR 0.152.
 */
package convex.net.impl.nio;

import convex.core.data.ACell;
import convex.core.data.AccountKey;
import convex.core.data.Blob;
import convex.core.data.Cells;
import convex.core.data.Format;
import convex.core.data.SignedData;
import convex.core.exceptions.BadFormatException;
import convex.core.message.Message;
import convex.core.store.AStore;
import convex.core.store.Stores;
import convex.core.util.Counters;
import convex.core.util.Shutdown;
import convex.core.util.Utils;
import convex.net.AConnection;
import convex.net.MessageReceiver;
import convex.net.MessageSender;
import convex.net.impl.HandlerException;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.ByteChannel;
import java.nio.channels.CancelledKeyException;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.SocketChannel;
import java.util.Iterator;
import java.util.Set;
import java.util.concurrent.TimeoutException;
import java.util.function.Consumer;
import java.util.function.Predicate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Connection
extends AConnection {
    final ByteChannel channel;
    private long idCounter = 0L;
    private long lastActivity;
    private AccountKey trustedPeerKey;
    private static final Logger log = LoggerFactory.getLogger((String)Connection.class.getName());
    private final MessageReceiver receiver;
    private final MessageSender sender;
    private static Selector selector;
    private static Thread selectorThread;
    private static Runnable selectorLoop;

    private Connection(ByteChannel channel, Consumer<Message> receiveAction, AccountKey trustedPeerKey) {
        this.channel = channel;
        Predicate<Message> handler = t -> {
            try {
                return this.sendMessage((Message)t);
            }
            catch (IOException e) {
                return false;
            }
        };
        this.receiver = new MessageReceiver(receiveAction, handler);
        this.sender = new MessageSender(channel);
        this.lastActivity = Utils.getCurrentTimestamp();
        this.trustedPeerKey = trustedPeerKey;
    }

    public static Connection create(ByteChannel channel, Consumer<Message> receiveAction, AccountKey trustedPeerKey) throws IOException {
        Connection.ensureSelectorLoop();
        return new Connection(channel, receiveAction, trustedPeerKey);
    }

    public static Connection connect(InetSocketAddress socketAddress, Consumer<Message> receiveAction) throws IOException, TimeoutException {
        return Connection.connect(socketAddress, receiveAction, null);
    }

    public static Connection connect(InetSocketAddress socketAddress, Consumer<Message> receiveAction, AccountKey trustedPeerKey) throws IOException, TimeoutException {
        return Connection.connect(socketAddress, receiveAction, trustedPeerKey, 131072, 65536);
    }

    public static Connection connect(InetSocketAddress socketAddress, Consumer<Message> receiveAction, AccountKey trustedPeerKey, int sendBufferSize, int receiveBufferSize) throws IOException, TimeoutException {
        Connection.ensureSelectorLoop();
        SocketChannel clientChannel = SocketChannel.open();
        clientChannel.configureBlocking(false);
        clientChannel.socket().setReceiveBufferSize(receiveBufferSize);
        clientChannel.socket().setSendBufferSize(sendBufferSize);
        clientChannel.socket().setTcpNoDelay(true);
        clientChannel.connect(socketAddress);
        long start = Utils.getCurrentTimestamp();
        while (!clientChannel.finishConnect()) {
            long now = Utils.getCurrentTimestamp();
            long elapsed = now - start;
            if (elapsed > 8000L) {
                throw new TimeoutException("Couldn't connect after " + elapsed + "ms");
            }
            try {
                Thread.sleep(10L + elapsed / 3L);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new IOException("Connect interrupted", e);
            }
        }
        Connection pc = Connection.create(clientChannel, receiveAction, trustedPeerKey);
        pc.startClientListening();
        log.trace("Connect succeeded for host: {}", (Object)socketAddress);
        return pc;
    }

    @Override
    public long getReceivedCount() {
        return this.receiver.getReceivedCount();
    }

    public void setReceiveHook(Consumer<Message> hook) {
        this.receiver.setHook(hook);
    }

    @Override
    public InetSocketAddress getRemoteAddress() {
        if (!(this.channel instanceof SocketChannel)) {
            return null;
        }
        try {
            return (InetSocketAddress)((SocketChannel)this.channel).getRemoteAddress();
        }
        catch (IOException e) {
            return null;
        }
    }

    public InetSocketAddress getLocalAddress() {
        if (!(this.channel instanceof SocketChannel)) {
            return null;
        }
        try {
            return (InetSocketAddress)((SocketChannel)this.channel).getLocalAddress();
        }
        catch (IOException e) {
            return null;
        }
    }

    public boolean sendData(Blob data) throws IOException {
        log.trace("Sending data: {}", (Object)data);
        return this.sendBuffer(data);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long sendChallenge(SignedData<ACell> challenge) throws IOException {
        AStore temp = Stores.current();
        try {
            long id = ++this.idCounter;
            boolean sent = this.sendObject((ACell)challenge);
            long l = sent ? id : -1L;
            return l;
        }
        finally {
            Stores.setCurrent((AStore)temp);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long sendResponse(SignedData<ACell> response) throws IOException {
        AStore temp = Stores.current();
        try {
            long id = ++this.idCounter;
            boolean sent = this.sendObject((ACell)response);
            long l = sent ? id : -1L;
            return l;
        }
        finally {
            Stores.setCurrent((AStore)temp);
        }
    }

    @Override
    public boolean sendMessage(Message msg) throws IOException {
        return this.sendBuffer(msg.getMessageData());
    }

    private boolean sendObject(ACell payload) throws IOException {
        ++Counters.sendCount;
        Blob enc = Format.encodeMultiCell((ACell)payload, (boolean)true);
        if (log.isTraceEnabled()) {
            log.trace("Sending message: " + String.valueOf(payload) + " to " + String.valueOf(this.getRemoteAddress()) + " format: " + Cells.encode((ACell)payload).toHexString());
        }
        boolean sent = this.sendBuffer(enc);
        return sent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean sendBuffer(Blob data) throws IOException {
        MessageSender messageSender = this.sender;
        synchronized (messageSender) {
            int dataLength;
            if (!this.sender.canSendMessage()) {
                return false;
            }
            int messageLength = dataLength = Utils.checkedInt((long)data.count());
            ByteBuffer frameBuf = ByteBuffer.allocate(messageLength + 10);
            Format.writeMessageLength((ByteBuffer)frameBuf, (int)messageLength);
            int headerLength = frameBuf.position();
            frameBuf.put(headerLength, data.getInternalArray(), data.getInternalOffset(), dataLength);
            frameBuf.position(headerLength + dataLength);
            frameBuf.flip();
            boolean sent = this.sender.bufferMessage(frameBuf);
            if (sent) {
                this.lastActivity = System.currentTimeMillis();
                if (this.channel instanceof SocketChannel) {
                    SocketChannel chan = (SocketChannel)this.channel;
                    try {
                        chan.register(selector, 5, this);
                    }
                    catch (CancelledKeyException cancelledKeyException) {
                        // empty catch block
                    }
                }
                if (log.isTraceEnabled()) {
                    log.trace("Sent message of length: " + dataLength + " Connection ID: " + System.identityHashCode(this));
                }
            } else {
                log.warn("sendBuffer failed with message of length: {} Connection ID: {}", (Object)dataLength, (Object)System.identityHashCode(this));
            }
            return sent;
        }
    }

    @Override
    public synchronized void close() {
        SocketChannel chan = (SocketChannel)this.channel;
        if (chan != null) {
            try {
                chan.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public void finalize() {
        this.close();
    }

    @Override
    public boolean isClosed() {
        return !this.channel.isOpen();
    }

    private void startClientListening() throws IOException {
        SocketChannel chan = (SocketChannel)this.channel;
        chan.register(selector, 5, this);
        selector.wakeup();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void ensureSelectorLoop() {
        if (selectorThread != null) return;
        Class<Connection> clazz = Connection.class;
        synchronized (Connection.class) {
            if (selectorThread != null) return;
            try {
                selector = Selector.open();
            }
            catch (IOException e) {
                throw new Error("Error initialising client selector", e);
            }
            selectorThread = new Thread(selectorLoop, "Connection NIO client selector loop");
            selectorThread.setDaemon(true);
            selectorThread.start();
            Shutdown.addHook((int)90, () -> selectorThread.interrupt());
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }

    protected static void selectRead(SelectionKey key) throws IOException {
        Connection conn = (Connection)key.attachment();
        if (conn == null) {
            throw new Error("No PeerConnection specified");
        }
        try {
            int n = conn.handleChannelRecieve();
            if (n < 0) {
                log.trace("Cancelled Key due to EOS");
                key.cancel();
            }
        }
        catch (ClosedChannelException e) {
            log.trace("Channel closed from: {}", (Object)conn.getRemoteAddress());
            key.cancel();
        }
        catch (BadFormatException e) {
            log.info("Cancelled connection to Peer: Bad data format from: " + String.valueOf(conn.getRemoteAddress()) + " " + e.getMessage());
            key.cancel();
        }
        catch (HandlerException e) {
            log.warn("Cancelled connection: error in handler: " + e.getMessage());
            key.cancel();
        }
    }

    public int handleChannelRecieve() throws IOException, BadFormatException, HandlerException {
        int recd;
        AStore savedStore = Stores.current();
        int total = recd = this.receiver.receiveFromChannel(this.channel);
        while (recd > 0) {
            recd = this.receiver.receiveFromChannel(this.channel);
            total += recd;
        }
        if (recd > 0) {
            this.lastActivity = System.currentTimeMillis();
        }
        return total;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void selectWrite(SelectionKey key) throws IOException {
        Connection pc = (Connection)key.attachment();
        MessageSender messageSender = pc.sender;
        synchronized (messageSender) {
            boolean allSent = pc.sender.maybeSendBytes();
            if (allSent) {
                key.interestOps(key.interestOps() & 0xFFFFFFFB);
            }
        }
    }

    public boolean flushBytes() throws IOException {
        return this.sender.maybeSendBytes();
    }

    public String toString() {
        return "NIO Connection: " + String.valueOf(this.channel);
    }

    public long getLastActivity() {
        return this.lastActivity;
    }

    public long getNextID() {
        return ++this.idCounter;
    }

    static {
        selectorLoop = new Runnable(){

            @Override
            public void run() {
                log.trace("Client selector loop starting...");
                while (!Thread.currentThread().isInterrupted()) {
                    try {
                        selector.select(300L);
                        Set<SelectionKey> keys = selector.selectedKeys();
                        Iterator<SelectionKey> it = keys.iterator();
                        while (it.hasNext()) {
                            SelectionKey key = it.next();
                            it.remove();
                            if (!key.isValid()) continue;
                            try {
                                if (key.isReadable()) {
                                    Connection.selectRead(key);
                                    continue;
                                }
                                if (!key.isWritable()) continue;
                                Connection.selectWrite(key);
                            }
                            catch (ClosedChannelException e) {
                                log.trace("Unexpected ChannelClosedException, cancelling key: {}", (Throwable)e);
                                key.cancel();
                            }
                            catch (IOException e) {
                                log.trace("Unexpected IOException, cancelling key: {}", (Throwable)e);
                                key.cancel();
                            }
                            catch (CancelledKeyException e) {
                                log.trace("Cancelled key");
                            }
                        }
                    }
                    catch (IOException t) {
                        log.warn("Uncaught IO error in PeerConnection client selector loop: ", (Throwable)t);
                    }
                }
            }
        };
    }
}

