/*
 * Decompiled with CFR 0.152.
 */
package convex.net.impl.netty;

import convex.core.data.Blob;
import convex.core.exceptions.BadFormatException;
import convex.core.message.Message;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.ByteToMessageDecoder;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Predicate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class NettyInboundHandler
extends ByteToMessageDecoder {
    static final Logger log = LoggerFactory.getLogger((String)NettyInboundHandler.class.getName());
    private final Consumer<Message> receiveAction;
    private Predicate<Message> returnAction;
    private long receivedCount = 0L;

    public NettyInboundHandler(Consumer<Message> receiveAction, Predicate<Message> returnAction) {
        this.receiveAction = receiveAction;
        this.returnAction = returnAction;
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
        log.debug("Closed Netty channel due to: " + cause.getMessage(), cause);
        ctx.close();
    }

    public long getReceivedCount() {
        return this.receivedCount;
    }

    protected void decode(ChannelHandlerContext ctx, ByteBuf in, List<Object> out) throws Exception {
        ByteBuf buf = in;
        buf.markReaderIndex();
        int mlen = 0;
        int newBytes = buf.readableBytes();
        if (newBytes == 0) {
            return;
        }
        int i = 0;
        while (true) {
            if (i >= newBytes) {
                buf.resetReaderIndex();
                return;
            }
            byte b = buf.readByte();
            if (i == 0 && b == 128) {
                byte[] bytes = new byte[newBytes];
                bytes[0] = b;
                buf.readBytes(bytes, 1, newBytes - 1);
                Blob tmp = Blob.wrap((byte[])bytes);
                throw new BadFormatException("Zero leading bits in message length, content: " + String.valueOf(tmp));
            }
            int bm = b & 0x7F;
            if ((long)(mlen = (mlen << 7) + bm) > 50000000L) {
                throw new BadFormatException("Message too long: " + mlen);
            }
            if ((b & 0x80) == 0) break;
            ++i;
        }
        if (buf.readableBytes() < mlen) {
            buf.resetReaderIndex();
            return;
        }
        byte[] messageData = new byte[mlen];
        buf.readBytes(messageData);
        Message m = Message.create(this.returnAction, null, (Blob)Blob.wrap((byte[])messageData));
        out.add(m);
        ++this.receivedCount;
        if (this.receiveAction != null) {
            this.receiveAction.accept(m);
        } else {
            log.warn("Message ignored, no receiveAction");
        }
    }
}

