/*
 * Decompiled with CFR 0.152.
 */
package convex.net;

import convex.core.data.Blob;
import convex.core.data.Blobs;
import convex.core.util.ThreadUtils;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketException;

public class UDPServer {
    private static final int UDP_TIMEOUT = 3000;
    DatagramSocket socket;
    protected boolean running = false;

    public UDPServer() {
        try {
            this.socket = new DatagramSocket(null);
        }
        catch (SocketException e) {
            throw new Error(e);
        }
    }

    public void launch(String bindAddress, Integer port) throws IOException {
        this.socket.setSoTimeout(3000);
        String string = bindAddress = bindAddress == null ? "::" : bindAddress;
        if (port == null) {
            port = 0;
        }
        if (port == 0) {
            try {
                InetSocketAddress address = new InetSocketAddress(bindAddress, 18888);
                this.socket.bind(address);
            }
            catch (IOException e) {
                InetSocketAddress address = new InetSocketAddress(bindAddress, 0);
                this.socket.bind(address);
            }
        } else {
            InetSocketAddress address = new InetSocketAddress(bindAddress, (int)port);
            this.socket.bind(address);
        }
        ThreadUtils.runVirtual(this::run);
    }

    public void run() {
        this.running = true;
        DatagramPacket packet = new DatagramPacket(new byte[65536], 0);
        while (this.running) {
            try {
                this.socket.receive(packet);
                System.out.println("Received " + packet.getLength() + " bytes from " + String.valueOf(packet.getAddress()));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public void close() {
        this.running = false;
    }

    public static void main(String ... args) throws IOException {
        UDPServer server = new UDPServer();
        server.launch(null, 18888);
        server.sendMessage(Blobs.empty());
        server.close();
    }

    private void sendMessage(Blob b) {
        DatagramPacket packet = new DatagramPacket(b.getBytes(), b.size());
        packet.setAddress(InetAddress.getLoopbackAddress());
        packet.setPort(18888);
        try {
            this.socket.send(packet);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

