/*
 * Decompiled with CFR 0.152.
 */
package convex.net;

import convex.core.Result;
import convex.core.data.ACell;
import convex.core.exceptions.BadFormatException;
import convex.core.exceptions.MissingDataException;
import convex.core.message.Message;
import convex.core.message.MessageType;
import convex.core.store.Stores;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ResultConsumer
implements Consumer<Message> {
    private static final Logger log = LoggerFactory.getLogger((String)ResultConsumer.class.getName());

    @Override
    public void accept(Message m) {
        MessageType type = m.getType();
        switch (type) {
            case DATA: {
                this.handleDataProvided(m);
                break;
            }
            case DATA_REQUEST: {
                this.handleDataRequest(m);
                break;
            }
            case RESULT: {
                this.handleResultMessage(m);
                break;
            }
            default: {
                log.error("Message type ignored type: {} value: {}", (Object)type, (Object)m);
            }
        }
    }

    private void handleDataProvided(Message m) {
    }

    private void handleDataRequest(Message m) {
        try {
            Message response = m.makeDataResponse(Stores.current());
            m.returnMessage(response);
        }
        catch (BadFormatException e) {
            m.closeConnection();
        }
    }

    private final void handleResultMessage(Message m) {
        try {
            Result result = (Result)m.getPayload();
            ACell cid = m.getID();
            this.handleResult(cid, result);
        }
        catch (BadFormatException | MissingDataException e) {
            log.warn("Exception handling result", e);
        }
    }

    protected void handleResult(ACell id, Result result) {
        ACell rv = result.getValue();
        ACell err = result.getErrorCode();
        if (err != null) {
            this.handleError(id, err, rv);
        } else {
            this.handleNormalResult(id, rv);
        }
    }

    protected void handleError(ACell id, ACell code, ACell errorMessage) {
        log.warn("UNHANDLED ERROR RECEIVED: {} :  {}", (Object)code, (Object)errorMessage);
    }

    protected void handleNormalResult(ACell id, ACell value) {
        log.debug("UNHANDLED RESULT RECEIVED: id={}, value={}", (Object)id, (Object)value);
    }
}

