/*
 * Decompiled with CFR 0.152.
 */
package convex.net;

import convex.core.data.Blob;
import convex.core.data.Format;
import convex.core.exceptions.BadFormatException;
import convex.core.message.Message;
import convex.net.impl.HandlerException;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.ReadableByteChannel;
import java.util.function.Consumer;
import java.util.function.Predicate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MessageReceiver {
    public static final int INITIAL_RECEIVE_BUFFER_SIZE = 512;
    private ByteBuffer buffer = ByteBuffer.allocate(512);
    private final Consumer<Message> action;
    private Consumer<Message> hook = null;
    private final Predicate<Message> returnHandler;
    private long receivedMessageCount = 0L;
    private static final Logger log = LoggerFactory.getLogger((String)MessageReceiver.class.getName());

    public MessageReceiver(Consumer<Message> receiveAction, Predicate<Message> returnHandler) {
        this.action = receiveAction;
        this.returnHandler = returnHandler;
    }

    public long getReceivedCount() {
        return this.receivedMessageCount;
    }

    public synchronized int receiveFromChannel(ReadableByteChannel chan) throws BadFormatException, HandlerException, IOException {
        int numRead = 0;
        numRead = chan.read(this.buffer);
        if (numRead <= 0) {
            return numRead;
        }
        while (this.buffer.position() > 0) {
            int len = Format.peekMessageLength((ByteBuffer)this.buffer);
            if (len < 0) {
                return numRead;
            }
            int lengthLength = Format.getVLQCountLength((long)len);
            int totalFrameSize = lengthLength + len;
            if (totalFrameSize > this.buffer.capacity()) {
                int newSize = Math.max(totalFrameSize, this.buffer.position());
                ByteBuffer newBuffer = ByteBuffer.allocate(newSize);
                this.buffer.flip();
                newBuffer.put(this.buffer);
                this.buffer = newBuffer;
            }
            if (this.buffer.position() < totalFrameSize) {
                return numRead;
            }
            Blob messageData = Blob.wrap((byte[])this.buffer.array(), (int)lengthLength, (int)len);
            int receivedLimit = this.buffer.position();
            if (receivedLimit > totalFrameSize) {
                int newSize = Math.max(512, receivedLimit - totalFrameSize);
                ByteBuffer newBuffer = ByteBuffer.allocate(newSize);
                this.buffer.position(totalFrameSize);
                this.buffer.limit(receivedLimit);
                newBuffer.put(this.buffer);
                this.buffer = newBuffer;
            } else {
                this.buffer = ByteBuffer.allocate(512);
            }
            this.receiveMessage(messageData);
        }
        return numRead;
    }

    private void receiveMessage(Blob messageData) throws BadFormatException, HandlerException {
        if (messageData.count() < 1L) {
            throw new BadFormatException("Empty message");
        }
        Message message = Message.create(this.returnHandler, null, (Blob)messageData);
        this.maybeCallHook(message);
        ++this.receivedMessageCount;
        if (this.action != null) {
            log.trace("Message received: {}", (Object)message.getType());
            try {
                this.action.accept(message);
            }
            catch (Exception e) {
                if (e instanceof InterruptedException) {
                    Thread.currentThread().interrupt();
                }
                throw new HandlerException("Error in message receive action handler: " + e.getMessage(), e);
            }
        } else {
            log.warn("Ignored message because no receive action set: " + String.valueOf(message));
        }
    }

    private void maybeCallHook(Message message) {
        Consumer<Message> hook = this.hook;
        if (hook != null) {
            hook.accept(message);
        }
    }

    public void setHook(Consumer<Message> hook) {
        this.hook = hook;
    }
}

