/*
 * Decompiled with CFR 0.152.
 */
package convex.api;

import convex.api.ConvexRemote;
import convex.core.Result;
import convex.core.data.ACell;
import convex.core.data.AVector;
import convex.core.data.Cells;
import convex.core.data.Hash;
import convex.core.data.Ref;
import convex.core.data.prim.CVMLong;
import convex.core.exceptions.BadFormatException;
import convex.core.exceptions.MissingDataException;
import convex.core.exceptions.ResultException;
import convex.core.lang.RT;
import convex.core.message.Message;
import convex.core.store.AStore;
import convex.core.util.ThreadUtils;
import convex.core.util.Utils;
import java.io.IOException;
import java.util.HashSet;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeoutException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Acquiror {
    private static final Logger log = LoggerFactory.getLogger((String)Acquiror.class.getName());
    private Hash hash;
    private AStore store;
    private ConvexRemote source;

    public Acquiror(Hash hash, AStore store, ConvexRemote source) {
        this.hash = hash;
        this.store = store;
        this.source = source;
    }

    public static Acquiror create(Hash hash, AStore store, ConvexRemote source) {
        return new Acquiror(hash, store, source);
    }

    public <T extends ACell> CompletableFuture<T> getFuture() {
        CompletableFuture<ACell> f = new CompletableFuture<ACell>();
        Ref checkRef = this.store.refForHash(this.hash);
        if (checkRef != null && checkRef.getStatus() >= 3) {
            f.complete(checkRef.getValue());
            return f;
        }
        log.trace("Trying to acquire remotely: {}", (Object)this.hash);
        ThreadUtils.runWithStore((AStore)this.store, () -> {
            try {
                HashSet<Hash> missingSet = new HashSet<Hash>();
                long LIMIT = 254L;
                while (!f.isDone()) {
                    Ref ref = this.store.refForHash(this.hash);
                    missingSet.clear();
                    if (ref == null) {
                        missingSet.add(this.hash);
                    } else {
                        if (ref.getStatus() >= 3) {
                            f.complete(ref.getValue());
                            log.trace("Successfully acquired {}", (Object)this.hash);
                            return;
                        }
                        ref.findMissing(missingSet, LIMIT);
                        if (missingSet.isEmpty()) {
                            f.complete(ref.getValue());
                            return;
                        }
                    }
                    CVMLong id = CVMLong.create((long)this.source.getNextID());
                    Message dataRequest = Message.createDataRequest((ACell)id, (Hash[])missingSet.toArray(Utils.EMPTY_HASHES));
                    CompletableFuture<Result> cf = this.source.message(dataRequest);
                    try {
                        Result resp = cf.get();
                        if (resp.isError()) {
                            f.completeExceptionally((Throwable)new ResultException(resp));
                            log.info("Failed to request missing data: " + String.valueOf(resp));
                            return;
                        }
                        AVector v = RT.ensureVector((ACell)resp.getValue());
                        if (v == null) {
                            throw new BadFormatException("Expected Vector in data result for id " + String.valueOf(id) + " but was: " + String.valueOf(resp));
                        }
                        int i = 0;
                        while ((long)i < v.count()) {
                            ACell val = v.get(i);
                            if (val == null) {
                                AVector reqv = (AVector)dataRequest.getPayload();
                                Hash expectedHash = RT.ensureHash((ACell)reqv.get(i + 2));
                                f.completeExceptionally(new MissingDataException(this.store, expectedHash));
                            } else {
                                Cells.store((ACell)val, (AStore)this.store);
                            }
                            ++i;
                        }
                    }
                    catch (ExecutionException e) {
                        if (e.getCause() instanceof TimeoutException) {
                            log.info("Acquire polling: Long delay requesting {}", missingSet);
                            continue;
                        }
                        f.completeExceptionally(e);
                        continue;
                    }
                    ref = this.store.refForHash(this.hash);
                    if (ref == null) continue;
                    try {
                        ACell a = ref.getValue();
                        a = Cells.persist((ACell)a);
                    }
                    catch (MissingDataException missingDataException) {}
                }
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                f.completeExceptionally(e);
            }
            catch (BadFormatException | IOException | NullPointerException t) {
                log.warn("UNEXPECTED acquire fail: ", t);
                f.completeExceptionally(t);
            }
        });
        return f;
    }
}

