/*
 * Decompiled with CFR 0.152.
 */
package convex.peer;

import convex.api.Convex;
import convex.api.ConvexLocal;
import convex.core.ErrorCodes;
import convex.core.Result;
import convex.core.SourceCodes;
import convex.core.cpos.Belief;
import convex.core.cpos.Order;
import convex.core.crypto.AKeyPair;
import convex.core.cvm.AccountStatus;
import convex.core.cvm.Address;
import convex.core.cvm.Keywords;
import convex.core.cvm.Peer;
import convex.core.cvm.State;
import convex.core.data.ABlobLike;
import convex.core.data.ACell;
import convex.core.data.AHashMap;
import convex.core.data.AMap;
import convex.core.data.AVector;
import convex.core.data.AccountKey;
import convex.core.data.Cells;
import convex.core.data.Hash;
import convex.core.data.Keyword;
import convex.core.data.Maps;
import convex.core.data.Ref;
import convex.core.data.SignedData;
import convex.core.data.Strings;
import convex.core.data.Vectors;
import convex.core.data.prim.CVMLong;
import convex.core.exceptions.InvalidDataException;
import convex.core.exceptions.MissingDataException;
import convex.core.init.Init;
import convex.core.lang.RT;
import convex.core.message.Message;
import convex.core.message.MessageType;
import convex.core.store.AStore;
import convex.core.store.Stores;
import convex.core.util.Shutdown;
import convex.core.util.Utils;
import convex.net.AServer;
import convex.net.impl.netty.NettyServer;
import convex.peer.API;
import convex.peer.BeliefPropagator;
import convex.peer.CVMExecutor;
import convex.peer.Config;
import convex.peer.ConfigException;
import convex.peer.ConnectionManager;
import convex.peer.LaunchException;
import convex.peer.QueryHandler;
import convex.peer.TransactionHandler;
import java.io.Closeable;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Server
implements Closeable {
    public static final int DEFAULT_PORT = 18888;
    static final Logger log = LoggerFactory.getLogger((String)Server.class.getName());
    private Consumer<Message> messageReceiveObserver = null;
    Consumer<Message> receiveAction = m -> {
        this.observeMessageReceived((Message)m);
        this.processMessage((Message)m);
    };
    protected final ConnectionManager manager = new ConnectionManager(this);
    protected final BeliefPropagator propagator = new BeliefPropagator(this);
    protected final TransactionHandler transactionHandler = new TransactionHandler(this);
    protected final CVMExecutor executor = new CVMExecutor(this);
    protected final QueryHandler queryHandler = new QueryHandler(this);
    private final AStore store;
    private final HashMap<Keyword, Object> config;
    private AServer nio;
    public static final AVector<Keyword> sTATUS_KEYS = Vectors.create((ACell[])new ACell[]{Keywords.BELIEF, Keywords.STATES, Keywords.GENESIS});
    private CompletableFuture<Long> shutdownFuture = new CompletableFuture();
    private volatile boolean isRunning = false;
    private volatile boolean isLive = false;

    private Server(HashMap<Keyword, Object> config) throws ConfigException {
        this.config = config;
        this.store = Config.ensureStore(config);
        this.nio = NettyServer.create(this);
    }

    private Peer establishPeer() throws ConfigException, LaunchException, InterruptedException {
        log.debug("Establishing Peer with store: {}", (Object)Stores.current());
        AKeyPair keyPair = Config.ensurePeerKey(this.config);
        if (keyPair == null) {
            log.warn("No keypair provided for Server, deafulting to generated keypair for testing purposes");
            keyPair = AKeyPair.generate();
            this.config.put(Keywords.KEYPAIR, keyPair);
            log.warn("Generated keypair with public key: " + String.valueOf(keyPair.getAccountKey()));
        }
        try {
            State genesisState;
            Object source = this.getConfig().get(Keywords.SOURCE);
            if (Utils.bool((Object)source)) {
                try {
                    return this.syncPeer(keyPair, Convex.connect(source));
                }
                catch (TimeoutException e) {
                    throw new LaunchException("Timeout trying to connect to remote peer");
                }
                catch (IllegalArgumentException e) {
                    throw new LaunchException("Bad :SOURCE for peer launch", e);
                }
                catch (Exception e) {
                    throw new LaunchException("Failed to sync with remote peer host at: " + String.valueOf(source), e);
                }
            }
            if (Utils.bool((Object)this.getConfig().get(Keywords.RESTORE))) {
                Peer peer;
                ACell rk = RT.cvm((Object)this.config.get(Keywords.ROOT_KEY));
                if (rk == null) {
                    rk = keyPair.getAccountKey();
                }
                if ((peer = Peer.restorePeer((AStore)this.store, (AKeyPair)keyPair, (ACell)rk)) != null) {
                    log.info("Restored Peer with root data hash: {}", (Object)this.store.getRootHash());
                    return peer;
                }
            }
            if ((genesisState = (State)this.config.get(Keywords.STATE)) != null) {
                log.info("Defaulting to standard Peer startup with genesis state: " + String.valueOf(genesisState.getHash()));
            } else {
                AccountKey peerKey = keyPair.getAccountKey();
                genesisState = Init.createState(List.of(peerKey));
                log.info("Created new genesis state: " + String.valueOf(genesisState.getHash()) + " with initial peer: " + String.valueOf(peerKey));
            }
            return Peer.createGenesisPeer((AKeyPair)keyPair, (State)genesisState);
        }
        catch (IOException e) {
            throw new LaunchException("IO Exception while establishing peer: " + String.valueOf(e), e);
        }
    }

    public Peer syncPeer(AKeyPair keyPair, Convex convex) throws LaunchException, InterruptedException {
        try {
            log.info("Attempting Peer Sync with: " + String.valueOf(convex));
            long timeout = this.establishTimeout();
            Result result = convex.requestStatusSync(timeout);
            AMap<Keyword, ACell> status = API.ensureStatusMap(result.getValue());
            if (result.isError() || status == null) {
                throw new LaunchException("Bad status message from remote Peer: " + String.valueOf(result));
            }
            Hash beliefHash = RT.ensureHash((ACell)status.get((ACell)Keywords.BELIEF));
            AccountKey remotePeerKey = RT.ensureAccountKey((ACell)Keywords.PEER);
            Hash genesisHash = RT.ensureHash((ACell)status.get((ACell)Keywords.GENESIS));
            Hash stateHash = RT.ensureHash((ACell)Keywords.STATE);
            if (genesisHash == null) {
                throw new LaunchException("Remote peer did not provide genesis hash");
            }
            log.debug("Attempting to sync remote state: " + String.valueOf(stateHash) + " on network: " + String.valueOf(genesisHash));
            State genF = (State)convex.acquire(genesisHash).get(timeout, TimeUnit.MILLISECONDS);
            log.debug("Retrieved Genesis State: " + String.valueOf(genesisHash));
            log.debug("Attempting to obtain peer Belief: " + String.valueOf(beliefHash));
            Belief belF = null;
            long timeElapsed = 0L;
            while (belF == null) {
                try {
                    belF = (Belief)convex.acquire(beliefHash).get(timeout, TimeUnit.MILLISECONDS);
                }
                catch (TimeoutException te) {
                    log.info("Still waiting for Belief sync after " + (timeElapsed += timeout) / 1000L + "s");
                }
            }
            log.info("Retrieved Peer Belief: " + String.valueOf(beliefHash) + " with memory size: " + belF.getMemorySize());
            this.getConnectionManager().addConnection(remotePeerKey, convex);
            SignedData peerOrder = (SignedData)belF.getOrders().get((ABlobLike)remotePeerKey);
            if (peerOrder != null) {
                newOrder = keyPair.signData((ACell)((Order)peerOrder.getValue()));
                belF = belF.withOrders(belF.getOrders().assoc((ACell)keyPair.getAccountKey(), (ACell)newOrder));
            } else {
                newOrder = keyPair.signData((ACell)Order.create());
                belF = belF.withOrders(belF.getOrders().assoc((ACell)keyPair.getAccountKey(), (ACell)newOrder));
            }
            Peer peer = Peer.create((AKeyPair)keyPair, (State)genF, (Belief)belF);
            return peer;
        }
        catch (InvalidDataException | ExecutionException e) {
            throw new LaunchException("Erring while trying to sync peer", e);
        }
        catch (TimeoutException e) {
            throw new LaunchException("Timeout attempting to sync peer", e);
        }
    }

    private long establishTimeout() {
        Object maybeTimeout = this.getConfig().get(Keywords.TIMEOUT);
        if (maybeTimeout == null) {
            return 60000L;
        }
        return Utils.toInt((Object)maybeTimeout);
    }

    public static Server create(HashMap<Keyword, Object> config) throws ConfigException {
        return new Server(new HashMap<Keyword, Object>(config));
    }

    private void observeMessageReceived(Message m) {
        Consumer<Message> obs = this.messageReceiveObserver;
        if (obs != null) {
            obs.accept(m);
        }
    }

    public void setMessageReceiveObserver(Consumer<Message> observer) {
        this.messageReceiveObserver = observer;
    }

    public Belief getBelief() {
        return this.getPeer().getBelief();
    }

    public Peer getPeer() {
        return this.executor.getPeer();
    }

    public String getHostname() {
        return (String)this.config.get(Keywords.URL);
    }

    public synchronized void launch() throws LaunchException, InterruptedException {
        if (this.isRunning) {
            return;
        }
        this.isRunning = true;
        AStore savedStore = Stores.current();
        try {
            Object p;
            Stores.setCurrent((AStore)this.store);
            Peer peer = this.establishPeer();
            this.executor.setPeer(peer);
            this.executor.persistPeerData();
            HashMap<Keyword, Object> config = this.getConfig();
            if (config.containsKey(Keywords.RECALC)) {
                try {
                    Object o = config.get(Keywords.RECALC);
                    if (o != null) {
                        Long pos = Utils.toLong((Object)o);
                        this.executor.recalcState(pos);
                    }
                }
                catch (Exception e) {
                    throw new LaunchException("Launch failed to recalculate state: " + String.valueOf(e), e);
                }
            }
            Integer port = (p = config.get(Keywords.PORT)) == null ? null : Integer.valueOf(Utils.toInt((Object)p));
            this.nio.setPort(port);
            this.nio.launch();
            port = this.nio.getPort();
            this.isRunning = true;
            Shutdown.addHook((int)80, () -> this.close());
            this.manager.start();
            this.queryHandler.start();
            this.propagator.start();
            this.transactionHandler.start();
            this.executor.start();
            this.goLive();
            log.info("Peer server started on port " + this.nio.getPort() + " with peer key: {}", (Object)this.getPeerKey());
        }
        catch (ConfigException e) {
            throw new LaunchException("Launch failed due to config problem: " + String.valueOf(e), e);
        }
        catch (IOException e) {
            throw new LaunchException("Launch failed due to IO Error: " + String.valueOf(e), e);
        }
        finally {
            Stores.setCurrent((AStore)savedStore);
        }
    }

    private void goLive() {
        this.isLive = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void processMessage(Message m) {
        AStore tempStore = Stores.current();
        try {
            Stores.setCurrent((AStore)this.store);
            MessageType type = m.getType();
            switch (type) {
                case BELIEF: {
                    this.processBelief(m);
                    return;
                }
                case CHALLENGE: {
                    this.processChallenge(m);
                    return;
                }
                case RESPONSE: {
                    this.processResponse(m);
                    return;
                }
                case COMMAND: {
                    return;
                }
                case DATA_REQUEST: {
                    this.processQuery(m);
                    return;
                }
                case QUERY: {
                    this.processQuery(m);
                    return;
                }
                case RESULT: {
                    log.debug("unexpected Result received");
                    return;
                }
                case TRANSACT: {
                    this.processTransact(m);
                    return;
                }
                case GOODBYE: {
                    this.processClose(m);
                    return;
                }
                case STATUS: {
                    this.processStatus(m);
                    return;
                }
                default: {
                    log.info("Unrecognised message: " + String.valueOf(m));
                    return;
                }
            }
        }
        catch (MissingDataException e) {
            Hash missingHash = e.getMissingHash();
            log.info("Missing data: {} in message", (Object)missingHash);
            return;
        }
        catch (Exception e) {
            log.warn("Unexpected error processing peer message", (Throwable)e);
            return;
        }
        finally {
            Stores.setCurrent((AStore)tempStore);
        }
    }

    protected void processTransact(Message m) {
        boolean queued = this.transactionHandler.offerTransaction(m);
        if (!queued) {
            Result r = Result.create((ACell)m.getID(), (ACell)Strings.SERVER_LOADED, (ACell)ErrorCodes.LOAD).withSource(SourceCodes.PEER);
            m.returnResult(r);
        }
    }

    protected void processClose(Message m) {
        m.closeConnection();
    }

    public long getBroadcastCount() {
        return this.propagator.getBeliefBroadcastCount();
    }

    public long getBeliefReceivedCount() {
        return this.propagator.beliefReceivedCount;
    }

    public Address getPeerController() {
        return this.getPeer().getController();
    }

    public boolean queueBelief(Message event) {
        boolean offered = this.propagator.queueBelief(event);
        return offered;
    }

    protected void processStatus(Message m) {
        AVector<ACell> reply = this.getStatusData();
        Result r = Result.create((ACell)m.getID(), reply);
        m.returnResult(r);
    }

    public AVector<ACell> getStatusData() {
        Peer peer = this.getPeer();
        Belief belief = peer.getBelief();
        State state = peer.getConsensusState();
        Hash beliefHash = belief.getHash();
        Hash stateHash = state.getHash();
        Hash genesisHash = peer.getNetworkID();
        AccountKey peerKey = peer.getPeerKey();
        Hash consensusHash = state.getHash();
        Order order = belief.getOrder(peerKey);
        CVMLong cp = CVMLong.create((long)order.getConsensusPoint());
        CVMLong pp = CVMLong.create((long)order.getProposalPoint());
        CVMLong op = CVMLong.create((long)order.getBlockCount());
        AVector cps = Vectors.of((Object[])Utils.toObjectArray((Object)order.getConsensusPoints()));
        AVector reply = Vectors.of((Object[])new Object[]{beliefHash, stateHash, genesisHash, peerKey, consensusHash, cp, pp, op, cps});
        assert (reply.count() == 9L);
        return reply;
    }

    public AMap<Keyword, ACell> getStatusMap() {
        return Maps.zipMap(API.STATUS_KEYS, this.getStatusData());
    }

    private void processChallenge(Message m) {
        this.manager.processChallenge(m, this.getPeer());
    }

    protected void processResponse(Message m) {
        this.manager.processResponse(m, this.getPeer());
    }

    protected void processQuery(Message m) {
        boolean queued = this.queryHandler.offerQuery(m);
        if (!queued) {
            Result r = Result.create((ACell)m.getID(), (ACell)Strings.SERVER_LOADED, (ACell)ErrorCodes.LOAD);
            m.returnResult(r);
        }
    }

    protected void processBelief(Message m) {
        if (!this.propagator.queueBelief(m)) {
            log.warn("Incoming belief queue full");
        }
    }

    public Integer getPort() {
        return this.nio.getPort();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Peer persistPeerData() throws IOException {
        AStore tempStore = Stores.current();
        try {
            Peer peer = this.getPeer();
            Stores.setCurrent((AStore)this.store);
            AMap peerData = peer.toData();
            ACell rk = RT.cvm((Object)this.config.get(Keywords.ROOT_KEY));
            if (rk == null) {
                rk = peer.getPeerKey();
            }
            ACell rootKey = rk;
            Ref rootRef = this.store.refForHash(this.store.getRootHash());
            AHashMap currentRootData = rootRef == null ? Maps.empty() : (AMap)rootRef.getValue();
            AMap newRootData = currentRootData.assoc(rootKey, (ACell)peerData);
            newRootData = (AMap)this.store.setRootData((ACell)newRootData).getValue();
            this.store.storeTopRef(peer.getGenesisState().getRef(), 3, null);
            this.store.storeTopRef(peer.getBelief().getRef(), 3, null);
            peerData = (AMap)newRootData.get(rootKey);
            log.debug("Stored peer data with hash: {}", (Object)peerData.getHash().toHexString());
            Peer peer2 = Peer.fromData((AKeyPair)this.getKeyPair(), (AMap)peerData);
            return peer2;
        }
        finally {
            Stores.setCurrent((AStore)tempStore);
        }
    }

    @Override
    public void close() {
        if (!this.isRunning) {
            return;
        }
        log.debug("Peer shutdown starting for " + String.valueOf(this.getPeerKey()));
        this.isLive = false;
        this.isRunning = false;
        this.manager.close();
        this.propagator.close();
        this.queryHandler.close();
        this.transactionHandler.close();
        this.executor.close();
        Peer peer = this.getPeer();
        if (peer != null && !Boolean.FALSE.equals(this.getConfig().get(Keywords.PERSIST))) {
            try {
                this.persistPeerData();
            }
            catch (IOException e) {
                log.warn("Unable to persist Peer data in " + String.valueOf(this.store), (Throwable)e);
            }
        }
        this.nio.close();
        log.info("Peer shutdown complete for " + String.valueOf(this.getPeerKey()));
        this.shutdownFuture.complete(Utils.getCurrentTimestamp());
    }

    public InetSocketAddress getHostAddress() {
        return this.nio.getHostAddress();
    }

    public AKeyPair getKeyPair() {
        return this.getPeer().getKeyPair();
    }

    public AccountKey getPeerKey() {
        AKeyPair kp = this.getKeyPair();
        if (kp == null) {
            return null;
        }
        return kp.getAccountKey();
    }

    public AKeyPair getControllerKey() {
        AKeyPair kp = this.getKeyPair();
        if (kp == null) {
            return null;
        }
        try {
            AccountStatus as = this.getPeer().getConsensusState().getAccount(this.getPeerController());
            if (Cells.equals((ACell)as.getAccountKey(), (ACell)kp.getAccountKey())) {
                return kp;
            }
        }
        catch (Exception e) {
            log.warn("Unexpected exception trying to get contreoller key", (Throwable)e);
        }
        return null;
    }

    public AStore getStore() {
        return this.store;
    }

    public ConnectionManager getConnectionManager() {
        return this.manager;
    }

    public HashMap<Keyword, Object> getConfig() {
        return this.config;
    }

    public Consumer<Message> getReceiveAction() {
        return this.receiveAction;
    }

    public void setHostname(String string) {
        this.config.put(Keywords.URL, string);
    }

    public boolean isLive() {
        return this.isLive;
    }

    public boolean isRunning() {
        return this.isRunning;
    }

    public TransactionHandler getTransactionHandler() {
        return this.transactionHandler;
    }

    public BeliefPropagator getBeliefPropagator() {
        return this.propagator;
    }

    public void updateBelief(Belief belief) {
        this.executor.queueUpdate(belief);
    }

    public CVMExecutor getCVMExecutor() {
        return this.executor;
    }

    public QueryHandler getQueryProcessor() {
        return this.queryHandler;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() {
        try {
            AKeyPair kp = this.getKeyPair();
            AccountKey key = kp.getAccountKey();
            ConvexLocal convex = Convex.connect(this, this.getPeerController(), kp);
            Result r = convex.transactSync("(set-peer-stake " + String.valueOf(key) + " 0)");
            if (r.isError()) {
                log.warn("Unable to remove Peer stake: " + String.valueOf(r));
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        finally {
            this.isLive = false;
            this.close();
        }
    }

    public void waitForShutdown() throws InterruptedException {
        while (this.isRunning() && !Thread.currentThread().isInterrupted()) {
            Thread.sleep(1000L);
        }
    }

    public static Server fromPeerData(AKeyPair kp, AMap<Keyword, ACell> peerData) throws LaunchException, ConfigException, InterruptedException {
        HashMap<Keyword, Object> config = new HashMap<Keyword, Object>();
        config.put(Keywords.KEYPAIR, kp);
        return API.launchPeer(config);
    }
}

