/*
 * Decompiled with CFR 0.152.
 */
package convex.peer;

import convex.core.Result;
import convex.core.ResultContext;
import convex.core.SourceCodes;
import convex.core.cvm.Address;
import convex.core.data.ACell;
import convex.core.data.AVector;
import convex.core.exceptions.BadFormatException;
import convex.core.lang.RT;
import convex.core.message.Message;
import convex.core.message.MessageType;
import convex.core.util.LoadMonitor;
import convex.peer.AThreadedComponent;
import convex.peer.Server;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QueryHandler
extends AThreadedComponent {
    private static final Logger log = LoggerFactory.getLogger((String)QueryHandler.class.getName());
    private ArrayBlockingQueue<Message> queryQueue = new ArrayBlockingQueue(10000);

    public QueryHandler(Server server) {
        super(server);
    }

    public boolean offerQuery(Message m) {
        return this.queryQueue.offer(m);
    }

    @Override
    protected void loop() throws InterruptedException {
        LoadMonitor.down();
        Message m = this.queryQueue.poll(10000L, TimeUnit.MILLISECONDS);
        LoadMonitor.up();
        if (m == null) {
            return;
        }
        MessageType type = m.getType();
        switch (type) {
            case QUERY: {
                this.handleQuery(m);
                break;
            }
            case DATA_REQUEST: {
                this.handleDataRequest(m);
                break;
            }
            default: {
                log.warn("Unexpected Message type on query queue: " + String.valueOf(type));
            }
        }
    }

    protected void handleDataRequest(Message m) {
        try {
            Message response = m.makeDataResponse(this.server.getStore());
            boolean sent = m.returnMessage(response);
            if (!sent) {
                log.info("Can't send data request response due to full buffer");
            }
        }
        catch (BadFormatException e) {
            log.warn("Unable to deliver missing data due badly formatted DATA_REQUEST: {}", (Object)m);
        }
        catch (Exception e) {
            log.warn("Unable to deliver missing data due to exception:", (Throwable)e);
        }
    }

    private void handleQuery(Message m) {
        try {
            AVector v = (AVector)m.getPayload();
            ACell id = v.get(1);
            ACell form = v.get(2);
            Address address = RT.ensureAddress((ACell)v.get(3));
            log.debug("Processing query: {} with address: {}", (Object)form, (Object)address);
            ResultContext resultContext = this.server.getPeer().executeQuery(form, address);
            Result result = Result.fromContext((ACell)id, (ResultContext)resultContext).withSource(SourceCodes.PEER);
            boolean resultReturned = m.returnResult(result);
            if (!resultReturned) {
                log.warn("Failed to send query result back to client with ID: {}", (Object)id);
            }
        }
        catch (Exception e) {
            log.debug("Terminated client: " + e.getMessage());
            m.closeConnection();
        }
    }

    @Override
    protected String getThreadName() {
        return "Query handler on port: " + this.server.getPort();
    }
}

