/*
 * Decompiled with CFR 0.152.
 */
package convex.net.impl.netty;

import convex.core.data.ACell;
import convex.core.message.Message;
import convex.core.util.Shutdown;
import convex.net.AServer;
import convex.net.impl.netty.NettyConnection;
import convex.net.impl.netty.NettyInboundHandler;
import convex.net.impl.netty.NettyOutboundHandler;
import convex.peer.Server;
import io.netty.bootstrap.ServerBootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.SocketChannel;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.function.Consumer;
import java.util.function.Predicate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NettyServer
extends AServer {
    static final Logger log = LoggerFactory.getLogger((String)NettyServer.class.getName());
    static EventLoopGroup bossGroup = null;
    private Consumer<Message> receiveAction = m -> {
        try {
            ACell payload = m.getPayload();
            m.returnMessage(Message.createResult((ACell)m.getRequestID(), (ACell)payload, null));
        }
        catch (Exception e) {
            log.warn("Unexpected exception handling message receipt", (Throwable)e);
        }
    };
    private Channel channel;

    protected static synchronized EventLoopGroup getEventLoopGroup() {
        if (bossGroup != null) {
            return bossGroup;
        }
        bossGroup = new NioEventLoopGroup();
        Shutdown.addHook((int)80, () -> {
            if (bossGroup != null) {
                bossGroup.shutdownGracefully();
            }
        });
        return bossGroup;
    }

    public NettyServer(Integer port) {
        this.setPort(port);
    }

    public static NettyServer create(Server server) {
        NettyServer ns = new NettyServer(null);
        ns.receiveAction = server.getReceiveAction();
        return ns;
    }

    @Override
    public void launch() throws IOException, InterruptedException {
        InetSocketAddress bindAddress;
        EventLoopGroup bossGroup = NettyServer.getEventLoopGroup();
        EventLoopGroup workerGroup = NettyConnection.getEventLoopGroup();
        ServerBootstrap b = new ServerBootstrap();
        ((ServerBootstrap)((ServerBootstrap)b.group(bossGroup, workerGroup).channel(NioServerSocketChannel.class)).childHandler((ChannelHandler)new ChannelInitializer<SocketChannel>(){

            public void initChannel(SocketChannel ch) throws Exception {
                Predicate<Message> returnHandler = m -> {
                    ch.writeAndFlush(m);
                    return true;
                };
                NettyInboundHandler inbound = new NettyInboundHandler(NettyServer.this.getReceiveAction(), returnHandler);
                ch.pipeline().addLast(new ChannelHandler[]{inbound, new NettyOutboundHandler()});
            }
        }).option(ChannelOption.SO_BACKLOG, (Object)128)).childOption(ChannelOption.SO_KEEPALIVE, (Object)true);
        ChannelFuture f = null;
        Integer port = this.getPort();
        if (port == null) {
            try {
                bindAddress = new InetSocketAddress("::", 18888);
                f = b.bind((SocketAddress)bindAddress).sync();
                port = 18888;
            }
            catch (Exception e) {
                port = 0;
            }
        }
        if (f == null) {
            bindAddress = new InetSocketAddress("::", (int)port);
            f = b.bind((SocketAddress)bindAddress).sync();
        }
        InetSocketAddress localAddress = (InetSocketAddress)f.channel().localAddress();
        this.setPort(localAddress.getPort());
        log.debug("Netty Server started on port: " + this.getPort());
        this.channel = f.channel();
    }

    protected Consumer<Message> getReceiveAction() {
        return this.receiveAction;
    }

    public static void main(String ... args) throws Exception {
        try (NettyServer server = new NettyServer(8000);){
            server.launch();
            server.waitForClose();
        }
    }

    @Override
    public void close() {
        if (this.channel != null) {
            this.channel.close();
        }
    }

    public void waitForClose() throws InterruptedException {
        this.channel.closeFuture().sync();
    }

    @Override
    public InetSocketAddress getHostAddress() {
        return (InetSocketAddress)this.channel.localAddress();
    }

    public void setReceiveAction(Consumer<Message> handler) {
        this.receiveAction = handler;
    }
}

