/*
 * Decompiled with CFR 0.152.
 */
package convex.net.impl.netty;

import convex.core.data.Blob;
import convex.core.data.Format;
import convex.core.message.Message;
import convex.core.util.Bits;
import convex.core.util.Utils;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelOutboundHandlerAdapter;
import io.netty.channel.ChannelPromise;

class NettyOutboundHandler
extends ChannelOutboundHandlerAdapter {
    NettyOutboundHandler() {
    }

    public void write(ChannelHandlerContext ctx, Object msg, ChannelPromise promise) {
        Message m = (Message)msg;
        Blob data = m.getMessageData();
        int mlen = Utils.checkedInt((long)data.count());
        int headLen = Format.getVLQCountLength((long)mlen);
        if (headLen <= 0) {
            throw new Error("Trying to write an empty message length " + mlen);
        }
        byte[] headBytes = new byte[headLen];
        Format.writeVLQCount((byte[])headBytes, (int)0, (long)mlen);
        ByteBuf headBuf = Unpooled.wrappedBuffer((byte[])headBytes, (int)0, (int)headLen);
        ByteBuf encodedBuf = Unpooled.wrappedBuffer((byte[])data.getInternalArray(), (int)data.getInternalOffset(), (int)mlen);
        ctx.write((Object)headBuf);
        ctx.write((Object)encodedBuf);
        ctx.flush();
    }

    public static void writeVLQCount(ByteBuf bb, long x) {
        if (x < 128L) {
            if (x < 0L) {
                throw new IllegalArgumentException("Negative count!");
            }
            byte single = (byte)x;
            bb.writeByte((int)single);
            return;
        }
        int bitLength = 64 - Bits.leadingZeros((long)x);
        int blen = (bitLength + 6) / 7;
        for (int i = blen - 1; i >= 1; --i) {
            byte single = (byte)(0x80L | x >>> 7 * i);
            bb.writeByte((int)single);
        }
        byte end = (byte)(x & 0x7FL);
        bb.writeByte((int)end);
    }
}

