/*
 * Decompiled with CFR 0.152.
 */
package convex.api;

import convex.api.Acquiror;
import convex.api.Convex;
import convex.core.ErrorCodes;
import convex.core.Result;
import convex.core.SourceCodes;
import convex.core.crypto.AKeyPair;
import convex.core.cvm.Address;
import convex.core.cvm.Keywords;
import convex.core.cvm.State;
import convex.core.cvm.transactions.ATransaction;
import convex.core.data.ACell;
import convex.core.data.Blob;
import convex.core.data.Hash;
import convex.core.data.SignedData;
import convex.core.exceptions.ResultException;
import convex.core.exceptions.TODOException;
import convex.core.lang.RT;
import convex.core.message.Message;
import convex.core.store.AStore;
import convex.core.store.Stores;
import convex.net.AConnection;
import convex.net.impl.netty.NettyConnection;
import convex.net.impl.nio.Connection;
import convex.peer.Server;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.HashMap;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConvexRemote
extends Convex {
    protected AConnection connection;
    protected static final Logger log = LoggerFactory.getLogger((String)ConvexRemote.class.getName());
    protected InetSocketAddress remoteAddress;
    private HashMap<ACell, CompletableFuture<Message>> awaiting = new HashMap();
    protected final Consumer<Message> returnMessageHandler = m -> {
        ACell id = m.getResultID();
        if (id != null) {
            HashMap<ACell, CompletableFuture<Message>> hashMap = this.awaiting;
            synchronized (hashMap) {
                AStore savedStore = Stores.current();
                try {
                    CompletableFuture<Message> cf = this.awaiting.get(id);
                    if (cf != null) {
                        boolean didComplete = cf.complete((Message)m);
                        if (!didComplete) {
                            log.warn("Message return future already completed with value: " + String.valueOf(cf.join()));
                        }
                        this.awaiting.remove(id);
                    }
                }
                catch (Exception e) {
                    log.warn("Unexpected error completing result", (Throwable)e);
                }
                finally {
                    Stores.setCurrent((AStore)savedStore);
                }
            }
        }
    };

    @Override
    public InetSocketAddress getHostAddress() {
        return this.remoteAddress;
    }

    protected ConvexRemote(Address address, AKeyPair keyPair) {
        super(address, keyPair);
    }

    protected void connectToPeer(InetSocketAddress peerAddress) throws IOException, TimeoutException, InterruptedException {
        this.remoteAddress = peerAddress;
        this.setConnection(NettyConnection.connect(peerAddress, this.returnMessageHandler));
    }

    public static ConvexRemote connect(InetSocketAddress peerAddress) throws IOException, TimeoutException, InterruptedException {
        ConvexRemote convex = new ConvexRemote(null, null);
        convex.connectToPeer(peerAddress);
        return convex;
    }

    public static ConvexRemote connectNetty(InetSocketAddress sa) throws InterruptedException, IOException {
        ConvexRemote convex = new ConvexRemote(null, null);
        convex.remoteAddress = sa;
        convex.setConnection(NettyConnection.connect(sa, convex.returnMessageHandler));
        return convex;
    }

    public static ConvexRemote connectNIO(InetSocketAddress sa) throws InterruptedException, IOException, TimeoutException {
        ConvexRemote convex = new ConvexRemote(null, null);
        convex.remoteAddress = sa;
        convex.setConnection(Connection.connect(sa, convex.returnMessageHandler));
        return convex;
    }

    private CompletableFuture<Result> awaitResult(ACell resultID, long timeout) {
        if (resultID == null) {
            throw new IllegalArgumentException("Non-null return ID required");
        }
        AStore awaitingStore = Stores.current();
        CompletableFuture cf = new CompletableFuture();
        this.awaiting.put(resultID, cf);
        if (timeout > 0L) {
            cf = cf.orTimeout(timeout, TimeUnit.MILLISECONDS);
        }
        CompletionStage cr = cf.handle((m, e) -> {
            HashMap<ACell, CompletableFuture<Message>> hashMap = this.awaiting;
            synchronized (hashMap) {
                this.awaiting.remove(resultID);
            }
            Stores.setCurrent((AStore)awaitingStore);
            if (e != null) {
                this.sequence = null;
                return Result.fromException((Throwable)e);
            }
            Result r = m.toResult();
            if (r.getErrorCode() != null) {
                this.sequence = null;
            }
            return r;
        });
        return cr;
    }

    @Override
    public synchronized void reconnect() throws IOException, TimeoutException, InterruptedException {
        this.close();
        this.connectToPeer(this.remoteAddress);
    }

    protected void setConnection(AConnection conn) {
        AConnection curr = this.connection;
        if (curr == conn) {
            return;
        }
        if (curr != null) {
            this.close();
        }
        this.connection = conn;
    }

    @Override
    public boolean isConnected() {
        AConnection c = this.connection;
        return c != null && !c.isClosed();
    }

    @Override
    public CompletableFuture<State> acquireState() {
        AStore store = Stores.current();
        return this.requestStatus().thenCompose(status -> {
            Hash stateHash = RT.ensureHash((ACell)status.get(4L));
            if (stateHash == null) {
                return CompletableFuture.failedStage((Throwable)new ResultException(ErrorCodes.FORMAT, "Bad status response from Peer"));
            }
            return this.acquire(stateHash, store);
        });
    }

    @Override
    public CompletableFuture<Result> transact(SignedData<ATransaction> signed) {
        Message m = Message.createTransaction((long)this.getNextID(), signed);
        return this.message(m);
    }

    @Override
    public CompletableFuture<Result> query(ACell query, Address address) {
        Message m = Message.createQuery((long)this.getNextID(), (ACell)query, (Address)address);
        return this.message(m);
    }

    @Override
    public CompletableFuture<Result> messageRaw(Blob message) {
        throw new TODOException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CompletableFuture<Result> message(Message m) {
        AConnection conn = this.connection;
        if (conn == null) {
            return CompletableFuture.completedFuture(Result.CLOSED_CONNECTION);
        }
        ACell id = m.getRequestID();
        try {
            if (id == null) {
                boolean sent = conn.sendMessage(m);
                if (!sent) {
                    return CompletableFuture.completedFuture(Result.FULL_CLIENT_BUFFER);
                }
                return CompletableFuture.completedFuture(Result.SENT_MESSAGE);
            }
            HashMap<ACell, CompletableFuture<Message>> sent = this.awaiting;
            synchronized (sent) {
                boolean sent2 = conn.sendMessage(m);
                if (!sent2) {
                    return CompletableFuture.completedFuture(Result.FULL_CLIENT_BUFFER);
                }
                CompletableFuture<Result> cf = this.awaitResult(id, this.timeout);
                return cf;
            }
        }
        catch (Exception e) {
            Result r = Result.fromException((Throwable)e).withInfo(Keywords.SOURCE, (ACell)SourceCodes.COMM);
            return CompletableFuture.completedFuture(r);
        }
    }

    @Override
    public CompletableFuture<Result> requestStatus() {
        Message m = Message.createStatusRequest((long)this.getNextID());
        return this.message(m);
    }

    @Override
    public CompletableFuture<Result> requestChallenge(SignedData<ACell> data) {
        Message m = Message.createChallenge(data);
        return this.message(m);
    }

    @Override
    public <T extends ACell> CompletableFuture<T> acquire(Hash hash, AStore store) {
        Acquiror acquiror = Acquiror.create(hash, store, this);
        return acquiror.getFuture();
    }

    @Override
    public synchronized void close() {
        AConnection c = this.connection;
        if (c != null) {
            c.close();
        }
        this.connection = null;
        this.awaiting.clear();
    }

    @Override
    public String toString() {
        return "Remote Convex instance at " + String.valueOf(this.getHostAddress());
    }

    @Override
    public Server getLocalServer() {
        return null;
    }
}

