/*
 * Decompiled with CFR 0.152.
 */
package convex.api;

import convex.api.Convex;
import convex.core.ErrorCodes;
import convex.core.Result;
import convex.core.ResultContext;
import convex.core.cpos.Belief;
import convex.core.cpos.Block;
import convex.core.crypto.AKeyPair;
import convex.core.cvm.Address;
import convex.core.cvm.Peer;
import convex.core.cvm.PeerStatus;
import convex.core.cvm.State;
import convex.core.cvm.transactions.ATransaction;
import convex.core.data.ACell;
import convex.core.data.AccountKey;
import convex.core.data.Blob;
import convex.core.data.Hash;
import convex.core.data.Keyword;
import convex.core.data.SignedData;
import convex.core.data.prim.CVMLong;
import convex.core.message.Message;
import convex.core.store.AStore;
import convex.core.util.Utils;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeoutException;

public class ConvexDirect
extends Convex {
    protected Peer peer;
    private boolean isConnected = true;

    protected ConvexDirect(Address address, AKeyPair keyPair, Peer initial) {
        super(address, keyPair);
        this.peer = initial;
    }

    public static ConvexDirect create(AKeyPair peerKey, State state) {
        AccountKey key = peerKey.getAccountKey();
        PeerStatus ps = state.getPeer(key);
        if (ps == null) {
            throw new IllegalStateException("Peer does not exist in desired state");
        }
        Address cont = ps.getController();
        return new ConvexDirect(cont, peerKey, Peer.create((AKeyPair)peerKey, (State)state));
    }

    @Override
    public boolean isConnected() {
        return this.isConnected;
    }

    @Override
    public synchronized CompletableFuture<Result> transact(SignedData<ATransaction> signedTransaction) {
        try {
            CVMLong id = CVMLong.create((long)this.getNextID());
            Peer p = this.peer;
            Result failure = p.checkTransaction(signedTransaction);
            if (failure != null) {
                return CompletableFuture.completedFuture(failure.withID((ACell)id));
            }
            long ts = Utils.getCurrentTimestamp();
            Block block = Block.of((long)ts, (SignedData[])new SignedData[]{signedTransaction});
            p = p.updateTimestamp(ts);
            p = p.proposeBlock(block);
            p = p.mergeBeliefs(new Belief[0]);
            p = p.mergeBeliefs(new Belief[0]);
            p = p.mergeBeliefs(new Belief[0]);
            p = p.updateState();
            long blockNum = p.getPeerOrder().getBlockCount() - 1L;
            this.peer = p;
            Result result = p.getResult(blockNum, 0L);
            if (result == null) {
                result = Result.error((Keyword)ErrorCodes.UNEXPECTED, (String)"No result available?");
            }
            return CompletableFuture.completedFuture(result.withID((ACell)id));
        }
        catch (Exception e) {
            return CompletableFuture.completedFuture(Result.fromException((Throwable)e));
        }
    }

    @Override
    public CompletableFuture<Result> messageRaw(Blob message) {
        return null;
    }

    @Override
    public CompletableFuture<Result> message(Message message) {
        return null;
    }

    @Override
    public <T extends ACell> CompletableFuture<T> acquire(Hash hash, AStore store) {
        return null;
    }

    @Override
    public CompletableFuture<Result> requestStatus() {
        return null;
    }

    @Override
    public CompletableFuture<Result> requestChallenge(SignedData<ACell> data) {
        return null;
    }

    @Override
    public CompletableFuture<Result> query(ACell query, Address address) {
        CVMLong id = CVMLong.create((long)this.getNextID());
        ResultContext rc = this.peer.executeQuery(query, address);
        return CompletableFuture.completedFuture(Result.fromContext((ACell)id, (ResultContext)rc));
    }

    @Override
    public void close() {
        this.peer = null;
    }

    @Override
    public String toString() {
        return "Direct client with peer state: " + String.valueOf(this.peer.getConsensusState().getHash());
    }

    @Override
    public InetSocketAddress getHostAddress() {
        return null;
    }

    @Override
    public void reconnect() throws IOException, TimeoutException, InterruptedException {
        this.isConnected = true;
    }
}

