/*
 * Decompiled with CFR 0.152.
 */
package convex.net.message;

import convex.core.Belief;
import convex.core.Result;
import convex.core.data.ACell;
import convex.core.data.AVector;
import convex.core.data.Hash;
import convex.core.data.SignedData;
import convex.core.data.prim.CVMLong;
import convex.core.util.Utils;
import convex.net.Connection;
import convex.net.MessageType;
import convex.net.message.MessageRemote;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class Message {
    static final Logger log = LoggerFactory.getLogger((String)Message.class.getName());
    protected final ACell payload;
    protected final MessageType type;

    protected Message(MessageType type, ACell payload) {
        this.type = type;
        this.payload = payload;
    }

    public static MessageRemote create(Connection peerConnection, MessageType type, ACell payload) {
        return new MessageRemote(peerConnection, type, payload);
    }

    public static MessageRemote create(Connection peerConnection, ACell o) {
        return Message.create(peerConnection, MessageType.DATA, o);
    }

    public static Message createData(ACell o) {
        return Message.create(null, MessageType.DATA, o);
    }

    public static Message createBelief(SignedData<Belief> sb) {
        return Message.create(null, MessageType.BELIEF, sb);
    }

    public static Message createChallenge(SignedData<ACell> challenge) {
        return Message.create(null, MessageType.CHALLENGE, challenge);
    }

    public static Message createResponse(SignedData<ACell> response) {
        return Message.create(null, MessageType.RESPONSE, response);
    }

    public static Message createGoodBye(SignedData<ACell> peerKey) {
        return Message.create(null, MessageType.GOODBYE, peerKey);
    }

    public <T extends ACell> T getPayload() {
        return (T)this.payload;
    }

    public MessageType getType() {
        return this.type;
    }

    public ACell getErrorCode() {
        ACell et = ((AVector)this.payload).get(2);
        return et;
    }

    public String toString() {
        return "#message {:type " + this.getType() + " :payload " + Utils.print((Object)this.payload) + "}";
    }

    public CVMLong getID() {
        switch (this.type) {
            case QUERY: 
            case TRANSACT: {
                return (CVMLong)((AVector)this.payload).get(0);
            }
            case RESULT: {
                return (CVMLong)((Result)this.payload).getID();
            }
            case STATUS: {
                return (CVMLong)this.payload;
            }
        }
        return null;
    }

    public abstract boolean reportResult(Result var1);

    public abstract boolean reportResult(CVMLong var1, ACell var2);

    public abstract String getOriginString();

    public abstract boolean sendData(ACell var1);

    public abstract boolean sendMissingData(Hash var1);
}

