/*
 * Decompiled with CFR 0.152.
 */
package convex.peer;

import convex.core.Belief;
import convex.core.BeliefMerge;
import convex.core.Block;
import convex.core.Order;
import convex.core.State;
import convex.core.crypto.AKeyPair;
import convex.core.data.ABlobLike;
import convex.core.data.ACell;
import convex.core.data.AccountKey;
import convex.core.data.Blob;
import convex.core.data.Cells;
import convex.core.data.Format;
import convex.core.data.Index;
import convex.core.data.Ref;
import convex.core.data.SignedData;
import convex.core.exceptions.BadFormatException;
import convex.core.exceptions.InvalidDataException;
import convex.core.exceptions.MissingDataException;
import convex.core.util.LoadMonitor;
import convex.core.util.Utils;
import convex.net.Message;
import convex.net.MessageType;
import convex.peer.AThreadedComponent;
import convex.peer.Server;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BeliefPropagator
extends AThreadedComponent {
    private static final long AWAIT_BELIEFS_PAUSE = 60L;
    public static final int BELIEF_REBROADCAST_DELAY = 300;
    public static final int BELIEF_FULL_BROADCAST_DELAY = 500;
    public static final int BELIEF_BROADCAST_DELAY = 10;
    public static final int BELIEF_BROADCAST_POLL_TIME = 1000;
    private ArrayBlockingQueue<Message> beliefQueue = new ArrayBlockingQueue(200);
    static final Logger log = LoggerFactory.getLogger((String)BeliefPropagator.class.getName());
    long beliefReceivedCount = 0L;
    long lastBroadcastTime = 0L;
    long lastFullBroadcastTime = 0L;
    private long beliefBroadcastCount = 0L;
    Belief belief = null;
    private Consumer<SignedData<Order>> orderUpdateObserver;
    private Consumer<Belief> beliefUpdateObserver;
    private Belief lastFullBroadcastBelief;

    public BeliefPropagator(Server server) {
        super(server);
    }

    public boolean isRebroadcastDue() {
        return this.lastBroadcastTime + 300L < Utils.getCurrentTimestamp();
    }

    public long getBeliefBroadcastCount() {
        return this.beliefBroadcastCount;
    }

    public synchronized boolean queueBelief(Message beliefMessage) {
        return this.beliefQueue.offer(beliefMessage);
    }

    @Override
    protected void loop() throws InterruptedException {
        Belief incomingBelief = this.awaitBelief();
        boolean updated = this.maybeUpdateBelief(incomingBelief);
        if (updated) {
            this.server.updateBelief(this.belief);
            if (this.beliefQueue.isEmpty()) {
                Message trigger = Message.createBelief(this.belief);
                this.queueBelief(trigger);
            }
        }
        this.maybeBroadcast(updated);
        try {
            this.belief = (Belief)Cells.persist((ACell)this.belief);
        }
        catch (IOException e) {
            throw (RuntimeException)Utils.sneakyThrow((Throwable)e);
        }
        this.server.updateBelief(this.belief);
    }

    protected void maybeBroadcast(boolean updated) throws InterruptedException {
        long ts = Utils.getCurrentTimestamp();
        if (updated || ts > this.lastBroadcastTime + 300L) {
            this.lastBroadcastTime = ts;
            Message msg = null;
            try {
                if (ts > this.lastFullBroadcastTime + 500L) {
                    msg = this.createFullUpdateMessage();
                    this.lastFullBroadcastTime = ts;
                } else {
                    msg = this.createQuickUpdateMessage();
                }
            }
            catch (IOException e) {
                log.warn("IO Error attempting to create broadcast message", (Throwable)e);
            }
            if (msg != null) {
                this.doBroadcast(msg);
            } else {
                log.warn("null message in BeliefPropagator!");
            }
        }
    }

    @Override
    public void start() {
        this.belief = this.server.getBelief();
        super.start();
    }

    protected boolean maybeUpdateBelief(Belief newBelief) {
        boolean updated = this.maybeMergeBeliefs(newBelief);
        SignedData<Block> signedBlock = this.server.transactionHandler.maybeGetBlock();
        boolean published = false;
        if (signedBlock != null) {
            this.belief = this.belief.proposeBlock(this.server.getKeyPair(), signedBlock);
            if (log.isDebugEnabled()) {
                Block bl = (Block)signedBlock.getValue();
                log.debug("Block proposed: {} tx(s), size={}, hash={}", new Object[]{bl.getTransactions().count(), signedBlock.getMemorySize(), signedBlock.getHash()});
            }
            published = true;
        }
        if (updated || published) {
            this.observeBeliefUpdate(this.belief);
            return true;
        }
        return false;
    }

    private void observeBeliefUpdate(Belief b) {
        Consumer<Belief> obs = this.beliefUpdateObserver;
        if (obs != null) {
            obs.accept(b);
        }
    }

    protected boolean maybeMergeBeliefs(Belief ... newBeliefs) {
        try {
            long ts = Utils.getCurrentTimestamp();
            AKeyPair kp = this.server.getKeyPair();
            BeliefMerge mc = BeliefMerge.create((Belief)this.belief, (AKeyPair)kp, (long)ts, (State)this.server.getPeer().getConsensusState());
            Belief newBelief = mc.merge(newBeliefs);
            AccountKey key = mc.getAccountKey();
            Order oldOrder = this.belief.getOrder(key);
            Order newOrder = newBelief.getOrder(key);
            boolean beliefChanged = false;
            beliefChanged = oldOrder == null ? newOrder != null : (newOrder == null ? true : !newOrder.consensusEquals(oldOrder));
            this.belief = newBelief;
            return beliefChanged;
        }
        catch (MissingDataException e) {
            throw new Error("Missing data in belief merge: " + e.getMissingHash().toHexString(), e);
        }
        catch (InvalidDataException e) {
            throw new Error("Invalid data in belief merge!", e);
        }
    }

    private Belief awaitBelief() throws InterruptedException {
        ArrayList<Message> beliefMessages = new ArrayList<Message>();
        LoadMonitor.down();
        Message firstEvent = this.beliefQueue.poll(60L, TimeUnit.MILLISECONDS);
        LoadMonitor.up();
        if (firstEvent == null) {
            return null;
        }
        beliefMessages.add(firstEvent);
        this.beliefQueue.drainTo(beliefMessages);
        HashMap newOrders = this.belief.getOrdersHashMap();
        boolean anyOrderChanged = false;
        for (Message m : beliefMessages) {
            boolean changed = this.mergeBeliefMessage(newOrders, m);
            if (!changed) continue;
            anyOrderChanged = true;
        }
        if (!anyOrderChanged) {
            return null;
        }
        Belief newBelief = Belief.create((HashMap)newOrders);
        return newBelief;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected boolean mergeBeliefMessage(HashMap<AccountKey, SignedData<Order>> orders, Message m) {
        boolean changed = false;
        AccountKey myKey = this.server.getPeerKey();
        try {
            ++this.beliefReceivedCount;
            try {
                Object payload = m.getPayload();
                Collection a = Belief.extractOrders(payload);
                for (SignedData so : a) {
                    AccountKey key = so.getAccountKey();
                    try {
                        if (Cells.equals((ACell)myKey, (ACell)key)) continue;
                        if (orders.containsKey(key)) {
                            Order newOrder = (Order)so.getValue();
                            Order oldOrder = (Order)orders.get(key).getValue();
                            boolean replace = BeliefMerge.compareOrders((Order)oldOrder, (Order)newOrder);
                            if (!replace) continue;
                        }
                        if (!so.checkSignature()) {
                            log.warn("Bad Order signature");
                            this.server.getConnectionManager().alertBadMessage(m, "Bad Order Signature!!");
                            return changed;
                        }
                        so = (SignedData)Cells.persist((ACell)so);
                        this.observeOrderUpdate((SignedData<Order>)so);
                        orders.put(key, (SignedData<Order>)so);
                        changed = true;
                    }
                    catch (MissingDataException e) {
                        this.server.getConnectionManager().alertMissing(m, e, key);
                    }
                    catch (IOException e) {
                        log.warn("IO exception tryin to merge Order", (Throwable)e);
                        return changed;
                    }
                }
            }
            catch (MissingDataException e) {
                this.server.getConnectionManager().alertMissing(m, e, null);
            }
            return changed;
        }
        catch (BadFormatException | ClassCastException e) {
            this.server.getConnectionManager().alertBadMessage(m, Utils.getClassName((Object)e) + " merging Belief!!");
        }
        return changed;
    }

    private void observeOrderUpdate(SignedData<Order> so) {
        Consumer<SignedData<Order>> obs = this.orderUpdateObserver;
        if (obs != null) {
            obs.accept(so);
        }
    }

    private void doBroadcast(Message msg) throws InterruptedException {
        this.server.manager.broadcast(msg);
        ++this.beliefBroadcastCount;
    }

    private Message createFullUpdateMessage() throws IOException {
        ArrayList<ACell> novelty = new ArrayList<ACell>();
        Consumer<Ref> noveltyHandler = r -> {
            ACell o = r.getValue();
            novelty.add(o);
        };
        this.lastFullBroadcastBelief = this.belief = (Belief)Cells.announce((ACell)this.belief, noveltyHandler);
        Message msg = BeliefPropagator.createBelief((ACell)this.belief, novelty);
        long messageSize = msg.getMessageData().count();
        if ((double)messageSize >= 1.9E7) {
            log.warn("Long Belief Delta message: " + messageSize);
        }
        return msg;
    }

    private Message createQuickUpdateMessage() throws IOException {
        ArrayList<ACell> novelty = new ArrayList<ACell>();
        Consumer<Ref> noveltyHandler = r -> {
            ACell o = r.getValue();
            novelty.add(o);
        };
        AccountKey key = this.server.getPeerKey();
        Index orders = this.belief.getOrders();
        SignedData order = (SignedData)this.belief.getOrders().get((ABlobLike)key);
        if (order == null) {
            return null;
        }
        order = (SignedData)Cells.announce((ACell)order, noveltyHandler);
        orders = orders.assoc((ACell)key, (ACell)order);
        this.belief = this.belief.withOrders(orders);
        Message msg = BeliefPropagator.createBelief((ACell)order, novelty);
        long messageSize = msg.getMessageData().count();
        if ((double)messageSize >= 1.9E7) {
            log.warn("Long Belief Delta message: " + messageSize);
        }
        return msg;
    }

    private static Message createBelief(ACell payload, List<ACell> novelty) {
        int n = novelty.size();
        if (n == 0) {
            novelty.add(n, payload);
        } else if (!payload.equals(novelty.get(n - 1))) {
            novelty.add(n, payload);
        }
        Blob data = Format.encodeDelta(novelty);
        return Message.create(MessageType.BELIEF, null, data);
    }

    public Belief getLastBroadcastBelief() {
        return this.lastFullBroadcastBelief;
    }

    @Override
    protected String getThreadName() {
        return "Belief propagator thread on port " + this.server.getPort();
    }

    public void setOrderUpdateObserver(Consumer<SignedData<Order>> orderUpdateObserver) {
        this.orderUpdateObserver = orderUpdateObserver;
    }

    public void setBeliefUpdateObserver(Consumer<Belief> observer) {
        this.beliefUpdateObserver = observer;
    }
}

