/*
 * Decompiled with CFR 0.152.
 */
package convex.peer;

import convex.core.store.AStore;
import convex.core.store.Stores;
import convex.core.util.LoadMonitor;
import convex.peer.Server;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AThreadedComponent {
    private static final Logger log = LoggerFactory.getLogger((String)AThreadedComponent.class.getName());
    protected final Server server;
    protected final Thread thread;

    public double getLoad() {
        return LoadMonitor.getLoad((Thread)this.thread);
    }

    protected AThreadedComponent(Server server) {
        this.server = server;
        this.thread = new Thread(new ComponentTask());
    }

    protected abstract void loop() throws InterruptedException;

    protected abstract String getThreadName();

    public void start() {
        String name = this.getThreadName();
        this.thread.setName(name);
        log.trace("Thread started: {}", (Object)name);
        this.thread.setDaemon(true);
        this.thread.start();
    }

    public void close() {
        Thread t = this.thread;
        t.interrupt();
    }

    public void finalize() {
        this.close();
    }

    private class ComponentTask
    implements Runnable {
        private ComponentTask() {
        }

        @Override
        public void run() {
            Stores.setCurrent((AStore)AThreadedComponent.this.server.getStore());
            while (AThreadedComponent.this.server.isRunning() && !Thread.currentThread().isInterrupted()) {
                try {
                    AThreadedComponent.this.loop();
                }
                catch (InterruptedException e) {
                    log.trace("Component thread interrupted: {}", (Object)AThreadedComponent.this.thread);
                    Thread.currentThread().interrupt();
                    break;
                }
            }
            log.trace("Component thread stopping: {}", (Object)AThreadedComponent.this.thread);
            AThreadedComponent.this.close();
        }
    }
}

