/*
 * Decompiled with CFR 0.152.
 */
package convex.peer;

import convex.core.State;
import convex.core.crypto.AKeyPair;
import convex.core.data.ACell;
import convex.core.data.AMap;
import convex.core.data.AccountKey;
import convex.core.data.Keyword;
import convex.core.data.Keywords;
import convex.core.data.Lists;
import convex.core.init.Init;
import convex.core.lang.RT;
import convex.core.store.AStore;
import convex.core.store.Stores;
import convex.peer.Config;
import convex.peer.ConfigException;
import convex.peer.ConnectionManager;
import convex.peer.LaunchException;
import convex.peer.Server;
import java.io.IOException;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class API {
    protected static final Logger log = LoggerFactory.getLogger((String)API.class.getName());

    public static Server launchPeer(Map<Keyword, Object> peerConfig) throws LaunchException, InterruptedException, ConfigException {
        HashMap<Keyword, Object> config = new HashMap<Keyword, Object>(peerConfig);
        Config.ensureFlags(config);
        Config.checkKeyStore(config);
        AStore tempStore = Stores.current();
        try {
            InetAddress ip;
            Object store = Config.ensureStore(config);
            Stores.setCurrent(store);
            Config.ensurePeerKey(config);
            Config.ensureGenesisState(config);
            if (config.containsKey(Keywords.URL) && !config.containsKey(Keywords.BIND_ADDRESS) && !(ip = InetAddress.getByName((String)config.get(Keywords.URL))).isAnyLocalAddress() && !ip.isLoopbackAddress()) {
                config.put(Keywords.BIND_ADDRESS, "0.0.0.0");
            }
            Server server = Server.create(config);
            server.launch();
            Server server2 = server;
            return server2;
        }
        catch (IOException e) {
            throw new LaunchException("Peer launch failed", e);
        }
        finally {
            Stores.setCurrent((AStore)tempStore);
        }
    }

    public static Server launchPeer() throws InterruptedException, ConfigException, LaunchException {
        AKeyPair kp = AKeyPair.generate();
        State genesis = Init.createState((List)Lists.of((Object[])new Object[]{kp.getAccountKey()}));
        HashMap<Keyword, Object> config = new HashMap<Keyword, Object>();
        config.put(Keywords.KEYPAIR, kp);
        config.put(Keywords.STATE, genesis);
        return API.launchPeer(config);
    }

    public static List<Server> launchLocalPeers(List<AKeyPair> keyPairs, State genesisState) throws InterruptedException, ConfigException, LaunchException {
        return API.launchLocalPeers(keyPairs, genesisState, null);
    }

    public static List<Server> launchLocalPeers(List<AKeyPair> keyPairs, State genesisState, int[] peerPorts) throws InterruptedException, ConfigException, LaunchException {
        Server server;
        int count = keyPairs.size();
        ArrayList<Server> serverList = new ArrayList<Server>();
        HashMap<Keyword, Object> config = new HashMap<Keyword, Object>();
        config.put(Keywords.PORT, null);
        config.put(Keywords.STATE, genesisState);
        config.put(Keywords.AUTO_MANAGE, true);
        for (int i = 0; i < count; ++i) {
            AKeyPair keyPair = keyPairs.get(i);
            config.put(Keywords.KEYPAIR, keyPair);
            if (peerPorts != null) {
                if (peerPorts.length > i) {
                    config.put(Keywords.PORT, peerPorts[i]);
                } else {
                    config.put(Keywords.PORT, 0);
                }
            }
            server = API.launchPeer(config);
            serverList.add(server);
        }
        Server genesisServer = (Server)serverList.get(0);
        genesisServer.setHostname("localhost:" + genesisServer.getPort());
        for (int i = 1; i < count; ++i) {
            server = (Server)serverList.get(i);
            ConnectionManager cm = server.getConnectionManager();
            cm.connectToPeer(genesisServer.getHostAddress());
            genesisServer.getConnectionManager().connectToPeer(server.getHostAddress());
            server.setHostname("localhost:" + server.getPort());
        }
        return serverList;
    }

    public static List<AccountKey> listPeers(AStore store) throws IOException {
        AMap data = (AMap)store.getRootData();
        ArrayList<AccountKey> results = new ArrayList<AccountKey>();
        long n = data.count();
        int i = 0;
        while ((long)i < n) {
            ACell k = data.entryAt((long)i).getKey();
            AccountKey ak = RT.ensureAccountKey((ACell)k);
            if (ak != null) {
                results.add(ak);
            }
            ++i;
        }
        return results;
    }
}

