/*
 * Decompiled with CFR 0.152.
 */
package convex.net;

import convex.core.Result;
import convex.core.data.ACell;
import convex.core.data.prim.CVMLong;
import convex.core.exceptions.BadFormatException;
import convex.core.exceptions.MissingDataException;
import convex.core.store.Stores;
import convex.net.Message;
import convex.net.MessageType;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ResultConsumer
implements Consumer<Message> {
    private static final Logger log = LoggerFactory.getLogger((String)ResultConsumer.class.getName());

    @Override
    public void accept(Message m) {
        MessageType type = m.getType();
        switch (type) {
            case DATA: {
                this.handleDataProvided(m);
                break;
            }
            case REQUEST_DATA: {
                this.handleDataRequest(m);
                break;
            }
            case RESULT: {
                this.handleResultMessage(m);
                break;
            }
            default: {
                log.error("Message type ignored: ", (Object)type);
            }
        }
    }

    private void handleDataProvided(Message m) {
    }

    private void handleDataRequest(Message m) {
        try {
            Message response = m.makeDataResponse(Stores.current());
            m.returnMessage(response);
        }
        catch (BadFormatException e) {
            m.closeConnection();
        }
    }

    private final void handleResultMessage(Message m) {
        try {
            Result result = (Result)m.getPayload();
            CVMLong cid = m.getID();
            long id = cid != null ? cid.longValue() : -1L;
            this.handleResult(id, result);
        }
        catch (BadFormatException | MissingDataException e) {
            log.warn("Exception handling result", e);
        }
    }

    protected void handleResult(long id, Result result) {
        ACell rv = result.getValue();
        ACell err = result.getErrorCode();
        if (err != null) {
            this.handleError(id, err, rv);
        } else {
            this.handleNormalResult(id, rv);
        }
    }

    protected void handleError(long id, ACell code, ACell errorMessage) {
        log.warn("UNHANDLED ERROR RECEIVED: {} :  {}", (Object)code, (Object)errorMessage);
    }

    protected void handleNormalResult(long id, ACell value) {
        log.debug("UNHANDLED RESULT RECEIVED: id={}, value={}", (Object)id, (Object)value);
    }
}

